/**
 * 会议软件套餐
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Form, Tabs } from "antd";
import SoftwareMeal from "./SoftwareMeal";
import BuyResource from "./BuyResource/index";
import OrderInquiry from "./OrderInquiry";
import "../meeting.less";
import { ThemeProvider } from "styled-components";
const { TabPane } = Tabs;

@connect(state => ({}))
@Form.create()
export default class BuySetMeal extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      mobilePhone: "",
      paymentStatus: false,
      confirmStatus: false, //确认订单的状态
      verificationName: "获取验证码", //验证码按钮名称
      selectValue: null, //选中的列表值
      checkbox: false, //是否点击了同意按钮
      keyTab: "1",
      randomNum: 1 //随机值
    };
  }
  changeKeyTab(value) {
    this.setState({
      randomNum: Math.random(),
      keyTab: value
    });
  }
  render() {
    return (
      <div style={{ margin: 16 }}>
        <Tabs
          defaultActiveKey={this.state.keyTab}
          className="3"
          key={this.state.randomNum}
        >
          <TabPane tab="会议软件套餐" key="1">
            <SoftwareMeal changeKeyTab={value => this.changeKeyTab(value)} />
          </TabPane>
          <TabPane tab="购买会议资源" key="2">
            <BuyResource changeKeyTab={value => this.changeKeyTab(value)} />
          </TabPane>
          <TabPane tab="订单管理" key="3">
            <OrderInquiry />
          </TabPane>
        </Tabs>
      </div>
    );
  }
}
