/**
 * 选择增值服务
 */
import React, { Component } from "react";
import { Form } from "antd";
import "../../meeting.less";
import { getProductList } from "../../../../services/api";
import StandardComponent from "./StandardComponent";

@Form.create()
export default class SelectAddServices extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      addServicesList: [], //请求后台返回的资源列表
      buyAddServices: [] //用户选择的资源
    };
  }
  componentDidMount() {
    this._getProductList();
  }
  //获取资源列表
  _getProductList() {
    getProductList({
      productCategoryType: 11,
      productServiceType: 3
    }).then(res => {
      if (res.retType === "0") {
        this.setState({
          addServicesList: res.data
        });
        let buyAddServices = [];
        res.data.length > 0 &&
          res.data.map((item, index) => {
            buyAddServices.push({
              name: item.name,
              productServiceType:item.productServiceType,
              productInfoList: []
            });
            item.productInfoList.length > 0 &&
              item.productInfoList.map(infoList => {
                buyAddServices[index].productInfoList.push({
                  productName: infoList.name,
                  // productStatus: infoList.productStatus,
                  // productTypeUrl: infoList.productTypeUrl,
                  productBuyModeId:
                    infoList.productBuyModeList.length > 0 &&
                    infoList.productBuyModeList[0].productBuyModeId, //产品购买方式id
                  productBuyMode:
                    infoList.productBuyModeList.length > 0 &&
                    infoList.productBuyModeList[0].productBuyMode, //购买方式
                  eachAmount:
                    infoList.productBuyModeList.length > 0 &&
                    infoList.productBuyModeList[0].amount, //单价
                  unit:
                    infoList.productBuyModeList.length > 0 &&
                    infoList.productBuyModeList[0].unit, //单位
                  duration: 1, //时长
                  num: 0, //数量
                  amount: 0 //总价
                });
              });
          });
        this.setState({ buyAddServices });
      }
    });
  }
  render() {
    const { addServicesList, buyAddServices } = this.state;
    return (
      <div className="resource-list">
        <div className="label">可选购买电话外呼、直播通道、录播空间等服务</div>
        {addServicesList.length > 0 &&
          addServicesList.map((item, index) => {
            return (
              <StandardComponent
                key={{index}}
                itemData={item}
                buyList={buyAddServices[index]}
                changeBuyList={data => {
                  const buyList = JSON.parse(JSON.stringify(buyAddServices));
                  buyList[index] = data;
                  this.setState(
                    {
                      buyAddServices: buyList
                    },
                    () => {
                      this.props.changeTotal(this.state.buyAddServices);
                    }
                  );
                }}
              />
            );
          })}
      </div>
    );
  }
}
