import React, { Component } from "react";
import { connect } from "dva";
import { Form, Input, Button, DatePicker, Table, Tabs } from "antd";
import moment from "moment";
import store from "store";

import GetPlanBook from "../../Enterprise/Organization/getPlanBook";

import { enterpriseInsComInsGetInsBootPage } from "../../../services/api";
import "./InsuranceMangerment.less";
import "./insurancePlan.less";

const { RangePicker } = DatePicker;

const dateFormat = "YYYY-MM-DD";
const { TabPane } = Tabs;
@connect(state => ({
  global: state.global
}))
@Form.create()

/**
 * 企业保险列表页
 */
export default class InsuranceBasic extends Component {
  constructor(props, context) {
    super(props, context);
    console.log(props, context, "props,context");
    let { regProvince } = this.props.global.companyInfo;
    if (regProvince !== "450000" && regProvince !== "610000") {
      regProvince = "100000";
    }

    this.state = {
      keyword: "", //输入框的的值
      startTime: "", //开始时间
      endTime: "", //结束时间
      dataSource: [],
      regProvince,
      accessbookvisible: false,
      pagenav: {
        pageNumber: 1,
        pageSize: 10,
        showQuickJumper: true,
        showSizeChanger: true,
        showTotal: total => `总共 ${total} 条`,
        onShowSizeChange: (pageNumber, pageSize) => {
          const pagenav = Object.assign({}, this.state.pagenav);
          pagenav.pageNumber = pageNumber;
          pagenav.pageSize = pageSize;
          this.setState({ pagenav });
          setTimeout(() => {
            this.taskComShiftPage();
          });
        },
        onChange: (page, pageSize) => {
          const pagenav = Object.assign({}, this.state.pagenav);
          pagenav.pageNumber = page;
          pagenav.pageSize = pageSize;
          this.setState({ pagenav });
          setTimeout(() => {
            this.enterpriseInsComInsGetInsBootPage();
          });
        },
        total: 0
      }
    };
  }

  componentDidMount() {
    this.enterpriseInsComInsGetInsBootPage();
  }

  resetQueryCond = () => {
    this.setState(
      {
        keyword: "", //输入框的的值
        startTime: "", //开始时间
        endTime: "" //结束时间
      },
      () => {
        this.enterpriseInsComInsGetInsBootPage();
      }
    );
  };

  //时间选择
  onChangeTime = (date, dateString) => {
    // console.log('获得的日期>>>>>>>>>>>>>',dateString);
    this.setState({ startTime: dateString[0], endTime: dateString[1] });
  };

  //输入框的模糊查询关键字
  inputTracknameChange = e => {
    // console.log('获得的模糊查询>>>>>>>>>>>>>',e.target.value.trim());
    this.setState({ keyword: e.target.value.trim() });
  };

  /* 方案书分页查询 */
  enterpriseInsComInsGetInsBootPage = () => {
    const { pageSize, pageNumber } = this.state.pagenav;
    const { keyword, startTime, endTime } = this.state;
    enterpriseInsComInsGetInsBootPage({
      pageSize,
      pageNumber,
      keyword,
      startTime,
      endTime
    })
      .then(res => {
        console.log(res, "方案书分页查询-res");
        const pagenav = { ...this.state.pagenav };
        pagenav.total = res.data.total;
        const dataSource = res.data.data.map(val => {
          const obj = { ...val };
          obj.key = val.comInsBootSchemeId;
          return obj;
        });
        this.setState({ dataSource, pagenav });
      })
      .catch(err => console.log(err));
  };

  //表格渲染
  renderOrderList = () => {
    const columns = [
      {
        title: "保险方案书名称",
        dataIndex: "insBootName",
        key: "insBootName"
      },
      {
        title: "投保人",
        dataIndex: "comName",
        key: "comNames"
      },
      {
        title: "企业人数",
        dataIndex: "comPerNum",
        key: "comPerNum"
      },
      {
        title: "联系人",
        dataIndex: "contactper",
        key: "contactper"
      },
      {
        title: "联系方式",
        dataIndex: "contactPhone",
        key: "contactPhone"
      },
      {
        title: "申请时间",
        dataIndex: "createTime",
        key: "createTime"
      },
      {
        title: "操作",
        render: (text, record) => {
          const { regProvince } = this.state;
          const { proCode, comPerNum } = record;
          return (
            <div
              onClick={() => {
                const a = regProvince + proCode;
                store.set("bookNum", { proCode, comPerNum });
                this.props.history.push("/InsuranceManagement/100000TYX-PA-1");
              }}
              style={{ color: "#0f71ff" }}
            >
              查看
            </div>
          );
        }
      }
    ];

    return (
      <Table
        pagination={this.state.pagenav}
        dataSource={this.state.dataSource}
        columns={columns}
      />
    );
  };

  render() {
    return (
      <div className="insurancePlan">
        <Tabs>
          <TabPane tab="保险方案书" key="1">
            <div className="Insurance">
              <div className="form">
                <label>
                  关键字：
                  <Input
                    style={{ width: 214, marginBottom:'16px',marginRight: 16 }}
                    placeholder="请输入保险名称/保险公司名称"
                    onChange={this.inputTracknameChange}
                    value={this.state.keyword}
                    maxLength={20}
                  />
                </label>

                <label style={{ marginRight: 16, marginBottom:'16px',display:'inline-block' }}>
                  申请日期：
                  <RangePicker
                    format={dateFormat}
                    onChange={this.onChangeTime}
                    value={[
                      this.state.startTime === ""
                        ? null
                        : moment(this.state.startTime, dateFormat),
                      this.state.endTime === ""
                        ? null
                        : moment(this.state.endTime, dateFormat)
                    ]}
                  />
                </label>
                <Button
                  onClick={() => {
                    this.enterpriseInsComInsGetInsBootPage();
                  }}
                  style={{ marginRight: 16, marginBottom:'16px' }}
                  type="primary"
                >
                  搜索
                </Button>
                <Button style={{ marginBottom:'16px' }} onClick={this.resetQueryCond}>
                  重置
                </Button>
              </div>
              <div className="btnbox" >
                <Button
                  type="primary"
                  onClick={() => {
                    this.setState({ accessbookvisible: true });
                  }}
                >
                  获取保险方案
                </Button>
              </div>
              {this.renderOrderList()}
            </div>
            <GetPlanBook
              okorcancel={(field, value) => {
                this.setState({ [field]: value });
              }}
              accessbookvisible={this.state.accessbookvisible}
            />
          </TabPane>
        </Tabs>
      </div>
    );
  }
}
