import React, { Component } from "react";
import SearchForm from './SearchForm';
import PTable from '../../../../../components/Pro/PTable';
import columnFun from './columns';
import { saveInsBlbMinusPreservationByNotIncluded } from '../../../../../services/api';
import $modal from '../../../../../utils/modal';
import
// ExcelButtonOline, 
{ excelButtonHOC } from '../../../../../components/ExcelButtonOline';
import {
  Alert,
  Popover,
  Button
} from "antd";
import { connect } from 'dva';
@connect(state => ({
  global: state.global
}))
export default class NotInput extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      canExport: false, //是否可以导出表格
      forceUpdate: false, //是否更新表格
      pageParm: { //表格参数
        pageSize: '10',
        pageNumber: '1',
      },
      searchDataReady: false, //筛选参数是否准备就绪
      orderId: '',
      selectedRows: [], //表格中选中的数组
      selectedRowKeys: []
    };
  }
  componentDidMount() {

  }
  _search = (values, orderId, search) => {
    if (search == 'search') {
      this.setState({
        canExport: true
      });
    }
    this.setState({
      pageParm: {
        ...this.state.pageParm,
        ...values
      },
      orderId,
      searchDataReady: true
    });
  }
  _updateTable = () => {
    this.setState({
      forceUpdate: true
    }, () => {
      this.setState({
        forceUpdate: false
      });
    });
  }
  render() {
    const columns = columnFun.call(this);
    return (
      <div style={{ padding: 15, paddingTop: 0 }}>
        <Alert
          message={<div>本页面显示的是您通过平台购买保险时，投保的人员未导入到系统中的人员信息，您只可通过此页面为其进行减员保全。</div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        <SearchForm
          style={{ marginLeft: 10 }}
          onSearch={this._search}
        />
        <Popover
          content={
            <div style={{ padding: '5px 10px' }}>
              <p style={{ margin: 0 }}>请选择保单</p>
            </div>
          }
          title="温馨提示"
        >
          <Button type="primary" style={{ marginTop: 15 }}
            disabled={this.state.orderId == ''}
            onClick={() => {
              $modal(
                `是否对${name}进行减员操作`,
                <span>关联线下保单，则直接移除关联；<br />关联线上保单，则提交减员申请,一次最多减员10人。</span>,
                [
                  {
                    text: '确定',
                    type: 'primary',
                    onPress: () => {
                      const { orderId, selectedRows } = this.state;
                      if (selectedRows.length > 10) {
                        return $modal(
                          '一次最多减员10人',
                          '',
                          [{ text: '确定', type: 'primary' }],
                          'error'
                        );
                      }
                      const insPerDetailIdsArr = selectedRows.map(item => item.insPerDetailId);
                      const insPerDetailIds = insPerDetailIdsArr.join(',');
                      saveInsBlbMinusPreservationByNotIncluded({ insPerDetailIds, orderId }).then(res => {
                        $modal(
                          '提交减员申请成功！',
                          <span style={{ color: 'orange' }}>注：线上保单减员时，需要等待保险公司审核，请在<a>批单申请记录</a>中查看进度。</span>,
                          [{ text: '确定', type: 'primary' }],
                          'success'
                        );
                        this._updateTable();
                      }).catch(err => {
                        if (err.retType == '-1') {
                          notification.error({
                            message: err.msg
                          });
                        }
                      });
                    }
                  },
                  {
                    text: '取消'
                  }
                ]
              );
            }}
          >
            批量减员
          </Button>
        </Popover>
        <Popover
          content={
            <div style={{ padding: 10 }}>搜索后可导出</div>
          }
        >
          {/* <ExcelButtonOline
            disabled={!this.state.canExport}
            method="POST"
            style={{ marginLeft: "15px" }}
            params={this.state.pageParm}
            apiurl={"/enterprise/ins/com-ins/export-not-included-insurance-per-list"}
            downloadname={this.props.global.companyInfo.comName + "_已投保未录入人员"}
          >
            导出筛选结果为excel
          </ExcelButtonOline> */}
          {
            excelButtonHOC({
              disabled: !this.state.canExport,
              style: {marginLeft: 15},
              method: 'POST',
              params: this.state.pageParm,
              apiurl: "/enterprise/ins/com-ins/export-not-included-insurance-per-list",
              downloadname: this.props.global.companyInfo.comName + "_已投保未录入人员",
              children: '导出筛选结果为excel'
            }, Button)
          }
        </Popover>
        {
          this.state.searchDataReady &&
          <PTable
            style={{ marginTop: 20 }}
            columns={columns}
            url="findNotIncludedInsurancePerList"
            pageParm={this.state.pageParm}
            forceUpdate={this.state.forceUpdate}
            pagination={{
              showTotal: total => `总共 ${total} 条`
            }}
            rowSelection={{
              onChange: (selectedRowKeys, selectedRows) => {
                this.setState({
                  selectedRows,
                  selectedRowKeys
                });
              },
              selectedRowKeys: this.state.selectedRowKeys
            }}
            dateChange={data => {
              this.props.getTotal && this.props.getTotal(data.other);
              this.setState({
                selectedRowKeys: [],
                selectedRows: []
              });
            }}
          />
        }
      </div>
    );
  }
}
