import React, { PureComponent } from 'react';
import style from "styled-components";
import { Card ,List, Avatar,Table,Button } from 'antd';
import "./InsuranceMangerment.less";
import TitleBlue from '../../../assets/images/title_blue.png';
import TitleYellow from '../../../assets/images/title_yellow.png';
import {
  getOnlineInsBlbLink,//在线购买保险
  enterpriseInsComInsGetBootSchemePdfLink,//方案书pdf下载
} from "../../../services/api";
import store from "store";
export default class MarketPingan2 extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      onlineUrl: "",//购买在线保险的url  
      province:"", 
      downbookUrl:"",//方案书下载
    };
  }
  componentDidMount() {
    //初始化参数，修复页面切换参数不会初始化的bug！！
    this.messageOnline();
    this.getpdfbook();
  }
    //在线购买保险的链接生成
    messageOnline = () => {
      getOnlineInsBlbLink({
        // comId: this.props.global.companyInfo.comId
      }).then(data => {
        this.setState({
          onlineUrl: data.data
        });
      });
    };
        ////方案书pdf下载
        getpdfbook = () => {
          enterpriseInsComInsGetBootSchemePdfLink({
            proCode:store.get("bookpdf")["proCode"],
            province:store.get("bookpdfs")["regProvince"],
          }).then(data => {  
            this.setState({
              downbookUrl: data.data
            });
            console.log("方案书pdf下载",data.data);
          });
        };   
        downBookClick = () => {
          window.open(this.state.downbookUrl);
        }
    handleonline = () => {
      window.open(this.state.onlineUrl);
    }
    handleotherbook = () => {
      this.props.history.push(
        // 跳转到1-4-4
        // "/Organization/departmentmanagement?otherbook=init"
        "/PersonnelRecruitment/departmentmanagement?otherbook=init"
      );

    }   
  render() {
    const contentdata = [
      {
        title:  <span>预计投保人数：{store.get("bookNum")["comPerNum"]}人</span>,
        description:<div className="totalcost">
                      <img src={TitleYellow} className="totalcostimg"/>
                      <span className="totalcostcount">预估保费：</span>
                      <span>{(store.get("bookNum")["comPerNum"]) * 260}元</span>
                      <span className="totalcostremark">&nbsp;（投保人数*该方案保费/人）</span>
                    </div>,
      },
      {
        title: '产品优势',
        description:'最佳人气版，对保安人员全年工作、生活、交通出行的意外风险提供全方位保障，附加烈士褒扬金，保安人员的护身盾牌。',
      },
    ];
    const servicedata = [
        {
          title: '人员增减服务',
          description:<div>
                        <p>1.支持在线完成人员增、减、替换，方便快捷。</p>
                        <p>2.账单式管理，人员批改明细一目了然。</p>
                        <p>3.专业客服7x24小时在线为您服务。</p>
                      </div>,
        },
        {
          title: '理赔全流程协助服务',
          description:<div>
                        <p>1.在线自助报案，1对1理赔专员全程协助处理。</p>
                        <p>2.在线上传理赔资料，专业评估师为您争取更多利益。</p>
                        <p>3.最快当天内赔付，理赔实时进度尽在掌握。</p>
                      </div>,
        },
      ];
      const riskanaylysisdata = [
        {
          title: '保安员工的风险',
          description:<div>
                        <p>1、意外身故风险</p>
                        <p>尤其是在上班工作期间，保安人员发生意外的情况较其他行业高出许多。</p>
                        <p>2、疾病身故风险</p>
                        <p>保安人员由于疾病导致身故，将给保安公司及该员工家庭带来巨大的损失。</p>
                        <p>3、丧失劳动力风险</p>
                        <p>由于保安行业特殊性，保安人员在职期间极可能遭遇失能风险，导致无法正常工作。</p>
                        <p>4、医疗费用支出风险</p>
                        <p>保安人员由于遭受意外事故或疾病而进行的各项医疗费用如果将由贵保安公司或员工个人承担，这无疑也增加了额外的负担。</p>
                        <p>5、重大疾病风险</p>
                        <p>一旦保安人员身患重大疾病，不仅会丧失劳动能力，还要花费巨额的医疗费用，需要专人护理，因此而需要的费用支出普通家庭难以承受。</p>
                      </div>,
        },
        {
          title: '保安公司的风险',
          description:<div>
                        <p>1、经济风险</p>
                        <p>员工的任何风险造成的费用支出如果需要保安公司承担，这无疑增加了保安公司的负担。</p>
                        <p>2、管理风险</p>
                        <p>因为员工的风险造成的各项经济、法律纠纷，都将给企业的正常管理及品牌带来不必要的负面影响。</p>
                        <p>3、人才流失的风险</p>
                        <p>人才资源已然成为体现企业核心竞争力的主要组成部分，一旦，高级管理人才和技术骨干流失，都将给企业的经营带来巨大损失。</p>
                        <p>
                        对于保安公司而言，其核心竞争力集中体现在公司的吸引力、凝聚力、员工的忠诚度和工作的创造性，这些都需要有一个良好的工作环境和完善的保障制度，以免除员工的后顾之忧，使其“轻装上阵”，全力以赴，并因此感受保安公司对保安人员切身利益的周到考虑和温暖呵护。因此，现代企业以保安团意险（责任险）为依托，建立保安员保障制度具有非常重要的意义。
                        </p>
                      </div>,
        },
        {
            title: '综合概括',
            description:<div>
                          <p style={{color:"#FF420F"}}>生活工作全覆盖的保障，可免除员工后顾之忧完善公司福利体系，吸引优秀人才增加企业核心竞争力同时有效转移企业经营风险，避免经济或是法律纠纷。</p>     
                        </div>,
        },
      ];
      const aboutus = [
        {
          title: '百川信',
          description:<div>
                        <p>百川信（厦门）网络信息服务有限公司是一家专注于风险管理领域的互联网平台公司。公司拥有风险管理的专业资质和互联网保险运营的长足经验，以传统产业模式十余年的经验积淀为保障，充分发挥互联网技术和垂直平台门户的优势，践行“互联网+金融保险+流程重塑”，续写风险管理领域的新篇章，推动公共安全管理行业的标准运作、精准定位和产业链升级。</p>                
                      </div>,
        },
        {
          title: '百保盾',
          description:<div>
                        <p>为满足公安机关监管需求、帮助保安企业规范管理、加快保安队伍职业化建设，百川信运用互联网+大数据可视化技术，率先搭建起“人员、位置、任务”三位一体的保安服务监管信息系统——百保盾。</p>
                      </div>,
        },
        {
          title: '百联保',
          description:<div>
                        <p>百川信凭借领先的互联网技术、丰富的业务经验和强大的运维能力，为保险产品供应者、分销商、需求方、政府监管部门及相关主体全力打造互联网金融保险整体解决方案平台——百联保。</p>
                      </div>,
        },
      ];
    const columns = [{
      title: '保险责任',
      dataIndex: 'name',
      render: text => <a >{text}</a>,
    }, {
      title: '保额',
      className: 'column-money',
      dataIndex: 'money',
    }];
    const liabilitydata = [{
      key: '1',
      name: '意外身故',
      money: '30万元',
    }, {
      key: '2',
      name: '意外伤残',
      money: '30万元',
    }, {
      key: '3',
      name: '意外医疗',
      money: '3万元 ',
    }, {
      key: '4',
      name: '意外住院津贴',
      money: '100元/天 ',
    }, {
      key: '5',
      name: '烈士褒扬金',
      money: '30 万元',
    },{
        key: '6',
        name: '营运汽车意外身故/伤残',
        money: '10万元',
      }, {
        key: '7',
        name: '轨道列车意外身故/伤残',
        money: '20万元',
      }, {
        key: '8',
        name: '飞机意外身故/伤残',
        money: '30万元 ',
      }, {
        key: '9',
        name: '轮船意外身故/伤残',
        money: '20万元 ',
      }, {
        key: '10',
        name: '保费',
        money: '260元/人',
      }];
    return (
      <Container className="insurancescheme">
      <h3 className="insurancetitle">平安是福保安团意险计划二</h3>
        <Card title="现代保安公司的风险暨风险需求分析">
          <List
          itemLayout="horizontal"
          dataSource={riskanaylysisdata}
          renderItem={item => (
            <List.Item>
              <List.Item.Meta
                avatar={<Avatar src={TitleBlue} style={{ }}/>}
                title={<a>{item.title}</a>}
                description={item.description}
              />
            </List.Item>
          )}
        />
        </Card>
        <p className="insurancetext">
          <span>尊敬的XXXX保安公司：</span>
          <br />
          <span>感谢您对平安是福保安团意险计划二的亲睐！ ！ ！</span>
          <br />
          <span>产品方案请细看</span>
        </p>
        <Card title="平安是福保安团意险计划二">
          <Table
            columns={columns}
            dataSource={liabilitydata}
            bordered
            pagination={false}
          />
          <List
          itemLayout="horizontal"
          dataSource={contentdata}
          renderItem={item => (
            <List.Item>
              <List.Item.Meta
                avatar={<Avatar src={TitleBlue} style={{ }}/>}
                title={<span>{item.title}</span>}
                description={item.description}
              />
            </List.Item>
          )}
          />
        </Card>
        <Card title="投保后我们为您提供">
          <List
          itemLayout="horizontal"
          dataSource={servicedata}
          renderItem={item => (
            <List.Item>
              <List.Item.Meta
                avatar={<Avatar src={TitleBlue} style={{ }}/>}
                title={<a>{item.title}</a>}
                description={item.description}
              />
            </List.Item>
          )}
        />
        </Card>
        <Card title="关于我们">
          <List
          itemLayout="horizontal"
          dataSource={aboutus}
          renderItem={item => (
            <List.Item>
              <List.Item.Meta
                avatar={<Avatar src={TitleBlue} style={{ }}/>}
                title={<a>{item.title}</a>}
                description={item.description}
              />
            </List.Item>
          )}
        />
        </Card>
        <div className="customerservice">
          <div className="customerservicetotle">
            <span className="customerservicetext">如有疑问，欢迎拨打百保盾客服电话：</span>
            <span className="customerservicephone">400-662-9696</span>
          </div>
          <div className="customerservicebtn">
            <Button onClick={this.downBookClick}>下载PDF</Button>
            <Button
            onClick={() => {
              window.print();
            }}
            >在线打印</Button>
            <Button onClick={this.handleotherbook}>获取其他方案</Button>
            <Button type="primary" onClick={this.handleonline}>立即购买</Button>
          </div>
        </div>
        {this.getpdfbook}
      </Container>
    );
  }
}

const Container = style.div`
  padding:24px;
  .insurancetitle{
    padding-bottom:13px;
    border-bottom: 1px solid #e8e8e8;
    font-size: 20px;
    color: #333333;
    font-weight:bold;
    font-family: PingFangSC-Medium;
  }
  .insurancetext{
    margin-top:10px;
    font-family: PingFangSC-Medium;
    font-size: 14px;
    color: #666666;
  }
  .ant-card{
    margin-top:15px;
  }
  .ant-card-body{
    padding:5px 12px;
  }
  .ant-card-head{
    background-color:#F5F9FF;
    padding:0;
  }
  .ant-card-head-title{
    margin-left:24px;
    color:#666666;
    font-weight:bold;
  }
  .ant-list-item-meta-avatar{
    width: 6px;
    height:6px;
    position:relative;
    top:7px;
    left:10px;
  }
  .ant-avatar{
    width: 6px;
    height:6px;
  }
  .ant-list-item-meta-title>a{
    color:#0F71FF;
  }
  .ant-list-item-meta-description{
    font-size:12px;
    color:#666666;
  }
  .ant-list-item-meta-description div p{
    margin-bottom: 0px;
    fontSize: 12px;
  }
  .totalcost{
    font-size:14px;
    color:#FF420F;
    margin-left:-12px;
  }
  .totalcostimg{
    margin-top:-3px;
  }
  .totalcostcount{
    margin-left:6px;
  }
  .totalcostremark{
    color:#2A2A2A;
  }
  .ant-table-thead tr th{
    color:#333333 ;
    font-size:12px;
    font-weight:bold;
   
  }
  .ant-table-row td{
    color:#666666 ;
    font-size:12px;
  }
  .ant-table-row td a{
    color:#666666 ;
    font-size:12px;
  }
  th.column-money,
  td.column-money {
    text-aligh:center;
  }
  .ant-table-wrapper{
    padding:10px 10px 0 10px;
  }
  .ant-table-tbody tr:nth-of-type(5) td:nth-of-type(1) a{
    color:#FF420F;
  }
  .ant-table-tbody tr:nth-of-type(5) td:nth-of-type(2){
    color:#FF420F;
  }
  .ant-table-tbody tr:nth-of-type(10) td:nth-of-type(2){
    color:#FF420F;
  }
  .customerservicetext{
    font-family: PingFangSC-Regular;
    font-size: 14px;
    color: #333333;
  }
  .customerservicephone{
    font-family: PingFangSC-Regular;
    font-size: 20px;
    color: #0F71FF;
  }
  .customerservice{
    padding:15px 0;
  }
  .customerservicetotle{
    float:left;
  }
  .customerservicebtn{
    float:right;
  }
  .customerservicebtn button{
    margin-left:5px;
  }
`;
