import React, { Component } from 'react';
import st from 'styled-components';
import { connect } from 'dva';
import { withRouter } from 'dva/router';
import {
  Input,
  Button,
  Alert,
  Popover,
  Select
} from 'antd';
// import $modal from '../../../../utils/modal';
import $nModal from '../../../../utils/modal/nModal';

import tablePage from '../../../../utils/hoc/tablePage';
import DepartSelect from '../../../../components/user/DepartSelect';
import { taskPerJointlyCardBatchNotice } from '../../../../services/apiSmartCard';
// import ExcelButtonOline from '../../../../components/ExcelButtonOline';
import columnFun from './columns';
import { excelButtonHOC } from '../../../../components/ExcelButtonOline';
const { Option } = Select;
@connect(state => ({
  global: state.global
}))
@tablePage()
@withRouter
export default class NotOpen extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      selectedRows: [],
      selectedRowKeys: []
    };
  }

  componentDidMount() {

  }


  // 表格渲染
  renderOrderList = () => {
    const columns = columnFun.call(this);
    const { PageTable, isInit } = this.props;
    if (!isInit) return;
    return (
      <PageTable
        style={{ marginTop: 20 }}
        columns={columns}
        url="getNoOpenJointlyPerList"
        rowSelection={{
          onChange: (selectedRowKeys, selectedRows) => {
            this.setState({
              selectedRows,
              selectedRowKeys
            });
          },
          selectedRowKeys: this.state.selectedRowKeys     
        }}
        pagination={{ showTotal: total => `总共 ${total} 条` }}
        // scroll={{ x: '2400px' }}
        dateChange={(e) => { 
          this.setState({
            selectedRows: [],
            selectedRowKeys: []
          });
        }}
      />
    );
  };

  render() {
    const { SearchForm, Form } = this.props;
    const { getFieldDecorator } = this.props.form;
    // const TreeSelecter = departSelecter(TreeSelect);
    return (
      <div>
        <Alert
          message={<div style={{ color: '#333' }}>
            <span>您可在此页面查看企业下有持保安员资格证且未开通保安员证联名卡的人员，可对人员进行发送站内信，告知其尽快申请开通。</span>
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />

        <SearchForm
          // onSearchClick={this.props.updateCount}
          arrange={values => {
            // 单选逻辑
            // if (/^\-1/.test(values.departId)) {
            //   values.departId = '-1';
            // } else {
            //   values.departId = values.departId.split('-')[0];
            // }

            // 多选逻辑
            values.departIds = values.departIds.map(({value}) => {
              if(/^\-1/.test(value)) {
                return '-1';
              }else {
                return value.split('-')[0];
              }
            }).join(',');
            // console.log(departId)
            return values;
          }}
        >
          <>
            {/* <Form.Item label="关键字">
              {getFieldDecorator('keyword', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入姓名/身份证号/手机号" />
              )}
            </Form.Item> */}
            <Form.Item label="姓名">
              {getFieldDecorator('name', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入姓名" />
              )}
            </Form.Item>
            <Form.Item label="手机号">
              {getFieldDecorator('mobilePhone', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入手机号码" />
              )}
            </Form.Item>
            <Form.Item label="身份证号">
              {getFieldDecorator('idCardNo', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入身份证号" />
              )}
            </Form.Item>
            <Form.Item label="部门">
              {getFieldDecorator('departIds', {
                initialValue: []
                // initialValue: ''
              })(
                <DepartSelect 
                  // showAll={true}  //单选开启
                  style={{minWidth: 200, maxWidth: 600}} 
                  treeCheckable={true}
                  treeCheckStrictly={true}
                />
              )}
            </Form.Item>
            <Form.Item label="性别">
              {getFieldDecorator('sex', {
                initialValue: ''
              })(
                <Select style={{ width: 200 }} placeholder="请选择性别" >
                  <Option value="">全部</Option>
                  <Option value="1">男</Option>
                  <Option value="0">女</Option>
                </Select>
              )}
            </Form.Item>
          </>
        </SearchForm>
        <Btns>
          {/* <Popover content={<div style={{padding: 10}}>搜索后可导出结果</div>}> */}
            <Button
              disabled={this.state.selectedRows.length === 0}
              type="primary"
              onClick={() => {
                const { selectedRows } = this.state;
                // if(selectedRows.length === 0) {
                //   return $modal('请选择人员');
                // }
                const perIds = selectedRows.map(({perId}) => perId).join(',');
                taskPerJointlyCardBatchNotice({
                  perIds, isCheckAll: '0'
                }).then(res => {
                  this.setState({
                    selectedRows: [],
                    selectedRowKeys: []
                  });
                  // $modal(res.msg);
                });
              }}
            >
              批量提醒开通
            </Button>
            <Button
              type="primary"
              onClick={() => {
                $nModal({
                  title: '温馨提示',
                  content: '即将提醒全员开通,确定向全员发送通知',
                  onOk: close => {

                    taskPerJointlyCardBatchNotice({
                      perIds: '', isCheckAll: '1'
                    }).then(res => {
                      this.setState({
                        selectedRows: [],
                        selectedRowKeys: []
                      });
                      // $modal(res.msg);
                      close();
                    });
                  }
                });
              }}
            >
              提醒全员开通
            </Button>
            <Popover content={<div style={{ padding: 10 }}>点击搜索后可导出结果</div>}>
            {
              excelButtonHOC({
                // disabled: !this.props.clicked,
                disabled: this.state.total == 0,
                type: 'primary',
                method: 'GET',
                params: this.props.searchData,
                apiurl: "/task/per-jointly-card/export-no-open-jointly-per",
                downloadname: this.props.global.companyInfo.comName + "_未开通联名卡人员",
                children: '导出筛选结果'
              }, Button)
            }
          </Popover>
        </Btns>
        {/* 表格 */}
        {this.renderOrderList()}

      </div >
    );
  }
}

const Btns = st.div`
  margin-top: 15px;
  button {
    margin-right: 15px;
  }
`;