import React, { Component } from 'react';
import st from 'styled-components';
import { connect } from 'dva';
import { withRouter } from 'dva/router';
import {
  Tabs,
  Alert,
  Input,
  Select,
  Button,
  Modal
} from 'antd';
import tablePage from '../../../utils/hoc/tablePage';
import $nModal from '../../../utils/modal/nModal';
import $modal from '../../../utils/modal';
import { taskComBhGrantSaveComBhGrantInfo, taskComBhAccountGetComBhAccount } from '../../../services/api';
import columnFun from './columns';

const { TabPane } = Tabs;
const { Option } = Select;
export const formItemLayout = {
  labelCol: {
    xs: { span: 24 },
    sm: { span: 7 }
  },
  wrapperCol: {
    xs: { span: 24 },
    sm: { span: 12 },
    md: { span: 12 }
  }
};

@connect(state => ({
  global: state.global
}))
@withRouter
@tablePage()
export default class SalaryProxyOnline extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      addModal: false, //新增代发弹窗
      isOpenSalaryAuth: null,//企业是否有发薪权限
    };
  }

  componentDidMount() {
    this._taskComBhAccountGetComBhAccount()
  }
  componentWillMount() {

  }
  //获取是否有发薪权限
  _taskComBhAccountGetComBhAccount() {
    taskComBhAccountGetComBhAccount().then(res => {
      this.setState({
        isOpenSalaryAuth: res.data.isOpenSalaryAuth
      })
    })
  }

  // 表格渲染
  _renderOrderList = () => {
    const columns = columnFun.call(this);
    const { PageTable, isInit } = this.props;
    if (!isInit) return;
    return (
      <PageTable
        style={{ marginTop: 20 }}
        columns={columns}
        url="taskComBhGrantPageComBhGrantInfoList"
        scroll={{ x: '1500px' }}
        pagination={{ showTotal: total => `总共 ${total} 条` }}
        dateChange={(data) => {
          // this.setState({
          //   total: data.total
          // });
        }}
      />
    );
  };

  render() {
    const { SearchForm, Form } = this.props;
    const { getFieldDecorator } = this.props.form;
    return (
      <div style={{ padding: '0 24px' }}>
        <Tabs defaultActiveKey="1" onChange={() => { }}>
          <TabPane tab={"在线薪资代发申请"} key="1" forceRender>
            <Alert
              message={<div style={{ color: '#333' }}>
                <span>薪资代发：仅支持发放薪资到渤海银行保安员证联名卡或其他渤海银行卡。</span> <br />
                <span style={{color:'red'}}>权限建议：建议此页面授权给具有发放薪资权限的财务或相关人员。</span> <br />
                <span style={{color:'red'}}>代发确认时效：薪资代发申请提交后，需当日登录渤海银行微信小程序进行确认发放，否则逾期会导致发放失败。</span>
                {/* <span>代发审核：<span style={{color:'red'}}>薪资代发申请提交后，需当日登录</span><a onClick={() => {
                  $nModal({
                    footer: null,
                    content: (<div style={{ textAlign: 'center' }}>
                      <img style={{ margin: '0 auto', maxWidth: '100%' }} src={require('./qrcode.jpg')} />
                    </div>)
                  });
                }}>渤海银行微信小程序</a><span style={{color:'red'}}>进行确认发放，否则逾期会导致发放失败。</span></span> */}
              </div>}
              type="warning"
              showIcon
              style={{ marginBottom: '15px' }}
            />

            <SearchForm
            // arrange={values => {
            //   console.log(values)
            //   return values;
            // }}
            >
              <>
                <Form.Item label="关键字">
                  {getFieldDecorator('keyword', {
                    initialValue: ''
                  })(
                    <Input style={{ width: 200 }} placeholder="代发单号/代发标题/备注" />
                  )}
                </Form.Item>
              </>
            </SearchForm>
            <Btns>
              <Button
                type="primary"
                onClick={() => {
                  if (this.state.isOpenSalaryAuth == '1') {
                    this.setState({
                      addModal: true
                    });
                  } else {
                    $modal(
                      '您的企业未开通发薪账户或未开启发薪权限',
                      '请先开通企业发薪账户并开启发薪权限后再新建代发。',
                      [
                        {
                          text: '我知道了', type: 'primary', onPress: () => {

                          }
                        },
                        // {
                        //   text: '取消', type: 'default'
                        // },
                      ],
                      'error'
                    );
                  }
                }}
              >
                新增代发
            </Button>
            </Btns>

            {this._renderOrderList()}
          </TabPane>
        </Tabs>

        {
          this.state.addModal &&
          <Modal
            visible={this.state.addModal}
            title="新增代发"
            okText="确定"
            cancelText="取消"
            onOk={() => {
              this.props.form.validateFields((err, values) => {
                if (err) return;
                Reflect.deleteProperty(values, 'keyword');
                // 提交values
                taskComBhGrantSaveComBhGrantInfo(values).then(res => {

                  this.setState({ addModal: false });
                  this.props.updateTable();
                });
              });
            }}
            onCancel={() => { this.setState({ addModal: false }); }}
          >
            <Form.Item {...formItemLayout} label="标题">
              {getFieldDecorator('title', {
                initialValue: '',
                rules: [
                  {
                    required: true,
                    message: '请输入标题'
                  }
                ]
              })(
                <Input maxLength={10} placeholder="请输入标题" />
              )}
            </Form.Item>
            <Form.Item {...formItemLayout} label="备注">
              {getFieldDecorator('remark', {
                initialValue: '',
                rules: [
                  {
                    required: true,
                    message: '请输入备注'
                  }
                ]
              })(
                <Input.TextArea maxLength={10} placeholder="请输入备注" />
              )}
            </Form.Item>
            <Form.Item {...formItemLayout} label="发放类型">
              {getFieldDecorator('grantType', {
                initialValue: '3',
                rules: [
                  {
                    required: true,
                    message: '请选择发放类型'
                  }
                ]
              })(
                <Select
                  style={{ width: '100%' }}
                  placeholder="请选择"
                >
                  <Option
                    value={`3`}
                  >
                    发放到保安员证联名卡
                  </Option>
                  <Option
                    value={`4`}
                  >
                    发放到渤海银行卡
                  </Option>
                </Select>
              )}
            </Form.Item>
          </Modal>
        }
      </div>
    );
  }
}

const Btns = st.div`
  margin-top: 15px;
  button {
    margin-right: 15px;
  }
`;