
import { Form, Input } from 'antd';
import { formItemLayout } from './index';
import { taskComBhGrantDeleteComBhGrantInfo, taskComBhGrantGetComBhGrantInfoById } from '../../../services/apiSmartCard';
import $modal from '../../../utils/modal';
import $nModal from '../../../utils/modal/nModal';
// const warnColor = '#F59A23';
// const okColor = '#4B7902';
const errColor = '#D9001B';
export default function () {

  return [
    // {
    //   title: '序号',
    //   dataIndex: 'number',
    //   key: 'number',
    //   // width: 80,
    //   // fixed: 'left'
    // },
    {
      title: '代发单号',
      dataIndex: 'comBhGrantId',
      key: 'comBhGrantId',
      // width: 100,
      // fixed: 'left',
      render: value => value || '-',
    },
    {
      title: '标题',
      dataIndex: 'title',
      key: 'title',
    },
    {
      title: '备注',
      dataIndex: 'remark',
      key: 'remark',
      render: text => (
        <div style={{ maxWidth: 200 }}>
          {text}
        </div>
      )
    },
    {
      title: '申请人',
      dataIndex: 'createBy',
      key: 'createBy',
    },
    {
      title: '申请时间',
      dataIndex: 'createTime',
      key: 'createTime',
    },
    {
      title: '发放类型',
      dataIndex: 'grantTypeLabel',
      key: 'grantTypeLabel',
    },
    {
      title: '发放年月',
      dataIndex: 'grantYears',
      key: 'grantYears',
    },
    {
      title: '状态',
      dataIndex: 'commitStatus',
      key: 'commitStatus',
      render: (value) => {
        if (value == '已提交') {
          return <span style={{ color: 'green' }}>{value}</span>
        } else {
          return <span style={{ color: 'orange' }}>{value}</span>
        }
      }
    },
    {
      title: '操作',
      dataIndex: 'operation',
      key: 'operation',
      width: 130,
      fixed: 'right',
      render: (text, record) => {
        const { comBhGrantId, remark, grantYears, commitStatus, grantType } = record;
        return (
          <div style={{ width: 200 }}>
            <a style={{ marginRight: 15 }} onClick={() => {

              taskComBhGrantGetComBhGrantInfoById({ comBhGrantId }).then(res => {
                const info = res.data;
                $nModal({
                  title: '基础信息',
                  footer: null,
                  // onOk: () => {

                  // },
                  content: (
                    <>
                      <Form.Item {...formItemLayout} label="标题">
                        <Input disabled value={info.title} maxLength={100} placeholder="标题" />
                      </Form.Item>
                      <Form.Item {...formItemLayout} label="备注">
                        <Input disabled value={info.remark} maxLength={500} placeholder="备注" />
                      </Form.Item>
                      <Form.Item {...formItemLayout} label="提交状态">
                        <Input disabled value={info.commitStatus == '1' ? '已提交' : '待提交'} maxLength={100} placeholder="提交状态" />
                      </Form.Item>
                      <Form.Item {...formItemLayout} label="发放类型">
                        <Input disabled value={'发送到保安员证联名卡'} maxLength={100} placeholder="发放类型" />
                      </Form.Item>
                      <Form.Item {...formItemLayout} label="发放年月">
                        <Input disabled value={info.grantYears} maxLength={100} placeholder="发放年月" />
                      </Form.Item>

                      <Form.Item {...formItemLayout} label="实际发放总笔数">
                        <Input disabled value={info.totalGrantCount} maxLength={100} placeholder="实际发放总笔数" />
                      </Form.Item>
                      <Form.Item {...formItemLayout} label="实际发放总金额">
                        <Input disabled value={info.totalSumAmount} maxLength={100} placeholder="实际发放总金额" />
                      </Form.Item>
                      <Form.Item {...formItemLayout} label="发放总笔数">
                        <Input disabled value={info.grantCount} maxLength={100} placeholder="发放总笔数" />
                      </Form.Item>
                      <Form.Item {...formItemLayout} label="发放总金额">
                        <Input disabled value={info.sumAmount} maxLength={100} placeholder="发放总金额" />
                      </Form.Item>
                      {/* <Form.Item {...formItemLayout} label="发放数据来源">
                          <Input value={info.grantDataSource} maxLength={100} placeholder="发放数据来源" />
                        </Form.Item> */}
                    </>
                  )
                });
              });
            }}>基础信息</a>
            <a style={{ marginRight: 15 }} onClick={() => {
              this.props.history.push({
                pathname: '/salarypayment/salary-proxy-online/list',
                state: {
                  comBhGrantId,
                  grantYears,
                  remark
                }
              })
              // this.props.history.push(`/salarypayment/salary-proxy-online/list?comBhGrantId=${comBhGrantId}&&grantYears=${grantYears}&&remark=${remark}`);
            }}>代发列表</a>
            {
              commitStatus != '已提交' && <a style={{ marginRight: 15, color: errColor }} onClick={() => {
                $modal('即将删除薪资代发记录', <span style={{ color: errColor }}>薪资代发记录删除后，不可恢复，是否继续？</span>, [{
                  text: '继续', type: 'primary', onPress: () => {
                    taskComBhGrantDeleteComBhGrantInfo({ comBhGrantId }).then(() => {
                      this.props.updateTable();
                    });
                  }
                }, {
                  text: '取消', type: '', onPress: () => {
                  }
                }]);
              }}>删除</a>
            }
          </div>
        );
      }
    }
  ];
}