// const warnColor = '#F59A23';
const okColor = '#4B7902';
const errColor = '#D9001B';
import $modal from '../../../../utils/modal';
import { taskComBhGrantDeleteComBhGrantDetailById } from '../../../../services/apiSmartCard';
export default function (commitStatus,grantType) {

  const columns = [
    // {
    //   title: '序号',
    //   dataIndex: 'number',
    //   key: 'number',
    //   // width: 80,
    //   // fixed: 'left'
    // },
    {
      title: '收款人姓名',
      dataIndex: 'name',
      key: 'name',
      // width: 200,
      // fixed: 'left',
      render: value => value || '-',
    },
    {
      title: '身份证号码',
      dataIndex: 'idCardNo',
      key: 'idCardNo',
    },
    {
      title: '手机号码',
      dataIndex: 'mobilePhone',
      key: 'mobilePhone',
    },
    // {
    //   title: '保安员证联名卡卡号',
    //   dataIndex: 'bankCardNo',
    //   key: 'bankCardNo',
    //   render: text => (
    //     <div style={{ maxWidth: 200 }}>
    //       {text}
    //     </div>
    //   )
    // },
    // {
    //   title: '发放工资（元）',
    //   dataIndex: 'amount',
    //   key: 'amount',
    // }
  ];
  columns.push(
    {
      title: grantType == '4' ? '收款账号' : '保安员证联名卡卡号',
      dataIndex: 'bankCardNo',
      key: 'bankCardNo',
      render: text => (
        <div style={{ maxWidth: 200 }}>
          {text}
        </div>
      )
    },
    {
      title: '发放工资（元）',
      dataIndex: 'amount',
      key: 'amount',
    }
  )
  //根据是否提交的类型判断
  if (commitStatus == '1') {
    columns.push({
      title: '发放结果',
      dataIndex: 'grantStatus',
      key: 'grantStatus',
      width: 130,
      fixed: 'right',
      render: (text, record) => {
        return (
          <span style={{color:text=='发放失败'?errColor:okColor}}>{text}</span>
        )
      }
    }, {
      title: '备注',
      dataIndex: 'remark',
      key: 'remark',
      width: 130,
      fixed: 'right',
      render: value => value
    })
  }
  if(commitStatus === '0') {
    columns.push({
      title: '操作',
      dataIndex: 'operation',
      key: 'operation',
      width: 130,
      fixed: 'right',
      render: (text, record) => {
        const { comBhGrantDetailId } = record;
        const { comBhGrantId } = this.state;
        return(
          <div style={{width: 200}}>
            <a style={{marginRight: 15, color: errColor}} onClick={() => {
              $modal('即将删除薪资代发记录', <span style={{color: errColor}}>薪资代发记录删除后，不可恢复，是否继续？</span>, [{ text: '继续', type: 'primary', onPress: () => {
                taskComBhGrantDeleteComBhGrantDetailById({comBhGrantDetailId, comBhGrantId}).then(res => {
                  this.props.updateTable();
                  this._getPageInfo();
                });
              } }]);
            }}>删除</a>
          </div>
        );
      }
    });
  }
  return columns;
}