import React, { Component } from "react";
import { connect } from "dva";
import "../financialWallet.less";
import { withRouter } from "dva/router";
import * as ajax from "../../../services/api";
import $modal from "../modal";
import { gup } from "../../../utils/utils";
import { SMS_OP_TRANSFER } from "../../../common/shortMessage";
import moment from 'moment';
import {
  Alert,
  Input,
  Button,
  Table,
  Form,
  Select,
  Modal,
  Upload,
  Icon,
  message,
  Spin,
  DatePicker
} from "antd";
const { Option } = Select;
const { MonthPicker } = DatePicker;
import dff from "../../../assets/images/wallet/dff2.png";
import ffsb from "../../../assets/images/wallet/ffsb1.png";
import ffcg from "../../../assets/images/wallet/ffcg1.png";
import ffze from "../../../assets/images/wallet/ffze1.png";
import Download from "./Download";
import UploadFile from "./UploadFile";
@connect(state => ({
  global: state.global
}))
@withRouter
@Form.create()
export default class Messages extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      totalInfo: null,
      grantInfo: null, //title等数据
      // 搜索部分
      searchData: {
        // 表格数据请求参数
        comGrantId: gup("comGrantId"),
        keyword: "", //关键字
        isCanGrant: "",
        pageNumber: "1", // 页
        pageSize: "10" //条目
      },
      isCanGrant: "",
      keyword: "", //关键字
      // 表格部分
      tableList: [], // 表格数据
      pagination: {
        //分页数据
        total: 1,
        current: 1,
        pageSize: 10,
        showSizeChanger: true,
        showQuickJumper: true
      },
      canAddData: false, //添加发放数据按钮是否显示

      // 操作记录
      operationVisibale: false,
      operationPagination: {
        total: 1,
        current: 1,
        pageSize: 10,
        showSizeChanger: true,
        showQuickJumper: true
      },
      operationList: [],

      // 添加发放数据
      addDataVisibale: false,

      onlineSalaryDataSource: [],
      grantDataSource: "1",
      payrollList: [], //工资单列表
      grantYearsDown:'',//选择导入线下数据的时候存储下选择的年月
    };
  }
  componentDidMount() {
    this.selectGrantDetailTotalMap();
    //【薪资代发】根据id获取薪资代发记录
    ajax.getComGrantInfoById({ comGrantId: gup("comGrantId") }).then(res => {
      this.setState({
        grantInfo: res.data
      });
    });
    // 获取列表
    this.getTable(this.state.searchData, list => {
      /*
              allGrantStatus
               0  待发放
                1  正在发放
                2  部分完成
                3  全部完成 */
      // if(list.length == 0) {
      //   this.setState({
      //     canAddData: true
      //   });
      // }
      // this.state.grantInfo && this.state.grantInfo.allGrantStatus != 3
      // 添加发放数据的判断  列表为空并且带发放数据大于零的时候
      // list.length == 0 && this.state.totalInfo && this.state.totalInfo.toTotalSize > 0 && this.setState({
      //   canAddData: true
      // });
    });
    // 获取在线薪酬数据来源列表，年月
    ajax.getOnlineSalaryDataSource().then(res => {
      // const arr = res.data || [];
      this.setState({
        onlineSalaryDataSource: res.data
        // onlineSalaryDataSource: arr.reverse()
      });
    });
  }
  selectGrantDetailTotalMap() {
    //获取薪资代发记录汇总
    ajax
      .selectGrantDetailTotalMap({ comGrantId: gup("comGrantId") })
      .then(res => {
        if (res.data) {
          this.setState({
            totalInfo: res.data
          });
        } else {
          // this.setState({
          //   totalInfo: {
          //     failTotalAmount: "0.00",
          //     failTotalSize: "0",
          //     successTotalAmount: "0.00",
          //     successTotalSize: "0",
          //     toTotalAmount: "0",
          //     toTotalSize: "0",
          //     totalAmount: "0.00",
          //     totalSize: "0"
          //   }
          // });
        }
      });
  }
  // 获取表格信息
  getTable = (data, cb) => {
    ajax.pageComToGrantDetailList(data).then(res => {
      this.setState(
        {
          tableList: res.data.data,
          pagination: {
            ...this.state.pagination,
            total: res.data.total,
            current: res.data.pageNumber,
            pageSize: res.data.pageSize
          }
        },
        () => {
          cb && cb(res.data.data);
        }
      );
    });
  };

  //添加代发放记录
  createOnlineToGrantDataHandle = e => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        //薪酬服务调用另外接口去保存
        if (this.state.grantDataSource === "3") {
          if(!values.grantYears){
            return message.error('先选择工资单')
          }
          const value = {
            comGrantId: gup("comGrantId"),
            grantYears: JSON.parse(values.grantYears).PayYear,
            thirdPaySlipId: JSON.parse(values.grantYears).ID
          };
          ajax.createThirdToGrantData(value).then(res => {
            this.selectGrantDetailTotalMap();
            this.getTable(this.state.searchData, () => {
              this.setState({ 
                canAddData: false,
                addDataVisibale: false 
              });
            });
          });
        } else {
          if(!values.grantYears1){
            return message.error('先选择月份')
          }
          values.comGrantId = gup("comGrantId");
          values.grantYears = values.grantYears1
          ajax.createOnlineToGrantData(values).then(res => {
            this.selectGrantDetailTotalMap();
            this.getTable(this.state.searchData, () => {
              this.setState({
                canAddData: false,
                addDataVisibale: false 
              });
            });
          });
        }
      }
    });
    // this.setState({
    //   addDataVisibale: false
    // });
  };
  // 代发薪资时发送验证码的动作

  // 获取操作记录
  getOperationTable = (data, cb) => {
    ajax.getComOperRecordList(data).then(res => {
      this.setState(
        {
          operationList: res.data,
          operationPagination: {
            ...this.state.operationPagination,
            total: res.data.total,
            current: res.data.pageNumber,
            pageSize: res.data.pageSize
          }
        },
        () => {
          cb && cb(res.data.data);
        }
      );
    });
  };

  // 表格渲染
  renderList = () => {
    const columns = [
      {
        title: "收款人姓名",
        dataIndex: "name",
        key: "name"
      },
      {
        title: "身份证号码",
        dataIndex: "idCardNo",
        key: "idCardNo"
      },
      {
        title: "手机号码",
        dataIndex: "mobilePhone",
        key: "mobilePhone"
      },
      {
        title: "收款账户",
        dataIndex: "walletAccountNo",
        key: "walletAccountNo",
        render: text => {
          if (text == "该人员未开通钱包") {
            return <span style={{ color: "#ed4014" }}>{text}</span>;
          } else {
            return <span>{text}</span>;
          }
        }
      },
      {
        title: "应发工资（元）",
        dataIndex: "amount",
        key: "amount"
      },
      {
        title: "状态",
        dataIndex: "isCanGrant",
        key: "isCanGrant",
        render: (text, record) => {
          const { isCanGrant } = record;
          switch (isCanGrant) {
            case "不可发放":
              return <span style={{ color: "#ed4014" }}>{isCanGrant}</span>;
            case "可发放":
              return <span style={{ color: "#19be6b" }}>{isCanGrant}</span>;
            default:
              <span>{isCanGrant}</span>;
          }
        }
      }
    ];
    return (
      <div>
        <Table
          dataSource={this.state.tableList}
          columns={columns}
          pagination={this.state.pagination}
          onChange={pagination => {
            const searchData = {
              // 搜索数据
              ...this.state.searchData,
              pageNumber: pagination.current, // 页
              pageSize: pagination.pageSize
            };
            this.setState(
              {
                searchData
              },
              () => {
                this.getTable(searchData);
              }
            );
          }}
          // rowSelection={{
          //   onChange: (selectedRowKeys, selectedRows) => {
          //     this.setState({
          //       selectedRows,
          //       selectedRowKeys
          //     });
          //   },
          //   selectedRowKeys: this.state.selectedRowKeys
          // }}
        />
      </div>
    );
  };
  // 操作记录表格渲染
  renderOperationList = () => {
    const columns = [
      {
        title: "时间",
        dataIndex: "createTime",
        key: "createTime"
      },
      {
        title: "操作人",
        dataIndex: "createUserName",
        key: "createUserName"
      },
      {
        title: "操作功能",
        dataIndex: "operGrantFuncType",
        key: "operGrantFuncType"
      },
      {
        title: "操作结果",
        dataIndex: "operResult",
        key: "operResult"
      }
    ];
    return (
      <div>
        <Table
          dataSource={this.state.operationList}
          columns={columns}
          // pagination={this.state.operationPagination}
          onChange={pagination => {
            pagination.comGrantId = gup("comGrantId");
            this.setState(
              {
                operationSearchData: {
                  pageNumber: pagination.current, // 页
                  pageSize: pagination.pageSize
                }
              },
              () => {
                this.getOperationTable(pagination);
              }
            );
          }}
        />
      </div>
    );
  };
  render() {
    return (
      <div style={{ paddingTop: "10px" }}>
        <div className="tab_inner">
          <section style={{ marginBottom: 10 }}>
            <Button
              style={{ marginRight: 15 }}
              onClick={() => {
                // this.props.history.goBack();
                this.props.history.push("/finance/salary-proxy");
              }}
            >
              返回列表
            </Button>
            {this.state.grantInfo && (
              <span>
                {this.state.grantInfo.title} （{gup("comGrantId")}）
              </span>
            )}
          </section>
          <Alert
            message={
              <div>
                <span>
                  1、发放工资：发放前请确认发放人数、发放总额、企业钱包余额是否充足，若不足，请
                  <a
                    onClick={() => {
                      this.props.history.push("/finance/business-wallet");
                    }}
                  >
                    充值
                  </a>
                  ；
                </span>
                <br />
                <span>
                  2、未开通钱包服务的员工，请提醒其在APP端进行开通，否则无法向其发放工资。
                </span>
                <br />
              </div>
            }
            type="warning"
            showIcon
            style={{ marginBottom: "15px" }}
          />

          {this.state.totalInfo && (
            <div className="statistics_container">
              <div className="active_uint statistics_uint">
                {/* <Icon type="pay-circle" style={{ fontSize: 50 }} /> */}
                <img src={dff} alt="" />
                <div className="uint_info">
                  <p>待发放总额</p>
                  <p className="bold">{this.state.totalInfo.toTotalAmount}</p>
                  <p>待发放总笔数：{this.state.totalInfo.toTotalSize}</p>
                </div>
              </div>
              <div className="symbol bold">+</div>
              <div
                className="statistics_uint"
                onClick={() => {
                  this.props.history.push(
                    `/finance/salary-proxy-fail?comGrantId=${gup("comGrantId")}`
                  );
                }}
              >
                {/* <Icon type="pay-circle" style={{ fontSize: 50 }} /> */}
                <img src={ffsb} alt="" />
                <div className="uint_info">
                  <p>发放失败总额</p>
                  <p className="bold">{this.state.totalInfo.failTotalAmount}</p>
                  <p>发放总笔数：{this.state.totalInfo.failTotalSize}</p>
                </div>
              </div>
              <div className="symbol bold">+</div>
              <div
                className="statistics_uint"
                onClick={() => {
                  this.props.history.push(
                    `/finance/salary-proxy-complete?comGrantId=${gup(
                      "comGrantId"
                    )}`
                  );
                }}
              >
                <img src={ffcg} alt="" />
                <div className="uint_info">
                  <p>发放成功总额</p>
                  <p className="bold">
                    {this.state.totalInfo.successTotalAmount}
                  </p>
                  <p>发放总笔数：{this.state.totalInfo.successTotalSize}</p>
                </div>
              </div>
              <div className="symbol bold">=</div>
              <div
                className="statistics_uint"
                style={{
                  cursor: "default"
                }}
                // className={
                //   (() => {
                //     if (this.state.listStatus == 3) {
                //       return 'active_uint statistics_uint';
                //     }
                //     return 'statistics_uint';
                //   })()
                // }
                // onClick={() => {
                //   this.setState({
                //     listStatus: 3
                //   });
                // }}
              >
                {/* <Icon type="pay-circle" style={{ fontSize: 50 }} /> */}
                <img src={ffze} alt="" />
                <div className="uint_info">
                  <p>发放总额</p>
                  <p className="bold">{this.state.totalInfo.totalAmount}</p>
                  <p>发放总笔数：{this.state.totalInfo.totalSize}</p>
                </div>
              </div>
            </div>
          )}

          <div className="proxy_btns_container">
            <div>
              <label style={{ marginRight: 16 }}>
                关键字：
                <Input
                  value={this.state.keyword}
                  style={{ width: "214px" }}
                  placeholder="姓名/手机号码"
                  onChange={e => {
                    this.setState({
                      keyword: e.target.value
                    });
                  }}
                  maxLength={20}
                />
              </label>
              <label style={{ marginRight: 16 }}>
                状态：
                <Select
                  onChange={isCanGrant => {
                    this.setState({
                      isCanGrant
                    });
                  }}
                  value={this.state.isCanGrant}
                  style={{ width: 120 }}
                >
                  <Option value="">全部</Option>
                  <Option value="1">可发放</Option>
                  <Option value="0">不可发放</Option>
                </Select>
              </label>
              <Button
                style={{
                  marginRight: "16px",
                  padding:
                    window && window.innerWidth <= 1366 ? "0 10px" : "0 15px"
                }}
                type="primary"
                onClick={() => {
                  const data = {
                    ...this.state.searchData,
                    keyword: this.state.keyword,
                    isCanGrant: this.state.isCanGrant
                  };
                  this.setState(
                    {
                      searchData: data
                    },
                    () => {
                      this.getTable(data);
                    }
                  );
                }}
              >
                搜索
              </Button>
              <Button
                onClick={() => {
                  this.setState(
                    {
                      keyword: "",
                      isCanGrant: "",
                      searchData: {
                        ...this.state.searchData,
                        keyword: "", //关键字
                        isCanGrant: "",
                        pageNumber: "1", // 页
                        pageSize: "10" //条目
                      }
                    },
                    () => {
                      this.getTable(this.state.searchData);
                    }
                  );
                }}
                style={{
                  padding:
                    window && window.innerWidth <= 1366 ? "0 10px" : "0 15px"
                }}
              >
                重置
              </Button>
            </div>
            <div className="operation_btns">
              {/*
              allGrantStatus
               0  待发放
                1  正在发放
                2  部分完成
                3  全部完成 */}
              {this.state.tableList.length == 0 && (
                <Button
                  type="primary"
                  onClick={() => {
                    this.setState({
                      addDataVisibale: true
                    });
                  }}
                >
                  添加发放数据
                </Button>
              )}
              {this.state.tableList.length > 0 && (
                <Button
                  type="primary"
                  onClick={() => {
                    ajax
                      .readySalaryGrantTotal({
                        comGrantId: gup("comGrantId")
                      })
                      .then(response => {
                        if (response.data) {
                          const {
                            cantGrantTotal,
                            canGrantTotal
                          } = response.data;
                          $modal(
                            `即将向${canGrantTotal}人发工资，是否继续？`,
                            <span
                              style={{ color: "#FF9900" }}
                            >{`其中有${cantGrantTotal}人未开通钱包，本次不向其发放工资。系统会逐单向每个人员发放工资，发放人数越多，发放时间越长，请耐心等待。`}</span>,
                            [
                              {
                                text: "继续",
                                type: "primary",
                                onPress: () => {
                                  ajax
                                    .getCanGrant({
                                      comGrantId: gup("comGrantId")
                                    })
                                    .then(res => {
                                      // 下一步
                                      if (res.data == 0) {
                                        /** 从获取企业钱包账户资料接口中获取手机号*/
                                        ajax
                                          .getComWalletAccount()
                                          .then(result => {
                                            const mobilePhone =
                                              result.data.mobilePhone + "";
                                            const mobilePhoneStr =
                                              mobilePhone.slice(0, 3) +
                                              "****" +
                                              mobilePhone.slice(-4);
                                            /**获取到手机号以后请求验证码 */
                                            ajax
                                              .sendVerifyCode({
                                                mobilePhone,
                                                smsType: SMS_OP_TRANSFER
                                              })
                                              .then(data => {
                                                let activeCode = "";
                                                $modal(
                                                  "已向企业结算手机号发送验证码！",
                                                  <div>
                                                    <p>{`系统已向 ${mobilePhoneStr} 发送短信验证码，请将接收到的短信验证码输入下框并验证。`}</p>
                                                    <Input
                                                      onChange={e => {
                                                        activeCode =
                                                          e.target.value;
                                                      }}
                                                      placeholder="请输入短信验证码"
                                                    />
                                                  </div>,
                                                  [
                                                    {
                                                      text: "继续",
                                                      type: "primary",
                                                      onPress: () => {
                                                        ajax
                                                          .salaryGrant({
                                                            comGrantId: gup(
                                                              "comGrantId"
                                                            ),
                                                            activeCode
                                                          })
                                                          .then(grantRes => {
                                                            $modal(
                                                              "已提交薪资代发！",
                                                              "请返回薪资代发列表，等待本次发放结束后，再查看发放结果。",
                                                              [
                                                                {
                                                                  text:
                                                                    "返回薪资代发列表",
                                                                  type:
                                                                    "primary",
                                                                  onPress: () => {
                                                                    this.props.history.push(
                                                                      "/finance/salary-proxy"
                                                                    );
                                                                  }
                                                                }
                                                              ],
                                                              "success"
                                                            );
                                                          });
                                                      }
                                                    },
                                                    {
                                                      text: "返回"
                                                    }
                                                  ],
                                                  "warning"
                                                );
                                              });
                                          });
                                        // 余额不足
                                      } else {
                                        const {
                                          toTotalAmount,
                                          availableAmount,
                                          spreadAmount
                                        } = res.data;
                                        $modal(
                                          "您当前账户余额不足，请先充值！",
                                          <div>
                                            <p>
                                              代发总额:{" "}
                                              <span
                                                style={{ marginLeft: 5 }}
                                              >{`${toTotalAmount}`}</span>
                                            </p>
                                            <p>
                                              钱包余额:{" "}
                                              <span
                                                style={{ marginLeft: 5 }}
                                              >{`${availableAmount}`}</span>
                                            </p>
                                            <p>
                                              还需充值:{" "}
                                              <span
                                                style={{ marginLeft: 5 }}
                                              >{`${spreadAmount}`}</span>
                                            </p>
                                          </div>,
                                          [
                                            {
                                              text: "去充值",
                                              type: "primary",
                                              onPress: () => {
                                                this.props.history.push(
                                                  "/finance/business-wallet"
                                                );
                                              }
                                            },
                                            {
                                              text: "返回"
                                            }
                                          ],
                                          "error"
                                        );
                                      }
                                    });
                                }
                              },
                              {
                                text: "取消"
                              }
                            ],
                            "warning"
                          );
                        }
                      });
                  }}
                >
                  确定并提交发放
                </Button>
              )}
              {this.state.tableList.length > 0 && (
                <Button
                  onClick={() => {
                    $modal(
                      "即将通知未开通钱包的人员，是否继续？",
                      <span style={{ color: "#FF9900" }}>
                        系统会自动发送开通通知信息到人员APP端，
                        告知员工开通钱包服务。
                      </span>,
                      [
                        {
                          text: "继续",
                          type: "primary",
                          onPress: () => {
                            ajax
                              .grantInfoBatchNotice({
                                comGrantId: gup("comGrantId")
                              })
                              .then(res => {
                                this.getTable(this.state.searchData);
                                this.getOperationTable({
                                  comGrantId: gup("comGrantId"),
                                  pageNumber: "1",
                                  pageSize: "10"
                                });
                              });
                            // this.props.history.push('/finance/employee-wallet');
                          }
                        },
                        {
                          text: "取消"
                        }
                      ],
                      "warning"
                    );
                  }}
                >
                  开通提醒
                </Button>
              )}
              <Button
                onClick={() => {
                  if (this.state.operationList.length == 0) {
                    this.getOperationTable({
                      comGrantId: gup("comGrantId"),
                      pageNumber: "1",
                      pageSize: "10"
                    });
                  }
                  this.setState({
                    operationVisibale: true
                  });
                }}
                type="default"
              >
                操作记录
              </Button>
            </div>
          </div>
        </div>
        <div className="table_container">{this.renderList()}</div>

        {/* 操作记录 */}
        <Modal
          title="操作记录"
          className="modal_on_footer"
          width={720}
          onCancel={() => {
            this.setState({
              operationVisibale: false
            });
          }}
          visible={this.state.operationVisibale}
        >
          {this.renderOperationList()}
        </Modal>

        {/* 添加发放数据 */}
        <Modal
          title="添加发放数据"
          onCancel={() => {
            this.setState({
              addDataVisibale: false
            });
          }}
          // onOk={this.createOnlineToGrantDataHandle}
          visible={this.state.addDataVisibale}
          footer={this.state.grantDataSource==='2'?null:[
            <Button key="back" onClick={()=>{
               this.setState({
                addDataVisibale: false
              });}}>取消</Button>,
            <Button key="submit" type="primary"  onClick={this.createOnlineToGrantDataHandle}>
                确定  
            </Button>
          ]}
        >
          {(() => {
            const { getFieldDecorator } = this.props.form;
            const formItemLayout = {
              labelCol: {
                xs: { span: 5 },
                sm: { span: 5 }
              },
              wrapperCol: {
                xs: { span: 18 },
                sm: { span: 18 }
              }
            };
            return (
              <div>
                <Form onSubmit={this.createOnlineToGrantDataHandle}>
                  <Form.Item
                    {...formItemLayout}
                    label="数据来源："
                    className="lao_108"
                  >
                    {getFieldDecorator("grantDataSource", {
                      initialValue: "1",
                      rules: [{}]
                    })(
                      <Select
                        onChange={value => {
                          this.setState({ grantDataSource: value });
                          if (
                            value === "3" &&
                            this.state.payrollList.length == 0
                          ) {
                            ajax.getPayrollList().then(res => {
                              if (res.retType == "0") {
                                this.setState({
                                  payrollList: res.data || []
                                });
                              }
                            });
                          }
                        }}
                        style={{ width: 220 }}
                      >
                        <Option value="1">引用薪酬核算</Option>
                        <Option value="2">导入线下数据</Option>
                        <Option value="3">引用薪酬服务</Option>
                      </Select>
                    )}
                  </Form.Item>
                  {this.state.grantDataSource === "1" ? (
                    <span>
                      <Form.Item
                        {...formItemLayout}
                        label="发薪月份："
                        className="lao_108"
                      >
                        {getFieldDecorator("grantYears1", {
                          initialValue: this.state.onlineSalaryDataSource[0],
                          rules: [{}]
                        })(
                          <Select style={{ width: 220 }}>
                            {(() =>
                              this.state.onlineSalaryDataSource.map(item => {
                                return (
                                  <Option key={item} value={item}>
                                    {item}
                                  </Option>
                                );
                              }))()}
                          </Select>
                        )}
                      </Form.Item>
                      <Form.Item
                        colon={false}
                        {...formItemLayout}
                        label=" "
                        className="lao_108"
                      >
                        <span
                          style={{
                            display: "block",
                            color: "#FF9900",
                            lineHeight: "20px"
                          }}
                        >
                          注：请选择薪酬核算中的薪酬数据，系统会自动将薪酬数据中的人员及其应发工资数据带入到代发列表中。
                        </span>
                      </Form.Item>
                    </span>
                  ) : this.state.grantDataSource === "2" ? (
                    <span>
                      <Form.Item
                        {...formItemLayout}
                        label="发薪年月："
                        className="lao_108"
                      >
                        {getFieldDecorator("grantYears2", {
                          // initialValue: [],
                          // rules: [{}]
                        })(
                          <MonthPicker
                            placeholder='请选择年月'
                            format="YYYY-MM"
                            onChange={(value)=>{
                              this.setState({
                                grantYearsDown:value?value.format('YYYY-MM'):''
                              })
                            }}
                            disabledDate={(current)=>{
                              return current && current > moment(parseInt(sessionStorage.getItem('requestDate'))).endOf('day')
                            }}
                          />
                        )}
                      </Form.Item>
                      <Form.Item {...formItemLayout} label="线下数据文件">
                        {getFieldDecorator("policyUrl", {
                          rules: [{ required: false, message: "请上传" }]
                        })(
                          <span>
                            <p>
                              <Download />
                            </p>
                            <UploadFile comGrantId={gup("comGrantId")} grantYearsDown={this.state.grantYearsDown} onSuccess={()=>{
                              //上传文件成功之后,刷新代发列表,以及关闭弹窗
                              this.selectGrantDetailTotalMap();
                              this.getTable(this.state.searchData, () => {
                                this.setState({ 
                                  canAddData: false,
                                  addDataVisibale: false 
                                });
                              });
                            }}/>
                          </span>
                        )}
                      </Form.Item>
                    </span>
                  ) : this.state.grantDataSource === "3" ? (
                    <span>
                      <Form.Item
                        {...formItemLayout}
                        label="选择工资单"
                        className="lao_108"
                      >
                        {getFieldDecorator("grantYears", {
                          initialValue: JSON.stringify(this.state.payrollList[0]),
                          rules: [{}]
                        })(
                          <Select style={{ width: 220 }}>
                            {(() =>
                              this.state.payrollList.map(item => {
                                return (
                                  <Option
                                    key={item.ID}
                                    value={JSON.stringify(item)}
                                  >
                                    {item.Name}
                                  </Option>
                                );
                              }))()}
                          </Select>
                        )}
                      </Form.Item>
                      <Form.Item
                        colon={false}
                        {...formItemLayout}
                        label=" "
                        className="lao_108"
                      >
                        <span
                          style={{
                            display: "block",
                            color: "#FF9900",
                            lineHeight: "20px"
                          }}
                        >
                          只有锁定的工资单才可以发放，请到薪酬服务模块中先锁定。
                        </span>
                      </Form.Item>
                    </span>
                  ) : (
                    ""
                  )}
                </Form>
              </div>
            );
          })()}
        </Modal>
      </div>
    );
  }
}
