import React, { Component } from "react";
import { Modal, Form, Input, Button, Alert, Select, notification, Radio, Col } from 'antd';
import PFromUpload from '../../../../components/Pro/PFromUpload';
import {
  getConfigBankList, systemPlatNewsSendVerificationCode, systemPlatNewsVerificationCode, saveBankCardChangeEvent,
  BhAccountSendVerifyCode,
  taskComBhAccountUpdateComBhAccount
} from '../../../../services/api'
// import modal from "../../../../utils/modal";
import $modal from '../../../../utils/modal';
const { Option } = Select;
const formItemLayout = {
  labelCol: {
    xs: { span: 24 },
    sm: { span: 7 }
  },
  wrapperCol: {
    xs: { span: 24 },
    sm: { span: 12 },
    md: { span: 12 }
  }
};
@Form.create()
export default class WalletModal extends Component {
  constructor(props) {
    super(props);
    this.state = {
      time: 0, // 可发送验证码剩余时间
      btnName: '获取验证码',  // 发送验证码按钮名字
      timer: null, // 验证码定时器

      bankList: [],  //银行列表
    }
  }
  componentDidMount() {
    // this.__getConfigBankList();
  }
  // __getConfigBankList() {
  //   getConfigBankList().then(res => {
  //     const keyArr = [];  //过滤bankCode相同的选项后的值（只取第一个）
  //     res.data.forEach(bank => {
  //       const nowArr = JSON.parse(JSON.stringify(keyArr));
  //       if (!nowArr.find(item => item.bankCode == bank.bankCode)) { //数组里面没有
  //         keyArr.push(bank);
  //       }
  //     });
  //     this.setState({
  //       bankList: keyArr
  //     });
  //   });
  // }
  _formSubmit = e => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (err) return;
      const { bankCardNo, comName, bankNo, bankOutlets, isBhBank, activeCode, } = values;
      const { mobilePhone } = this.props.bankInfo;
      taskComBhAccountUpdateComBhAccount({
        bankCardNo, comName, bankNo, bankOutlets, isBhBank, activeCode, mobilePhone
      }).then(res => {
        if (res.retType == '0') {
          this.props.update();
          this.props.onCancel();
          const _this = this
          $modal('修改成功！', '', [{
            text: '确定',
            type: 'primary',
            onPress: () => {
              _this.props.form.resetFields();
            }
          }], 'success');
        }
      })
    });
  }
  render() {
    const { getFieldDecorator, getFieldValue } = this.props.form;
    const { mobilePhone, bhVirlAcctNo, bankOutlets, bankNo, isBhBank, comName,bankCardNo } = this.props.bankInfo
    return (
      <div>
        <Modal
          // width={600}
          title="修改企业基本户"
          visible={this.props.visible}
          okText='提交修改'
          onOk={this._formSubmit}
          onCancel={()=>{
            this.props.form.resetFields();
            this.props.onCancel()
          }}
          className="wallet_modal"
        >
          <Form style={{ marginTop: 20 }}>
            <Form.Item {...formItemLayout} label='当前企业基本户:'>
              {getFieldDecorator('oldBankCardNo', {
                initialValue: bankCardNo,
                rules: [
                  {
                    required: true,
                    message: '未获取到原账号'
                  }
                ]
              })(<Input
                placeholder=''
                disabled
                maxLength={50}
              />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='新基本户户名:'>
              {getFieldDecorator('comName', {
                initialValue: comName,
                rules: [
                  {
                    required: true,
                    message: '请输入新基本户户名'
                  },
                ]
              })(<Input
                disabled
                placeholder='请输入新基本户户名'
                maxLength={50}
              />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='是否渤海银行:'>
              {getFieldDecorator('isBhBank', {
                initialValue: isBhBank,
                rules: [
                  {
                    required: true,
                    message: '请选择是否渤海银行'
                  }
                ]
              })(<Radio.Group>
                <Radio value='1'>是</Radio>
                <Radio value='0'>否</Radio>
              </Radio.Group>)}
            </Form.Item>
            {/* 不是渤海银行卡，则需要填写开户银行名称、开户银行行号；但是还是要传 */}
            <Form.Item {...formItemLayout} label="开户银行名称:" style={{ display: getFieldValue('isBhBank') == '1' ? 'none' : 'block' }}>
              {getFieldDecorator('bankOutlets', {
                // initialValue: bankOutlets,
                rules: [{ required: true, message: '请输入开户银行名称！' }]
              })(
                <Input
                  placeholder='请输入开户银行名称'
                  maxLength={50}
                />
              )}
            </Form.Item>
            <Form.Item {...formItemLayout} label='开户银行行号:' style={{ display: getFieldValue('isBhBank') == '1' ? 'none' : 'block' }}>
              {getFieldDecorator('bankNo', {
                // initialValue: bankNo,
                rules: [
                  {
                    required: true,
                    message: '请输入开户银行行号'
                  },
                ]
              })(<Input
                placeholder='请输入开户银行行号'
                maxLength={50}
              />)}
            </Form.Item>
           
            <Form.Item {...formItemLayout} label='新基本户账号:'>
              {getFieldDecorator('bankCardNo', {
                // initialValue: this.state.activeCode,
                rules: [
                  {
                    required: true,
                    message: '请输入新基本户账号'
                  },
                  {
                    validator: (rule, value, callback) => {
                      if (value && !/^\d{0,40}$/.test(value)) {
                        callback('请输入正确卡号！');
                      } else {
                        callback();
                      }
                    }
                  }
                ]
              })(<Input
                placeholder='请输入新基本户账号'
                maxLength={50}
              />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='验证手机号:'>
              <p style={{ display: 'inline-block' }}>{mobilePhone}</p>
              <Button
                type="primary"
                disabled={this.state.time > 0}
                style={{ marginLeft: 15 }}
                onClick={() => {
                  let { time, timer } = this.state;
                  // const { mobile } = this.props;
                  if (time > 0) return;
                  if (timer) clearInterval(timer);
                  if (!mobilePhone || !/^\d{11}$/.test(mobilePhone)) {
                    // if (!mobilePhone || !/^1[34578]\d{9}$/.test(mobilePhone)) {
                    return notification.error({
                      message: '系统没有获取到手机号'
                    });
                  }
                  const DATA = {
                    mobilePhone,
                    transCode: 'HQJQ',
                    bankCardNo: this.props.bankInfo.bankCardNo,
                    comName: this.props.companyInfo.comName,
                  };
                  //发送渤海银行的验证码
                  BhAccountSendVerifyCode(DATA).then(res => {
                    this.setState({
                      orderId: res.data
                    });
                    time = 60;
                    timer = setInterval(() => {
                      time -= 1;
                      if (time > 0) {
                        this.setState({
                          time,
                          btnName: `重试(${time})`,
                          timer
                        });
                      } else {
                        clearInterval(timer);
                        this.setState({
                          btnName: '获取验证码',
                          timer: null
                        }, () => {
                          this.setState({
                            time: 0
                          });
                        });
                      }
                    }, 1000);
                  })
                }}
              >{this.state.btnName}</Button>
            </Form.Item>
            <Form.Item {...formItemLayout} label='短信验证码:'>
              {getFieldDecorator('activeCode', {
                initialValue: this.state.activeCode,
                rules: [
                  {
                    required: true,
                    message: '请输入验证码'
                  },
                  {
                    validator: (rule, value, callback) => {
                      if (value && !/\d{0,6}/.test(value)) {
                        callback('请输入正确验证码');
                      } else {
                        callback();
                      }
                    }
                  }
                ]
              })(<Input
                placeholder='请输入短信验证码'
                onChange={e => {
                  this.setState({
                    codeValue: e.target.value
                  });
                }}
                maxLength={50}
              />)}
            </Form.Item>
          </Form>
        </Modal>
      </div>
    );
  }
}

