import React from 'react';
import HeaderComponent from '../HeaderComponent';
import { connect } from 'dva';
import {
  publicCommonDictGetDictByCodeTypes,
  getConfigBankList,
  taskComBhAccountSendOpenAccountVerifyCode,
  taskComBhAccountSaveComBhAccount
} from '../../../../services/api';
import PFromUpload from '../../../../components/Pro/PFromUpload';
import { photoItemLayout, formItemLayout1 } from '../../../../constants/formItemLayout';
import { Form, Input, Button, Row, Col, notification, Radio } from 'antd';
@connect(state => ({
  global: state.global
}))
@Form.create()
export default class BusinessWallet extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      companyInfo: JSON.parse(window.sessionStorage.getItem('companyInfo')),  // 公司信息
      comCerType: [], //企业证件类型
      submitStatus: true, // 验证码发送成功以后才能提交

      selectedBanks: [],  //选中的银行

      time: 0, // 可发送验证码剩余时间
      btnName: '获取验证码',  // 发送验证码按钮名字
      timer: null, // 验证码定时器
      mobilePhone: '' //绑定验证手机号
    };
  }
  componentDidMount() {
    // 获取企业证件类型
    this.publicCommonDictGetDictByCodeTypes();
    // 绑定充值、结算卡银行列表
  }
  //类型查询
  publicCommonDictGetDictByCodeTypes = () => {
    const codeTypes = "comCerType";
    publicCommonDictGetDictByCodeTypes({ codeTypes }).then(({ data = {} }) => {
      this.setState({ comCerType: data.comCerType });
    }, (err) => {
      console.log(err);
    });
  }
  //验证身份证号码
  checkIdCardNo = (rule, value, callback) => {
    if (value && !(/(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/).test(value)) {
      callback('请输入正确的身份证号码！');
    } else {
      callback();
    }
  };
  handleSubmit = e => {
    e.preventDefault();
    this.setState({
      submitStatus: true
    });
    this.props.form.validateFields((err, values) => {
      if (!err) {
        values.comCerType = '2';
        values.isBhBank = '0';
        taskComBhAccountSaveComBhAccount(values).then(res => {
          this.props.reload && this.props.reload();
        }).catch(err => {
          this.setState({
            submitStatus: false
          });
        });
      } else {
        this.setState({
          submitStatus: false
        });
      }
    });
    clearInterval(this.state.timer);
    this.setState({
      btnName: '获取验证码',
      timer: null
    }, () => {
      this.setState({
        time: 0
      });
    });
  };
  render() {
    const { getFieldDecorator, getFieldValue } = this.props.form;
    return (
      <div>
        <HeaderComponent breadcrumb={['企业发薪账户', '开通账户']} step={0} setStatus={() => { this.props.setStatus && this.props.setStatus(0); }} />

        <div className="form_container">
          <h2>填写开户资料</h2>
          {/* <p className="header"></p> */}
          <Row>
            <Col span={16}>
              <Form onSubmit={this.handleSubmit}>
                <Form.Item {...formItemLayout1} label='企业名称:'>
                  {getFieldDecorator('comName', {
                    initialValue: this.state.companyInfo.comName,
                    rules: [
                      {
                        required: true,
                        message: '默认企业名称,不可编辑'
                      },
                      {
                        validator: (rule, value, callback) => {
                          if (value && !/^\S{0,50}$/.test(value)) {
                            callback('请输入正确的企业名称！');
                          } else {
                            callback();
                          }
                        }
                      }
                    ]
                  })(<Input placeholder='请输入' disabled maxLength={50} />)}
                </Form.Item>
                <Form.Item {...formItemLayout1} label='统一社会信用代码:'>
                  {getFieldDecorator('comCerNo', {
                    initialValue: this.state.companyInfo.comCerNo,
                    rules: [
                      {
                        required: false,
                        message: '默认企业代码,不可编辑'
                      },
                      {
                        validator: (rule, value, callback) => {
                          if (value && !/^\S{0,50}$/.test(value)) {
                            callback('请输入正确的统一社会信用代码！');
                          } else {
                            callback();
                          }
                        }
                      }
                    ]
                  })(<Input placeholder='请输入' disabled maxLength={50} />)}
                </Form.Item>
                <Form.Item {...formItemLayout1} label='法人姓名:'>
                  {getFieldDecorator('legalRepName', {
                    initialValue: this.state.companyInfo.legalRepName,
                    rules: [
                      {
                        required: true,
                        message: '请输入法人姓名'
                      },
                      {
                        validator: (rule, value, callback) => {
                          if (value && !/^\S+$/.test(value)) {
                            callback('请输入正确的法人姓名！');
                          } else {
                            callback();
                          }
                        }
                      }
                    ]
                  })(<Input placeholder='请输入' maxLength={10} />)}
                </Form.Item>
                <Form.Item {...formItemLayout1} label='身份证号:'>
                  {getFieldDecorator('idCardNo', {
                    initialValue: this.state.companyInfo.idCardNo,
                    rules: [{
                      required: true, message: '请输入身份证号',
                    }, {
                      validator: this.checkIdCardNo
                    }],
                  })(<Input placeholder='请输入' maxLength={18} />)}
                </Form.Item>
                <h2>企业基本户信息</h2>
                <Form.Item {...formItemLayout1} label="开户银行名称:">
                  {getFieldDecorator('bankOutlets', {
                    initialValue: [],
                    rules: [{ required: true, message: '请输入开户银行名称' }, {
                      validator: (rule, value, callback) => {
                        if (value && !/^\S+$/.test(value)) {
                          callback('请输入正确的开户银行名称');
                        } else {
                          callback();
                        }
                      }
                    }]
                  })(
                    <Input placeholder='请输入' maxLength={50} />
                  )}
                </Form.Item>
                <Form.Item {...formItemLayout1} label='开户银行行号:'>
                  {getFieldDecorator('bankNo', {
                    // initialValue: this.state.companyInfo.idCardNo,
                    rules: [{ required: true, message: '请输入开户银行行号' },{
                      validator: (rule, value, callback) => {
                        if (value && !/^\S+$/.test(value)) {
                          callback('请输入正确的开户银行行号');
                        } else {
                          callback();
                        }
                      }
                    }]
                  })(<Input placeholder='请输入' maxLength={14} />)}
                </Form.Item>
                <Form.Item {...formItemLayout1} label='是否渤海银行:'>
                  {getFieldDecorator('isBhBank', {
                    // initialValue: isBhBank,
                    rules: [
                      {
                        required: true,
                        message: '请选择是否渤海银行'
                      }
                    ]
                  })(<Radio.Group>
                    <Radio value={1}>是</Radio>
                    <Radio value={0}>否</Radio>
                  </Radio.Group>)}
                </Form.Item>
                <Form.Item {...formItemLayout1} label='基本户账号:'>
                  {getFieldDecorator('bankCardNo', {
                    // initialValue: this.state.companyInformationData.comName,
                    rules: [
                      {
                        required: true,
                        message: '请输入企业基本户账号'
                      },
                      {
                        validator: (rule, value, callback) => {
                          if (value && !/^\S+$/.test(value)) {
                            callback('请输入正确的基本户账号');
                          } else {
                            callback();
                          }
                        }
                      }
                    ]
                  })(<Input placeholder='请输入' maxLength={32} />)}
                </Form.Item>
                <Form.Item {...formItemLayout1} label='绑定手机号:'>
                  <Row>
                    <Col span={17}>
                      {getFieldDecorator('mobilePhone', {
                        value: this.state.mobilePhone,
                        rules: [
                          {
                            required: true,
                            message: '请输入绑定手机号'
                          },
                          {
                            validator: (rule, value, callback) => {
                              // if (value && !/^1[34578]\d{9}$/.test(value)) {
                              if (value && !/\d{11}$/.test(value)) {
                                callback('请输入正确绑定手机号！');
                              } else {
                                callback();
                              }
                            }
                          }
                        ]
                      })(<Input
                        onChange={e => {
                          this.setState({
                            mobilePhone: e.target.value
                          });
                        }}
                        placeholder='请输入'
                        maxLength={11}
                      />)}
                    </Col>
                    <Col span={6} offset={1}>
                      <Button type="primary"
                        disabled={this.state.time > 0}
                        onClick={() => {
                          let { time, timer, companyInfo } = this.state;
                          const mobilePhone = getFieldValue('mobilePhone');
                          const bankCardNo = getFieldValue('bankCardNo');
                          if (time > 0) return;
                          if (timer) clearInterval(timer);
                          if (!mobilePhone || !/^1[34578]\d{9}$/.test(mobilePhone)) {
                            return notification.error({
                              message: '请输入正确手机号！'
                            });
                          }
                          if (!bankCardNo) {
                            return notification.error({
                              message: '请输入银行卡号！'
                            });
                          }

                          const DATA = {
                            mobilePhone,
                            bankCardNo,
                            comName: companyInfo.comName,
                            idCardNo: companyInfo.idCardNo
                          }
                          taskComBhAccountSendOpenAccountVerifyCode(DATA).then(res => {
                            this.setState({
                              submitStatus: false
                            });
                            time = 60;
                            timer = setInterval(() => {
                              time -= 1;
                              if (time > 0) {
                                this.setState({
                                  time,
                                  btnName: `重试(${time})`,
                                  timer
                                });
                              } else {
                                clearInterval(timer);
                                this.setState({
                                  btnName: '获取验证码',
                                  timer: null
                                }, () => {
                                  this.setState({
                                    time: 0
                                  });
                                });
                              }
                            }, 1000);
                          });
                        }}
                      >{this.state.btnName}</Button>
                      {/* <div className="form_tip">
                        <span>验证手机号：用以企业钱包进行转账（薪资代发）、提现等资金变动时验证码接收。</span>
                      </div> */}
                    </Col>
                  </Row>
                </Form.Item>
                <Form.Item {...formItemLayout1} label='短信验证码:'>
                  {getFieldDecorator('activeCode', {
                    // initialValue: this.state.companyInformationData.comName,
                    rules: [
                      {
                        required: true,
                        message: '请输入短信验证码'
                      },
                      {
                        validator: (rule, value, callback) => {
                          if (value && !/^\d{0,6}$/.test(value)) {
                            callback('请输入正确短信验证码！');
                          } else {
                            callback();
                          }
                        }
                      }
                    ]
                  })(<Input placeholder='请输入' maxLength={6} />)}
                </Form.Item>
                <Form.Item {...photoItemLayout} label="统一社会信用代码证件照" extra={<span style={{ color: '#f7c407' }}>(仅支持8M以内的jpg格式)</span>}>
                  {getFieldDecorator(`comCerUrl`, {
                    // initialValue: this.state.photo.idCardFrontUrl,
                    rules: [
                      {
                        required: true,
                        message: `请上传统一社会信用代码证件照`
                      }
                    ]
                  })(
                    <PFromUpload
                      // key={this.state.key}
                      num={1}
                      size={8}
                      types={['image/jpg']}
                      onChange={url => {
                        this.setState({
                          photo: {
                            ...this.state.photo,
                            idCardFrontUrl: url
                          }
                        });
                      }}
                    />
                  )}
                </Form.Item>
                <Form.Item {...photoItemLayout} label="法人身份证国徽面" extra={<span style={{ color: '#f7c407' }}>(仅支持8M以内的jpg格式)</span>}>
                  {getFieldDecorator(`idCardFrontUrl`, {
                    // initialValue: this.state.photo.idCardReverseUrl,
                    rules: [
                      {
                        required: true,
                        message: `请上传身份证国徽面`
                      }
                    ]
                  })(
                    <PFromUpload
                      // key={this.state.key}
                      num={1}
                      size={8}
                      types={['image/jpg']}
                      onChange={url => {
                        this.setState({
                          photo: {
                            ...this.state.photo,
                            idCardReverseUrl: url
                          }
                        });
                      }}
                    />
                  )}
                </Form.Item>
                <Form.Item {...photoItemLayout} label="法人身份证人像面" extra={<span style={{ color: '#f7c407' }}>(仅支持8M以内的jpg格式)</span>}>
                  {getFieldDecorator(`idCardReverseUrl`, {
                    // initialValue: this.state.photo.idCardFrontUrl,
                    rules: [
                      {
                        required: true,
                        message: `请上传身份证人像面`
                      }
                    ]
                  })(
                    <PFromUpload
                      key={this.state.key}
                      num={1}
                      size={8}
                      types={['image/jpg']}
                      onChange={url => {
                        this.setState({
                          photo: {
                            ...this.state.photo,
                            idCardFrontUrl: url
                          }
                        });
                      }}
                    />
                  )}
                </Form.Item>
                <Form.Item {...formItemLayout1} label=" " colon={false}>
                  <Button type="primary"
                    // disabled={this.state.submitStatus}
                    htmlType="submit"
                  >提交开通</Button>
                </Form.Item>
              </Form>
            </Col>
          </Row>
        </div>
      </div>
    );
  }
}
