import React from 'react';
import { connect } from 'dva';
import { Button, Checkbox } from 'antd';
import b_wallet from '../../../../assets/images/wallet/b_wallet.png';
@connect(state => ({
  global: state.global
}))
export default class StepOne extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      readed: false
    };
  }
  render() {
    return (
      <div className="before_container">
        <div className="financial_header">
          <div className="img_box">
            {/* <img src={this.props.global.companyInfo.comCerUrl} alt=""/> */}
            <img src={b_wallet} alt="金融钱包" />
          </div>
          <div className="header_info" style={{ overflow: 'hidden' }}>
            <p className="title">企业发薪账户</p>
            <div>
              <Button
                type="primary"
                disabled={!this.state.readed}
                // style={{marginLeft: 20}}
                onClick={() => {
                  this.props.setStatus && this.props.setStatus(1);
                }}
              >
                立即开通
              </Button>
            </div>
            <Checkbox
              style={{ marginTop: 10 }}
              onChange={e => {
                this.setState({
                  readed: e.target.checked
                });
              }}></Checkbox>
            <span style={{ color: '#FF6600', fontSize: 14, marginLeft: 5 }}>勾选则表示您已阅并同意</span>
            <a style={{ fontSize: 14 }} href="#" target="_blank">
              《百保盾平台薪资代发三方合作协议》
              </a>
          </div>
        </div>

        <div className="question_info">
          <h3>Q：什么是企业发薪账户？</h3>
          <div>企业发薪账户，由渤海银行为企业提供的薪资代发电子账户；支持将企业需要发放的薪资，通过线上系统直接发放至各人员的保安员证联名卡账户中。</div>
          <h3>Q：薪资发放需要收费吗？</h3>
          <div>
            <p>
              通过本平台的薪资发放功能，不需要支付任何费用。
            </p>
          </div>
          <h3>Q：薪资发放只能发放到保安员证联名卡吗？</h3>
          <div>
            <p>
              是的。因此请提醒您企业的保安员尽快开通联名卡，只有用联名卡作为工资卡接收工资，才可以免费使用免费薪资发放服务。
              </p>
          </div>
        </div>
      </div>
    );
  }
}