import React, { Component } from 'react';
import { connect } from 'dva';
import {
  Input,
  Button,
  Table,
  Select,
  Modal,
  Radio,
  Alert
} from 'antd';
import { withRouter } from 'dva/router';
import * as ajax from '../../../services/api';
const { Option } = Select;
@connect(state => ({
  global: state.global
}))
@withRouter
export default class Uninsured extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      // 搜索部分
      searchData: {  // 表格数据请求参数
        keyword: '',  //关键字
        pageNumber: '1',  // 页	
        pageSize: '10'  //条目
      },
      keyword: '', //关键字
      // 表格部分
      tableList: [], // 表格数据
      pagination: {  //分页数据
        total: 1,
        current: 1,
        pageSize: 10,
        showSizeChanger: true,
        showQuickJumper: true,
        onShowSizeChange: (current, pageSize) => {
          // this.setState({
          //   searchData: {
          //     ...this.state.searchData,
          //     pageSize: pageSize+'',
          //     pageNumber: current+''
          //   }
          // },() => {
          //   console.log(this.state.searchData);
          //   this.getTable(this.state.searchData);
          // });
          // console.log(current, pageSize);
        }
      },
      selectedRows: [], //表格中选中的数组
      selectedRowKeys: [],

    };
  }



  componentDidMount() {
    this.getTable(this.state.searchData, data => {

    });
  }

  // 获取表格信息
  getTable = (data, cb) => {
    ajax.getOpenWalletServicePerList(data).then(res => {
      const { comName } = this.props.global.companyInfo;
      const tableList = res.data.data.map(item => {
        if(item.departName == '-') {
          item.departName = comName;
        }
        return item;
      });
      this.setState({
        tableList,
        pagination: {
          ...this.state.pagination,
          total: res.data.total,
          current: res.data.pageNumber,
          pageSize: res.data.pageSize
        },
        selectedRowKeys: [],
        selectedRows: []
      }, () => {
        cb && cb(res.data);
        this.props.refresh();
      });
    });
  }

  // 表格渲染
  renderOrderList = () => {
    const columns = [
      {
        title: '姓名',
        dataIndex: 'name',
        key: 'name'
      },
      {
        title: '身份证号',
        dataIndex: 'idCardNo',
        key: 'idCardNo'
      },
      // {
      //   title: '开通状态',
      //   dataIndex: 'idCardNo',
      //   key: 'idCardNo'
      // },
      {
        title: '钱包账户号',
        dataIndex: 'walletAccountNo',
        key: 'walletAccountNo'
      },
      {
        title: '账户状态',
        dataIndex: 'accountStatus',
        key: 'accountStatus'
      },
      {
        title: '验证手机号',
        dataIndex: 'mobilePhone',
        key: 'mobilePhone'
      },
      {
        title: '结算卡银行',
        dataIndex: 'bankName',
        key: 'bankName'
      },
      {
        title: '结算卡号',
        dataIndex: 'bankCardNo',
        key: 'bankCardNo'
      },
      {
        title: '开户时间',
        dataIndex: 'createTime',
        key: 'createTime'
      },
      // {
      //   title: '操作',
      //   dataIndex: 'operation',
      //   key: 'operation',
      //   render: (text, record) => (
      //     <div>
      //       <span
      //         style={{
      //           color: '#108EE9',
      //           cursor: 'pointer',
      //           marginRight: '20px'
      //         }}
      //         onClick={() => {
      //          console.log('提醒开通');
      //         }}
      //       >
      //         提醒开通
      //       </span>
      //     </div>
      //   )
      // }
    ];
    return (
      <div>
        <Table
          dataSource={this.state.tableList}
          columns={columns}
          pagination={this.state.pagination}
          onChange={(pagination) => {
            const searchData = {  // 搜索数据
              ...this.state.searchData,
              pageNumber: pagination.current,  // 页	
              pageSize: pagination.pageSize
            };
            this.setState({
              searchData
            }, () => {
              this.getTable(searchData);
            });

          }}
        // rowSelection={{
        //   onChange: (selectedRowKeys, selectedRows) => {
        //     this.setState({
        //       selectedRows,
        //       selectedRowKeys
        //     });
        //   },
        //   selectedRowKeys: this.state.selectedRowKeys     
        // }}
        />
      </div>
    );
  };

  render() {
    return (
      <div className="tab_inner">
        <Alert
          message={<span>您可在此页面查看企业下员工钱包服务开通情况；只有员工开通了钱包服务，薪资代发才可发放到该员工钱包中，否则无法发放。</span>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        <div className="form">
          <label style={{ marginRight: 16 }}>
            关键字：
            <Input
              style={{ width: '214px', marginBottom: '10px' }}
              placeholder="请输入姓名/身份证/手机号"
              value={this.state.keyword}
              onChange={(e) => {
                this.setState({
                  keyword: e.target.value
                });
              }}
              maxLength={20}
            />
          </label>
          <Button
            style={{
              marginRight: '16px',
              marginBottom: '16px',
              padding: window && window.innerWidth <= 1366 ? '0 10px' : '0 15px'
            }}
            type="primary"
            onClick={() => {
              const data = {
                ...this.state.searchData,
                keyword: this.state.keyword
              };
              this.setState({
                searchData: data
              });
              this.getTable(data);
            }}
          >
            搜索
          </Button>
          <Button
            onClick={() => {
              this.setState({
                keyword: '',
                searchData: {
                  keyword: '',  //关键字
                  pageNumber: '1',  // 页	
                  pageSize: '10'  //条目
                }
              }, () => {
                this.getTable(this.state.searchData);
              });
            }}
            style={{
              padding: window && window.innerWidth <= 1366 ? '0 10px' : '0 15px'
            }}
          >
            重置
          </Button>
        </div>
        {this.renderOrderList()}
      </div>
    );
  }
}
