import React from 'react';
import { connect } from 'dva';
import HeaderComponent from './HeaderComponent';
import PFromUpload from '../../../components/Pro/PFromUpload';
import {
  publicCommonDictGetDictByCodeTypes,
  saveCccountInfoStepTwo
} from '../../../services/api';
import { Form, Select, Input, Button, Row, Col } from  'antd';
const { Option } = Select;
@Form.create()
@connect(state => ({
  financial: state.financial
}))
export default class BusinessWallet extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      companyInfo: JSON.parse(window.sessionStorage.getItem('companyInfo')),  // 公司信息
      comCerType: [], //企业证件类型
    };
  }
  componentWillMount() {
    const stepInfo = this.props.financial.stepInfo;
    // 如果上一步的值存在，读取上一步的值作为公司信息
    if(stepInfo) {
      this.setState({
        companyInfo: stepInfo
      });
    }
  }
  componentDidMount() {
    // 获取企业证件类型
    this.publicCommonDictGetDictByCodeTypes();
  }
  //类型查询
  publicCommonDictGetDictByCodeTypes = () => {
    const codeTypes = "comCerType";
    publicCommonDictGetDictByCodeTypes({ codeTypes }).then(({ data = {} }) => {
      this.setState({ comCerType: data.comCerType });
    }, (err) => {
      console.log(err);
    });
  }
  handleSubmit = e => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        saveCccountInfoStepTwo(values).then(res => {
          this.props.setStatus(4);
        });
      }
    });
  };
  render() {
    const { getFieldDecorator } = this.props.form;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 7 }
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 12 },
        md: { span: 10 }
      }
    };
    return (
       <div>
         <HeaderComponent breadcrumb={['企业钱包', '开通钱包']} step={1}></HeaderComponent>
         
         <div className="form_container">
            <p className="header">上传证件资料</p>
            <Form onSubmit={this.handleSubmit}>
              <Form.Item {...formItemLayout} label='企业名称:'>
                {getFieldDecorator('comName', {
                  initialValue: this.state.companyInfo.comName,
                  rules: [
                    {
                      required: true,
                      message: '请输入企业名称'
                    },
                    {
                      validator: (rule, value, callback) => {
                        if (value && !/^\S{0,50}$/.test(value)) {
                          callback('请输入正确的企业名称！');
                        } else {
                          callback();
                        }
                      }
                    }
                  ]
                })(<Input disabled placeholder='请选择' maxLength={50} />)}
              </Form.Item>
              
              {/* <Form.Item {...formItemLayout} label="企业证件类型:" hasFeedback>
                  {getFieldDecorator('comCerType', {
                    initialValue: this.state.companyInfo.comCerType,
                    rules: [{ required: true, message: '请选择企业证件类型!' }],
                  })(
                    <Select disabled>
                      {(() => {
                        const { comCerType } = this.state;
                        return comCerType.map(
                          (val, key) => (
                            <Option
                              value={val.codeValue}
                              key={key}>
                              {val.label}
                            </Option>
                          ));
                      })()}
                    </Select>
                  )}
                </Form.Item> */}

                {/* <Form.Item {...formItemLayout} label='企业证件号码:'>
                  {getFieldDecorator('comCerNo', {
                    initialValue: this.state.companyInfo.comCerNo,
                    rules: [
                      {
                        required: true,
                        message: '请输入企业证件号码'
                      },
                      {
                        validator: (rule, value, callback) => {
                          if (value && !/^\S{0,50}$/.test(value)) {
                            callback('请输入正确的企业证件号码！');
                          } else {
                            callback();
                          }
                        }
                      }
                    ]
                  })(<Input disabled placeholder='请输入' maxLength={50} />)}
                </Form.Item> */}

              <Form.Item
                {...formItemLayout}
                label="企业证件扫描件"
              // help="每张不超过:8M,格式为:jpg，jpeg，png"
              >
                {getFieldDecorator('comCerUrl', {
                  // initialValue: this.state.certificationData.comCerUrl,
                  rules: [
                    {
                      required: true,
                      message: '请上传证件扫描件'
                    }
                  ]
                })(
                  <PFromUpload
                    num={1}
                    // types={['image/jpg', 'image/jpeg']}
                    // disabled={this.state.statusBianDisabled}
                  />
                )}
                {/* <p>每张不超过:8M,仅支持jpg</p> */}
                <p>每张不超过:2M,支持jpg,jpeg,png</p>
              </Form.Item>

              <Form.Item {...formItemLayout} label=" " colon={false}>
                <Button type="primary" htmlType="submit">确定并下一步</Button>
              </Form.Item>
            </Form>
         </div>
       </div>
    );
  }
}
