import React from 'react';
import { connect } from 'dva';
import {
  getComWalletCurrentProcess
}from '../../../services/api';
import { Button, Checkbox } from 'antd';
import b_wallet from '../../../assets/images/wallet/b_wallet.png';
@connect(state => ({
  global: state.global
}))
export default class StepOne extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state={
      readed: false
    };
  }
  render() {
    return (
       <div className="before_container">
         <div className="financial_header">
          <div className="img_box">
              {/* <img src={this.props.global.companyInfo.comCerUrl} alt=""/> */}
              <img src={b_wallet} alt="金融钱包"/>
          </div>
          <div className="header_info" style={{overflow: 'hidden'}}>
              <p className="title">企业钱包服务</p> 
              <div>
                <Button 
                  type="primary" 
                  disabled={!this.state.readed}
                  // style={{marginLeft: 20}}
                  onClick={() => {
                    getComWalletCurrentProcess().then(res => {
                      const step = res.data.step + 1;
                      this.props.setStatus(step);
                    });
                  }}
                >
                  立即申请
                </Button>
                {/* {(() => {
                  // 未授权
                  if(this.props.isAuthorize == 0) {
                    return <Button type="primary" disabled>企业未授权开通</Button>
                  }else if(this.props.isAuthorize == 1) {// 已授权
                    return <Button 
                      type="primary" 
                      disabled={this.state.readed}
                      // style={{marginLeft: 20}}
                      onClick={() => {
                        getComWalletCurrentProcess().then(res => {
                          const step = res.data.step + 1;
                          this.props.setStatus(step);
                        });
                      }}
                    >
                      立即申请
                    </Button>
                  }
                })()} */}
              </div>
              <Checkbox 
                style={{marginTop: 10}}
                onChange={e => {
                this.setState({
                  readed: e.target.checked
                });
              }}></Checkbox>
              <span style={{color: '#FF6600', fontSize: 14, marginLeft: 5}}>勾选则表示您已阅并同意</span>
              <a style={{fontSize: 14}} href="/finance/agreement/wallet" target="_blank">
                《富民银行委托结算服务协议》
              </a>
              {/* <p className="tip">请联系在线客服，确定合作意向，完成服务签约后，即可在本页面在线开通。</p> */}
            </div>
         </div>
         
         <div className="question_info">
           <h3>Q：什么是钱包服务？</h3>
           <div>百保盾钱包服务，是百保盾薪酬+的核心服务，由百川信公司、富民银行、中国银联联合打造的专为公共安全行业企业提供的全线上资金存管及结算服务，企业的资金由富民银行进行安全监管。</div>
           <h3>Q：钱包服务可以做什么？</h3>
           <div>
            <p>
              企业及员工开通了钱包服务，即可免费使用薪资代发功能，0代发服务费，1秒分发到账；<br />
              保安员资格证考试报名缴费、收款均可通过钱包服务完成。
            </p>
            </div>
           <h3>Q：钱包服务如何开通？</h3>
           <div>
              <p>
              企业点击上方的“立即申请”按钮，根据页面提示完成开户开通操作即可；详情可参考帮助文档 <a href="http://wiki.baibaodun.cn/document/indexOut?document_id=1091" target="_blank">企业钱包开通</a> <br/>
              员工需要登录到百保盾Pro App，在个人中心进行开户开通。
              </p>
            </div>
           {/* <Typography>
            <Title>Introduction</Title>
            <Paragraph>
              In the process of internal desktop applications development, many different design specs and
              implementations would be involved, which might cause designers and developers difficulties and
              duplication and reduce the efficiency of development.
            </Paragraph>
           </Typography> */}
         </div>
       </div>
    );
  }
}