import React, { Component } from 'react';
import { connect } from 'dva';
import { Form, Input, Button, Icon, Select, Popover, Avatar, Badge, Modal } from 'antd';
import './ExaminationApproval.less';
import DepartmentPopSelect from "../../components/DepartmentPopSelect";

const FormItem = Form.Item;
const { Option } = Select;
const {confirm} = Modal.confirm;

@connect(state => ({
  profile: state.profile,
}))

@Form.create()


export default class ExaminationApprovalManage extends Component {
  state = {
    expand: false
  };

  componentDidMount() {
    // To disabled submit button at the beginning.
    this.props.form.validateFields();
  }
  handleSubmit = (e) => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        console.log('Received values of form: ', values);
      }
    });
  }

  toggle = () => {
    const { expand } = this.state;
    this.setState({ expand: !expand });
  }


  render() {
    const { getFieldDecorator, getFieldError, isFieldTouched } = this.props.form;
    const content = (
      <div className="ea-item-poperpop">
        <p>编辑</p>
        <p>流程</p>
        <p onClick={() => {
          confirm({
            title: '是否确认停用该审批模板?',
            okText:"确认",
            cancelText:"取消",
            onOk() {
              console.log('OK');
            },
            onCancel() {
              console.log('Cancel');
            },
          });
        }}>停用</p>
        <p>删除</p>
      </div>
    );
    // Only show error after a field is touched.
    const userNameError = isFieldTouched('userName') && getFieldError('userName');
    return (
      <div className="ExaminationApproval">
        <div className="card">审批管理</div>
        <Form className="ExaminationApproval-form" layout="inline" onSubmit={this.handleSubmit}>
          <FormItem
            label="审批类型"
            validateStatus={userNameError ? 'error' : ''}
            help={userNameError || ''}
          >
            {getFieldDecorator('userName', {
              rules: [{ required: true, message: 'Please input your username!' }],
            })(
              <Select
                style={{ width: 171 }}
                placeholder="全部"
                optionFilterProp="children"
              >
                <Option value="jack">Jack</Option>
                <Option value="lucy">Lucy</Option>
                <Option value="tom">Tom</Option>
              </Select>)}
          </FormItem>
          <FormItem
            label="状态"
            validateStatus={userNameError ? 'error' : ''}
            help={userNameError || ''}
          >
            {getFieldDecorator('userName', {
              rules: [{ required: true, message: 'Please input your username!' }],
            })(
              <Select
                style={{ width: 171 }}
                placeholder="全部"
                optionFilterProp="children"
              >
                <Option value="jack">Jack</Option>
                <Option value="lucy">Lucy</Option>
                <Option value="tom">Tom</Option>
              </Select>
              )}
          </FormItem>
          <FormItem
            label="排序"
            validateStatus={userNameError ? 'error' : ''}
            help={userNameError || ''}
          >
            {getFieldDecorator('userName', {
              rules: [{ required: true, message: 'Please input your username!' }],
            })(
              <Select
                style={{ width: 171 }}
                placeholder="最新创建"
                optionFilterProp="children"
              >
                <Option value="jack">Jack</Option>
                <Option value="lucy">Lucy</Option>
                <Option value="tom">Tom</Option>
              </Select>
              )}
          </FormItem>
          <FormItem
            label="审批名字"
            validateStatus={userNameError ? 'error' : ''}
            help={userNameError || ''}
          >
            {getFieldDecorator('userName', {
              rules: [{ required: true, message: 'Please input your username!' }],
            })(
              <Input placeholder="请输入" />
              )}
          </FormItem>
          <FormItem>
            <Button
              type="primary"
              htmlType="submit"
            >
              搜索
            </Button>
          </FormItem>
        </Form>
        <div className="ealist">
          <div className="ea-item ea-item-add">
            <Icon style={{ fontSize: 32 }} type="plus" />
            新增审批
          </div>
          <div className="ea-item">
            <div className="ea-item-top">
              <Avatar size="large" src="https://zos.alipayobjects.com/rmsportal/ODTLcjxAfvqbxHnVXCYX.png" />
              <Popover placement="bottom" content={content} title="" trigger="click">
                <Icon type="ellipsis" />
              </Popover>
              <div className="title">出差申请</div>
              <p>有出有效期任务的同事请选择此荐</p>
            </div>
            <div className="ea-item-footer">
              <Badge status="warning" text="停用" />
              <span onClick={() => {}}>部份可见</span>
              <span>出勤休假</span>
            </div>
          </div>
          <div className="more">加载更多</div>

        </div>
        <DepartmentPopSelect title="选择审批可见范围" visible={this.state.visible} />
      </div>
    );
  }
}
