import React, { PureComponent } from "react";
import { connect } from "dva";
import moment from 'moment';
import style from "styled-components";
import { Input, Button, DatePicker, Form } from 'antd';
import PSelect from "../../../components/Pro/PSelect";
import PTable from "../../../components/Pro/PTable";
import EditExamination from './EditExamination';
import './ApprovalList.less';

const dateFormat = 'YYYY-MM-DD';
const { RangePicker } = DatePicker;

export default class Examination extends PureComponent {
    constructor(props, context) {
        super(props, context);
        this.state = {
            openEdit: false, //抽屉组件状态
            approvalId: '',
            forceUpdate: false, //刷新数据
            keyword: '', //关键字
            approveStatus: '', //审批状态
            approveType: '', //审批类型
            editApproveStatus: '',//查看对应的审批状态
            //发起日期
            launchStar: '',//起
            launchEnd: '',//止
            // 分页
            pageParm: {
                pageNumber: "1",
                pageSize: "10",
                keyword: '',
                approveStatus: '',
                launchStar: '',
                launchEnd: ''
            }
        };
    }
    componentDidMount() {
    }

    //输入框的书写
    inputTracknameChange = e => {
        this.setState({
            keyword: e.target.value.trim()
        });
    };

    //审批状态 change
    pSelectChange = (value) => {
        this.setState({ approveStatus: value });
    };

    //发起日期选择
    onChangeTime = (date, dateString) => {
        this.setState({
            launchStar: dateString[0],
            launchEnd: dateString[1]
        });
    };

    //搜索
    clickSearch = () => {
        const pageParm = { ...this.state.pageParm };
        //关键字，审批状态，发起时间
        const { keyword, approveStatus, launchStar, launchEnd} = this.state;
        console.log(this.state);
        pageParm.keyword = keyword;
        pageParm.approveStatus = approveStatus;
        if (launchStar && launchEnd) {
            pageParm.launchStar = launchStar.replace(/\//g, '-') + ' 00:00:00';
            pageParm.launchEnd = launchEnd.replace(/\//g, '-') + ' 23:59:59';
        } else {
            pageParm.launchStar = launchStar;
            pageParm.launchEnd = launchEnd;
        }
        this.setState({
            pageParm,
            forceUpdate: true //对列表进行刷新
        }, () => {
            this.setState({
                forceUpdate: false
            });
        });
    }

    //重置
    clickRest = () => {
        const pageParm = { ...this.state.pageParm };
        pageParm.keyword = '';
        pageParm.approveStatus = '';
        pageParm.launchStar = '';
        pageParm.launchEnd = '';
        this.setState({
            pageParm,
            forceUpdate: true, //对列表进行刷新
            keyword:'',
            approveStatus:'',
            launchStar: '',
            launchEnd: ''
        }, () => {
            this.setState({
                forceUpdate: false
            });
        });
    }

    //点击查看
    editDrawer = (approvalId, approveType, approveStatus) => {
        this.setState({
            openEdit: true,
            approvalId,
            approveType,
            editApproveStatus:approveStatus
        });
    }

    //渲染表格
    renderTable = () => {
        const color = ["#FF9900", "#008000", "#FE5500", "#999999"];//审核中，审核通过，审核不通过，撤销
        const columns = [
            {
                title: '审批单号',
                dataIndex: 'approveApplyId',
                key: 'approveApplyId',
            }, {
                title: '审批类型',
                dataIndex: 'approveTypeName',
                key: 'approveTypeName',
                render: (text) => (
                    <div>
                        <p style={{ maxWidth: '150px' }}>{text}</p>
                    </div>
                )
            }, {
                title: '发起人',
                dataIndex: 'name',
                key: 'name',
                render: (text) => (
                    <div>
                        <p style={{ maxWidth: '350px' }}>{text}</p>
                    </div>
                )
            }, {
                title: '当前审批人',
                dataIndex: 'nextPerName',
                key: 'nextPerName',
                render: (text) => (
                    <div>
                        <p style={{ maxWidth: '350px' }}>{text !== '' ? text : '暂无'}</p>
                    </div>
                )
            }, {
                title: '发起时间',
                dataIndex: 'createTime',
                key: 'createTime',
                render: (text) => (
                    <div>
                        <p style={{ maxWidth: '350px' }}>{text}</p>
                    </div>
                )
            }, {
                title: '更新时间',
                dataIndex: 'updateTime',
                key: 'updateTime',
                render: (text) => (
                    <div>
                        <p style={{ maxWidth: '350px' }}>{text !== '' ? text : '暂无'}</p>
                    </div>
                )
            }, {
                title: '状态',
                dataIndex: 'approveStatusName',
                key: 'approveStatusName',
                render: (text, record) => (
                    <div>
                        <p style={{
                            color: record.approveStatus === "0" ?
                                color[0] : record.approveStatus === "1" ?
                                    color[1] : record.approveStatus === "2" ?
                                        color[2] : color[3]
                        }}>
                            {text}
                        </p>
                    </div>
                )
            }, {
                title: '操作',
                dataIndex: 'action',
                key: 'action',
                render: (text, record) => (
                    <div>
                        <Opton
                            onClick={this.editDrawer.bind(this, record.approveApplyId, record.approveType, record.approveStatus)}
                            style={{ color: '#0F71FF', fontSize: '14px' }}>
                            查看
                        </Opton>
                    </div>
                ),
            }
        ];

        return (
            <PTable
                style={{ marginTop: 20 }}
                columns={columns}
                url="getApprovalList"
                pageParm={this.state.pageParm}
                forceUpdate={this.state.forceUpdate}
            />
        );
    };

    render() {
        return (
            <Content>
                <div className="examination-list">
                    <label style={{ marginRight: 16 }}>
                        关键字：
                        <Input
                            style={{ width: '214px', marginBottom: '10px' }}
                            placeholder="发起人姓名/审批单号"
                            onChange={this.inputTracknameChange}
                            value={this.state.keyword}
                            maxLength={20}
                        />
                    </label>
                    <label style={{ marginRight: 16 }}>
                        审批状态：
                        <PSelect
                            type="approveStatus"
                            onChange={this.pSelectChange}
                            value={this.state.approveStatus}
                            addOption
                            placeholder="全部"
                        />
                    </label>
                    <label style={{ marginRight: 16 }}>
                        发起日期：
                        <RangePicker
                            style={{
                                width: 214
                            }}
                            showTime={{
                                format: "HH:mm"
                            }}
                            value={[
                                this.state.launchStar === ''
                                    ? null
                                    : moment(this.state.launchStar, dateFormat),
                                this.state.launchEnd === ''
                                    ? null
                                    : moment(this.state.launchEnd, dateFormat)
                            ]}
                            format={dateFormat}
                            onChange={this.onChangeTime}
                        />
                    </label>
                    <Button type="primary" onClick={this.clickSearch} style={{ marginLeft: 17 }}>搜索</Button>
                    <Button onClick={this.clickRest} style={{ marginLeft: 17 }}>重置</Button>
                    {this.renderTable()}
                </div>
                <EditExamination
                    onChange={openEdit => {
                        this.setState({ openEdit });
                    }}
                    visible={this.state.openEdit}
                    approvalId={this.state.approvalId}
                    approveType={this.state.approveType}
                    approveStatus={this.state.editApproveStatus}
                />
            </Content>
        );
    }
}

/************************样式************************/

const Content = style.div`{
    font-size: 14px;
    color: rgba(0,0,0,0.65);
    .searchpanel{
       margin-bottom:16px;
      .post{
        margin:0 8px 0 16px;
      }
    }
    .btns{
      margin-top:16px;
    }
  }`;
const Opton = style.span`{
    font-size: 12px;
    color: #0F71FF;
    cursor:pointer;
    margin-right:8px;
  }`;