import { Select } from 'antd'
import { pageNoSignContractPer } from '../../../services/api';
export function contract() {
  return [
    {
      title: '合同名称',
      dataIndex: 'contractName',
      key: 'contractName',
    },
    {
      title: '有限期',
      key: 'effectStartDate',
      render: (text, record) => {
        return <span>{record.effectStartDate}--{record.effectEndDate}</span>;
      }
    },
    {
      title: '合同类型',
      dataIndex: 'contractType',
      key: 'contractType',
    },
    {
      title: '合同电子版',
      key: 'name',
      render: (text, record) => {
        return (
          <a
            style={{ marginLeft: 15 }}
            href={this.state.info.contractUrl}
            target="_blank"
            download
          >
            下载
          </a>
        );
      }
    },
  ]
}

export function infoReview() {
  return [
    {
      title: '序号',
      dataIndex: 'number',
      key: 'number',
    },
    {
      title: '姓名',
      dataIndex: 'fullName',
      key: 'fullName',
    },
    // {
    //   title: '身份证',
    //   dataIndex: 'identityNumber',
    //   key: 'identityNumber',
    // },
    // {
    //   title: '手机号',
    //   dataIndex: 'name',
    //   key: 'name',
    // },
    // {
    //   title: '现职企业',
    //   dataIndex: 'name',
    //   key: 'name',
    // },
    {
      title: '所学课程名称',
      dataIndex: 'trackName',
      key: 'trackName',
    },
    {
      title: '记录进度',
      key: 'sectionName',
      render: (text, record) => {
        return <span>{record.chapterName}-{record.sectionName}</span>;
      }
    },
    {
      title: '记录时间',
      dataIndex: 'proofDate',
      key: 'proofDate',
    },
    {
      title: '查看',
      dataIndex: 'faceUrl',
      key: 'faceUrl',
      render: (text, record) => {

        return (<a onClick={() => {
          if (text) {
            window.open(text)
          } else {
            notification.warning({
              message: '没有上传照片',
              description: '当前不可查看'
            });
          }
        }}>查看</a>);
      }
    },
    {
      title: '是否合格（默认为合格）',
      key: 'checkStatus',
      render: (text, record) => {
        return (
          <Select onChange={this.handleProofListQualified.bind(this, record)} defaultValue="1" style={{ width: 80 }}>
            <Select.Option value="1">合格</Select.Option>
            <Select.Option value="2">不合格</Select.Option>
          </Select>
        );
      }
    },
  ]
}

export function internReview() {
  return [
    {
      title: '实习日期',
      dataIndex: 'internDate',
      key: 'internDate',
    },
    {
      title: '实习单位',
      dataIndex: 'learnName',
      key: 'learnName',
    },
    {
      title: '上班打卡时间',
      dataIndex: 'signInDate',
      key: 'signInDate',
    },
    {
      title: '下班打卡时间',
      dataIndex: 'signOutDate',
      key: 'signOutDate',
    },
    {
      title: '时长',
      dataIndex: 'internMinute',
      key: 'internMinute',
    },
    {
      title: '负责人',
      dataIndex: 'chargeName',
      key: 'chargeName',
    },
    {
      title: '负责人身份证号',
      key: 'chargeIdCardNo',
      dataIndex: 'chargeIdCardNo'
    },
    {
      title: '穿戴保安照片',
      dataIndex: 'wearUrl',
      key: 'wearUrl',
      render: (text, record) => {
        let value = ""
        if (text) {
          value = "查看"
        }
        return (<a onClick={() => {
          window.open(text)
        }}>{value}</a>);
      }
    },
    {
      title: '实习地点照片',
      dataIndex: 'internAddressUrl',
      key: 'internAddressUrl',
      render: (text, record) => {
        let value = ""
        if (text) {
          value = "查看"
        }
        return (<a onClick={() => {
          window.open(text)
        }}>{value}</a>);
      }
    },
    {
      title: '实习过程照片',
      dataIndex: 'internProcessUrl',
      key: 'internProcessUrl',
      render: (text, record) => {
        let value = ""
        if (text) {
          value = "查看"
        }
        return (<a onClick={() => {
          window.open(text)
        }}>{value}</a>);
      }
    },
    {
      title: '实习过程视频',
      dataIndex: 'internProcessVideo',
      key: 'internProcessVideo',
      render: (text, record) => {
        let value = ""
        if (text) {
          value = "查看"
        }
        return (<a onClick={() => {
          window.open(text)
        }}>{value}</a>);
      }
    },
    {
      title: '是否合格（默认为合格）',
      key: 'InternQualifiedStatus',
      render: (text, record) => {
        let { internList, personInternLineId } = this.state
        let internStatus = "1"
        internList.forEach(item => {
          if (item.personInternLineId === record.personInternLineId) {
            internStatus = item.checkStatus
          }
        })
        return (
          <Select onChange={this.handleInternQualified.bind(this, record)} value={internStatus} style={{ width: 80 }}>
            <Select.Option value="1">合格</Select.Option>
            <Select.Option value="2">不合格</Select.Option>
          </Select>
        );
      }
    },
    {
      title: '不合格原因',
      key: 'edit',
      editable: true,
      render: (text, record) => {
        let { internList, personInternLineId } = this.state
        let internContent = ""
        internList.forEach(item => {
          if (item.personInternLineId === record.personInternLineId) {
            internContent = item.internContent
          }
        })
        return (
          <p style={{ cursor: "pointer" }} onClick={this.editInternContent.bind(this, internContent, record)}>{internContent}</p>
        );
      }
    },

    {

    }
  ]
}

export function infoReviewDetail() {
  return [
    // {
    //   title: '序号',
    //   dataIndex: 'name',
    //   key: 'name',
    // },
    {
      title: '姓名',
      dataIndex: 'fullName',
      key: 'fullName',
    },
    {
      title: '所学课程名称',
      dataIndex: 'trackName',
      key: 'trackName',
    },
    {
      title: '记录进度',
      key: 'sectionName',
      render: (text, record) => {
        return <span>{record.chapterName}-{record.sectionName}</span>;
      }
    },
    {
      title: '记录时间',
      dataIndex: 'proofDate',
      key: 'proofDate',
    },
    {
      title: '查看',
      dataIndex: 'faceUrl',
      key: 'faceUrl',
      render: (text, record) => {
        let value = ""
        if (text) {
          value = "查看"
        }
        return (<a onClick={() => {
          window.open(text)
        }}>{value}</a>);
      }
    },
  ]
}

export function internReviewDetail() {
  return [
    {
      title: '实习日期',
      dataIndex: 'internDate',
      key: 'internDate',
    },
    {
      title: '实习单位',
      dataIndex: 'learnName',
      key: 'learnName',
    },
    {
      title: '上班打卡时间',
      dataIndex: 'signInDate',
      key: 'signInDate',
    },
    {
      title: '下班打卡时间',
      dataIndex: 'signOutDate',
      key: 'signOutDate',
    },
    {
      title: '时长',
      dataIndex: 'internMinute',
      key: 'internMinute',
    },
    {
      title: '负责人',
      dataIndex: 'chargeName',
      key: 'chargeName',
    },
    {
      title: '负责人身份证号',
      key: 'chargeIdCardNo',
      dataIndex: 'chargeIdCardNo'
    },
    {
      title: '穿戴保安照片',
      dataIndex: 'wearUrl',
      key: 'wearUrl',
      render: (text, record) => {
        let value = ""
        if (text) {
          value = "查看"
        }
        return (<a onClick={() => {
          window.open(text)
        }}>{value}</a>);
      }
    },
    {
      title: '实习地点照片',
      dataIndex: 'internAddressUrl',
      key: 'internAddressUrl',
      render: (text, record) => {
        let value = ""
        if (text) {
          value = "查看"
        }
        return (<a onClick={() => {
          window.open(text)
        }}>{value}</a>);
      }
    },
    {
      title: '实习过程照片',
      dataIndex: 'internProcessUrl',
      key: 'internProcessUrl',
      render: (text, record) => {
        let value = ""
        if (text) {
          value = "查看"
        }
        return (<a onClick={() => {
          window.open(text)
        }}>{value}</a>);
      }
    },
    {
      title: '实习过程视频',
      dataIndex: 'internProcessVideo',
      key: 'internProcessVideo',
      render: (text, record) => {
        let value = ""
        if (text) {
          value = "查看"
        }
        return (<a onClick={() => {
          window.open(text)
        }}>{value}</a>);
      }
    }
  ]
}