 
// import { Input } from 'antd';
import { trainGradeApplyCancel, trainGradeApplyAppeal } from '../../../../services/bkt/apis';
import $pModal from '../../../../utils/modal/pModal';
import $nModal from '../../../../utils/modal/nModal';
import $modal from '../../../../utils/modal';
const warnColor = '#F59A23';
const okColor = '#4B7902';
const errColor = '#D9001B';
export default function () {

  return [
    {
      title: '序号',
      dataIndex: 'number',
      key: 'number',
      width: 60,
      fixed: 'left'
    },
    {
      title: '姓名',
      dataIndex: 'fullName',
      key: 'fullName',
      width: 100,
      fixed: 'left',
      render: value => value || '-',
    },
    {
      title: '身份证号',
      dataIndex: 'identityNumber',
      key: 'identityNumber',
      // render: text => text.replace(/(\d{4}).*(\d{3})/,'$1***********$2')
    },
    {
      title: '手机号码',
      dataIndex: 'mobile',
      key: 'mobile',
      // render: text => text.replace(/(\d{3})\d{4}(\d{4})/,'$1****$2')
    },
    {
      title: '报名公司名称',
      dataIndex: 'learnName',
      key: 'learnName',
    },
    {
      title: '所属培训机构',
      dataIndex: 'organName',
      key: 'organName',
    },
    {
      title: '报名时间',
      dataIndex: 'applyDate',
      key: 'applyDate',
      render: value => value || '-'
    },
    {
      title: '申报状态',
      dataIndex: 'applyStatus',
      key: 'applyStatus',
      render: (value) => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == 0:
            text = '申报中';
            color = warnColor;
            break;
          case value == 1:
            text = '申报通过';
            color = okColor;
            break;
          case value == 2:
            text = '申报不通过';
            color = errColor;
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    // {
    //   title: '理论学习进度',
    //   dataIndex: 'progress',
    //   key: 'progress',
    //   render: value => value ? `${value}%` : '-'
    // },
    // {
    //   title: '审核状态',
    //   dataIndex: 'examArrange',
    //   key: 'examArrange',
    //   render: (value) => {
    //     let text = '-';
    //     let color = '';
    //     switch (true) {
    //       case value == '0':
    //         text = '带审核';
    //         break;
    //       case value == '1':
    //         color = okColor;
    //         text = '已安排';
    //     }
    //     return (
    //       <span>{text}</span>
    //     );
    //   }
    // },
    {
      title: '操作',
      dataIndex: 'operation',
      key: 'operation',
      width: 130,
      fixed: 'right',
      render: (text, record) => {
        const { personApplyId, materialApproveStatus } = record;
        return (
          <div>
            <span
              style={{
                color: '#108EE9',
                cursor: 'pointer',
                marginRight: '20px'
              }}
              onClick={() => {
                this.props.history.push({pathname:"/spotCheck/gradeReview",query:{personApplyId:record.personApplyId,type:"ready"}})
              }}
            >
              {/* {materialApproveStatus == '0' ? '核对处理' : '查看'} */}
              审查
              {/* 查看 */}
            </span>
          </div>
        );

      }
    }
  ];
}