import React, { Component } from "react";
import { connect } from "dva";

import { Link } from 'dva/router';
import { gup } from '../../../utils/utils';
import {
  Alert,
  Form,
  Row,
  Col,
  Input,
  Table,
  message,
  Button,
  Modal,
  Checkbox,
  Upload,
  Icon,
  Tabs,
  Breadcrumb,
  Radio,
  Divider
} from "antd";
import { formItemLayout, formLayout, formLayout1, formLayoutTable } from './formLayout';
import PSelect from '../../../components/Pro/PSelect';
import PFromUpload from '../../../components/Pro/PFromUpload';
import declare from '../../../utils/hoc/declare';
import ImageFormItem from './imageFormItem';
import { contract, infoReview } from "./columns";
import { qualify_applyInfo, qualify_selectProofList, qualify_fyApplyInfoCheck } from "../../../services/bkt/qualify"
import { getBayBaseInfo } from "../../../services/api"
const { TabPane } = Tabs;
@connect(state => ({
  profile: state.profile
}))
@Form.create()
@declare
export default class CertificateMessage extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      tab: '1',
      contractColumns: [],  //合同信息
      infoReviewColumns: [], //学习记录
      checkStatus: 1,
      checkContent: "", //不合格原因
      info: {},
      selectProofList: [],
      personApplyId: this.props.history.location.query ? `${this.props.history.location.query.personApplyId}` : "",
      checkPerName: ""
    };
  }

  componentWillMount() {
    this.__getDetailInfo(this.state.personApplyId)
    this.__getSelectProofList(this.state.personApplyId)
    this._getUserInfo()
    const tab = gup('tab');
    if (tab) {
      this.setState({
        tab
      });
    }
  }
  componentDidMount() {
    const contractColumns = contract.call(this);
    const infoReviewColumns = infoReview.call(this);
    this.setState({
      contractColumns,
      infoReviewColumns
    });

  }
  // 获取操作人信息
  _getUserInfo = () => {
    getBayBaseInfo().then(res => {
      console.log(res)
      this.setState({
        checkPerName: res.data.name
      });
    })
  }
  //是否合格
  checkQualified = (e) => {
    if (e.target.value === 1) {
      this.setState({
        checkStatus: 1,
        checkContent: ""
      });
    } else {
      this.setState({
        checkStatus: 2
      });
    }
  }
  //学习记录是否合格
  handleProofListQualified = (record, e) => {
    const { selectProofList } = this.state
    selectProofList.forEach(item => {
      if (item.trackUserProofId === record.trackUserProofId) {
        item.checkStatus = e;
      }
    })
    this.setState({
      selectProofList
    })
  }
  //不合格理由
  handleCheckContent = (e) => {
    this.setState({
      checkContent: e.target.value
    });
  }
  //获取详情
  __getDetailInfo = (personApplyId) => {
    qualify_applyInfo({ data: { personApplyId } }).then(res => {
      this.setState({
        info: res.data
      });
    });
  }
  //获取学习记录
  __getSelectProofList = (personApplyId) => {
    qualify_selectProofList({ data: { personApplyId } }).then(res => {
      res.data.forEach((item, index) => {
        item.checkStatus = 1;
        item.number = index + 1;
      })
      this.setState({
        selectProofList: res.data
      })
    });
  }
  //提交
  __submit = () => {
    const { isQualified, checkContent, personApplyId, info, checkPerName, selectProofList, checkStatus } = this.state
    if (checkStatus === 2 && !checkContent) {
      message.error("请填写不合格原因");
      return;
    }
    //学习记录的数据
    let data = selectProofList.map(item => {
      return {
        personApplyId,
        checkPerName,
        objectId: item.trackUserProofId,
        checkItem: 2,
        productTypeCode: 1,
        checkStatus: item.checkStatus,
        checkContent: ""
      }
    })
    //基本信息数据
    let data1 = {
      personApplyId,
      checkPerName,
      checkItem: 1,
      productTypeCode: 1,
      objectId: personApplyId,
      checkStatus: checkStatus,
      checkContent: checkContent
    }
    data.push(data1)
    qualify_fyApplyInfoCheck({ data }).then(res => {
      this.props.history.push("/spotCheck/certificateRecord")
    });
  }

  render() {
    const { getFieldDecorator } = this.props.form;
    const { state } = this
    const { info, selectProofList, personApplyId } = this.state
    const contractDataSource = []
    if (info.contractName) {
      contractDataSource.push(info)
    }

    return (
      <div style={{ paddingTop: '10px' }}>
        <Breadcrumb style={{ margin: '16px 0 8px 24px' }}>
          <Breadcrumb.Item>
            <Link to="/spotCheck/certificateMessage">保安员资格证考培信息抽查记录</Link>
          </Breadcrumb.Item>
          <Breadcrumb.Item>信息审查</Breadcrumb.Item>
        </Breadcrumb>
        {/* <Tabs
          tabBarStyle={{ marginLeft: 24, marginRight: 24 }}
          defaultActiveKey={this.state.tab}
        >
          <TabPane forceRender
            tab={`保安员资格证考培信息抽查记录`}
            key="1"
          > */}
        <Form style={{ paddingRight: 15 }}>
          <div className="basic_container">
            {
              info.checkFailContent ?
                <>
                  <Divider style={{ paddingLeft: "15px" }} orientation="left">
                    <h3 style={{ fontWeight: 800, fontSize: "20px" }}>历史审核意见</h3>
                  </Divider>
                  <Row gutter={16}>
                    <Col span={21}>
                      <div style={{ marginLeft: "82px", fontSize: "16px", marginBottom: "30px", color: "red" }}>
                        {
                          info.checkFailContent ?
                            info.checkFailContent.map(item => {
                              return (
                                <div style={{ display: "flex" }}>
                                  <p style={{ whiteSpace: "nowrap", marginRight: "5px" }}>{item.date} | </p>
                                  <p>{item.content}</p>
                                </div>
                              )
                            }) : ""
                        }
                      </div>
                    </Col>
                  </Row>
                </> : ""
            }
            <Divider style={{ paddingLeft: "15px" }} orientation="left">
              <h3 style={{ fontWeight: 800, fontSize: "20px" }}>人员基本信息</h3>
            </Divider>
            <Row gutter={16}>
              <Col span={7}>
                <Form.Item {...formItemLayout} label="姓名">
                  {getFieldDecorator('fullname', {
                    initialValue: info.fullname
                  })(< Input placeholder="" maxLength={30} disabled={true} />
                  )}
                </Form.Item>
              </Col>
              <Col span={7} >
                <Form.Item {...formItemLayout} label="出生年月">
                  {getFieldDecorator('birthDate', {
                    initialValue: info.birthDate
                  })(< Input placeholder="" maxLength={30} disabled={true} />
                  )}
                </Form.Item>
              </Col>
              <Col span={7} >
                <Form.Item {...formItemLayout} label="性别">
                  {getFieldDecorator('sex', {
                    initialValue: info.sex == 1 ? "男" : "女"
                  })(< Input placeholder="" maxLength={30} disabled={true} />
                  )}
                </Form.Item>
              </Col>
            </Row>
            <Row gutter={16}>
              <Col span={7}>
                <Form.Item style={{ marginLeft: "150px" }}>
                {info.faceCheckType == 1 ?
                    <img style={{width:'104px',height: '104px'}} src={require('../../../assets/images/person-photo.jpg')} alt=""/>:
                    getFieldDecorator("avatar", {
                      initialValue: info.avatar
                    })(
                      <PFromUpload
                        disabled={true}
                        size={1}
                        disabled
                      />
                    )
                  }
                </Form.Item>
              </Col>
              <Col span={7} >
                <Form.Item style={{ marginTop: "32px" }} {...formItemLayout} label="民族">
                  {getFieldDecorator('nation', {
                    initialValue: info.nation
                  })(<PSelect disabled type="nation" />)}
                </Form.Item>
              </Col>
              <Col span={7} >
                <Form.Item style={{ marginTop: "32px" }} {...formItemLayout} label="文化程度">
                  {getFieldDecorator('education', {
                    initialValue: info.education
                  })(<PSelect disabled type="education" />)}
                </Form.Item>
              </Col>
            </Row>
            <Row gutter={16}>
              <Col span={7}>
                <Form.Item {...formItemLayout} label="身份证号码">
                  {getFieldDecorator('identitynumber', {
                    initialValue: info.identitynumber
                  })(<Input placeholder="" maxLength={30} disabled={true} />)}
                </Form.Item>
              </Col>
              <Col span={7} >
                <Form.Item {...formItemLayout} label="手机号码">
                  {getFieldDecorator('mobile', {
                    initialValue: info.mobile
                  })(<Input placeholder="" maxLength={30} disabled={true} />)}
                </Form.Item>
              </Col>
              <Col span={7} >
                <Form.Item {...formItemLayout} label="所属公司">
                  {getFieldDecorator('learnName', {
                    initialValue: info.learnName
                  })(<Input placeholder="" maxLength={30} disabled={true} />)}
                </Form.Item>
              </Col>
            </Row>
            <Row gutter={16}>
              <Col span={7}>
                <Form.Item {...formItemLayout} label="户籍类型">
                  {getFieldDecorator('residentType', {
                    initialValue: info.residentType
                  })(<PSelect disabled style={{ width: '100%' }} type="residentType" />)}
                </Form.Item>
              </Col>
              <Col span={7} >
                <Form.Item {...formItemLayout} label="户籍所在地类型">
                  {getFieldDecorator('residentPlaceType', {
                    initialValue: info.residentPlaceType
                  })(<PSelect disabled style={{ width: '100%' }} type="residentPlaceType" />)}
                </Form.Item>
              </Col>
            </Row>
            <Form.Item {...formLayoutTable} label="合同信息" style={{ marginLeft: "50px" }}>
              <Table
                dataSource={contractDataSource} footer={null} columns={state.contractColumns}
                pagination={false}
              />
            </Form.Item>
            <Row gutter={16}>
              <Col span={10}>
                <Form.Item label="身份证正反面" {...formItemLayout} extra={<span style={{ color: 'orange' }}>
                  人像面
                    </span>} >
                  {info.idCardNoFrontUrl ?
                    getFieldDecorator("idCardNoFrontUrl", {
                      initialValue: info.idCardNoFrontUrl
                    })(
                      <PFromUpload
                        disabled={true}
                        size={1}
                        disabled
                      />
                    ) : <div style={{ width: "104px", height: "104px", border: "1px dashed #ccc", paddingTop: "30px", textAlign: "center" }}>暂无</div>
                  }

                </Form.Item>
              </Col>
              <Col span={2}>
                <Form.Item extra={<span style={{ color: 'orange' }}>
                  国徽面
                    </span>} >
                  {info.idCardNoBackUrl ?
                    getFieldDecorator("idCardNoBackUrl", {
                      initialValue: info.idCardNoBackUrl
                    })(
                      <PFromUpload
                        disabled={true}
                        size={1}
                        disabled
                      />
                    ) : <div style={{ width: "104px", height: "104px", border: "1px dashed #ccc", paddingTop: "30px", textAlign: "center" }}>暂无</div>
                  }
                </Form.Item>
              </Col>
            </Row>
            <Divider style={{ paddingLeft: "15px" }} orientation="left">
              <h3 style={{ fontWeight: 800, fontSize: "20px" }}>人员基本信息审核意见</h3>
            </Divider>
            <Row gutter={16}>
              <Col span={12} >
                <Form.Item {...formItemLayout} label="学员基本信息是否合格">
                  <Radio.Group value={state.checkStatus} onChange={this.checkQualified}>
                    <Radio value={1}>合格</Radio>
                    <Radio value={2}>不合格</Radio>
                  </Radio.Group>
                </Form.Item>
              </Col>
            </Row>
            {
              state.checkStatus === 1 ?
                "" :
                <Row gutter={16}>
                  <Col span={8} >
                    <Form.Item {...formItemLayout} required={true} label="不合格原因">
                      <Input.TextArea onChange={this.handleCheckContent} value={state.checkContent} placeholder="输入不合格原因：如劳动合同不合格" rows={4} />
                    </Form.Item>
                  </Col>
                </Row>
            }
            <Divider style={{ paddingLeft: "15px" }} orientation="left">
              <h3 style={{ fontWeight: 800, fontSize: "20px" }}>学习过程采集照片信息审核</h3>
            </Divider>

            <Form.Item {...formLayoutTable} label="">
              <Table style={{ marginLeft: "100px" }}
                dataSource={selectProofList} footer={null} columns={state.infoReviewColumns}
                pagination={false}
              />
            </Form.Item>
            <Row gutter={16}>
              <Col span={20}>
                <div className="sumbitButtom" style={{ textAlign: 'center' }}>
                  <Button style={{ margin: '0 20px' }}
                    onClick={() => {
                      this.props.history.push("/spotCheck/certificateMessage");
                    }}
                  >
                    取消
                      </Button>
                  <Button type="primary" style={{ margin: '0 20px' }}
                    onClick={this.__submit} disabled={state.personApplyId ? false : true}
                  >
                    提交
                      </Button>
                </div>
              </Col>
            </Row>
          </div>
        </Form>

        {/* </TabPane>
        </Tabs> */}
      </div>
    );
  }
}