import React, { Component } from "react";
import { connect } from "dva";

import { Link } from 'dva/router';
import { gup } from '../../../utils/utils';
import {
  Alert,
  Form,
  Row,
  Col,
  Input,
  Table,
  message,
  Button,
  Modal,
  Checkbox,
  Upload,
  Icon,
  Tabs,
  Breadcrumb,
  Radio,
  Divider
} from "antd";
import { formItemLayout, formLayout, formLayout1, formLayoutTable } from './formLayout';
import PSelect from '../../../components/Pro/PSelect';
import PFromUpload from '../../../components/Pro/PFromUpload';
import declare from '../../../utils/hoc/declare';
import ImageFormItem from './imageFormItem';
import { contract, infoReviewDetail } from "./columns";
import { qualify_applyInfo, qualify_selectProofList, qualify_fyApplyInfoCheck } from "../../../services/bkt/qualify"
import { getBayBaseInfo } from "../../../services/api"
const { TabPane } = Tabs;
@connect(state => ({
  profile: state.profile
}))
@Form.create()
@declare
export default class CertificateMessage extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      tab: '1',
      contractColumns: [],  //合同信息
      infoReviewColumns: [], //学习记录
      checkStatus: 1,
      checkContent: "", //不合格原因
      info: {},
      selectProofList: [],
      personApplyId: this.props.history.location.query ? `${this.props.history.location.query.personApplyId}` : "",
      checkPerName: ""
    };
  }

  componentWillMount() {
    this.__getDetailInfo(this.state.personApplyId)
    this.__getSelectProofList(this.state.personApplyId)
    const tab = gup('tab');
    if (tab) {
      this.setState({
        tab
      });
    }
  }
  componentDidMount() {
    const contractColumns = contract.call(this);
    const infoReviewColumns = infoReviewDetail.call(this);
    this.setState({
      contractColumns,
      infoReviewColumns
    });

  }
  //获取详情
  __getDetailInfo = (personApplyId) => {
    qualify_applyInfo({ data: { personApplyId } }).then(res => {
      this.setState({
        info: res.data
      });
    });
  }
  //获取学习记录
  __getSelectProofList = (personApplyId) => {
    qualify_selectProofList({ data: { personApplyId } }).then(res => {
      res.data.forEach((item, index) => {
        item.number = index + 1;
      })
      this.setState({
        selectProofList: res.data
      })
    });
  }


  render() {
    const { getFieldDecorator } = this.props.form;
    const { state } = this
    const { info, selectProofList, personApplyId } = this.state
    const contractDataSource = []
    if (info.contractName) {
      contractDataSource.push(info)
    }
    let a = [
      {
        date: "2020-12-28 14:14:10",
        content: "基本信息：不合格基本信息;学习记录：第一章 保安概述-防卫技能第8讲不合格"
      },
      {
        date: "2020-12-28 14:14:10",
        content: "基本信息：不合格基本信息;学习记录：第一章 保安概述-防卫技能第8讲不合格"
      }
    ]
    return (
      <div style={{ paddingTop: '10px' }}>
        <Breadcrumb style={{ margin: '16px 0 8px 24px' }}>
          <Breadcrumb.Item>
            <Link to="/spotCheck/certificateRecord">保安员资格证考培信息抽查记录</Link>
          </Breadcrumb.Item>
          <Breadcrumb.Item>审查详情</Breadcrumb.Item>
        </Breadcrumb>
        <Form style={{ paddingRight: 15 }}>
          <div className="basic_container">
            <Divider style={{ paddingLeft: "15px" }} orientation="left">
              <h3 style={{ fontWeight: 800, fontSize: "20px" }}>历史审核意见</h3>
            </Divider>
            <Row gutter={16}>
              <Col span={21}>
                <div style={{ marginLeft: "82px", fontSize: "16px", marginBottom: "30px", color: "red" }}>
                  {
                    info.checkFailContent ?
                      info.checkFailContent.map(item => {
                        return (
                          <div style={{ display: "flex" }}>
                            <p style={{ whiteSpace: "nowrap", marginRight: "5px" }}>{item.date} | </p>
                            <p>{item.content}</p>
                          </div>
                        )
                      }) : ""
                  }
                </div>
              </Col>
            </Row>
            <Divider style={{ paddingLeft: "15px" }} orientation="left">
              <h3 style={{ fontWeight: 800, fontSize: "20px" }}>人员基本信息</h3>
            </Divider>
            <Row gutter={16}>
              <Col span={7}>
                <Form.Item {...formItemLayout} label="姓名">
                  {getFieldDecorator('fullname', {
                    initialValue: info.fullname
                  })(< Input placeholder="" maxLength={30} disabled={true} />
                  )}
                </Form.Item>
              </Col>
              <Col span={7} >
                <Form.Item {...formItemLayout} label="出生年月">
                  {getFieldDecorator('birthDate', {
                    initialValue: info.birthDate
                  })(< Input placeholder="" maxLength={30} disabled={true} />
                  )}
                </Form.Item>
              </Col>
              <Col span={7} >
                <Form.Item {...formItemLayout} label="性别">
                  {getFieldDecorator('sex', {
                    initialValue: info.sex == 1 ? "男" : "女"
                  })(< Input placeholder="" maxLength={30} disabled={true} />
                  )}
                </Form.Item>
              </Col>
            </Row>
            <Row gutter={16}>
              <Col span={7}>
                <Form.Item style={{ marginLeft: "150px" }}>
                  {info.faceCheckType == 1 ?
                    <img style={{width:'104px',height: '104px'}} src={require('../../../assets/images/person-photo.jpg')} alt=""/>:
                    getFieldDecorator("avatar", {
                      initialValue: info.avatar
                    })(
                      <PFromUpload
                        disabled={true}
                        size={1}
                        disabled
                      />
                    )
                  }
                </Form.Item>
              </Col>
              <Col span={7} >
                <Form.Item style={{ marginTop: "32px" }} {...formItemLayout} label="民族">
                  {getFieldDecorator('nation', {
                    initialValue: info.nation
                  })(<PSelect disabled type="nation" />)}
                </Form.Item>
              </Col>
              <Col span={7} >
                <Form.Item style={{ marginTop: "32px" }} {...formItemLayout} label="文化程度">
                  {getFieldDecorator('education', {
                    initialValue: info.education
                  })(<PSelect disabled type="education" />)}
                </Form.Item>
              </Col>
            </Row>
            <Row gutter={16}>
              <Col span={7}>
                <Form.Item {...formItemLayout} label="身份证号码">
                  {getFieldDecorator('identitynumber', {
                    initialValue: info.identitynumber
                  })(<Input placeholder="" maxLength={30} disabled={true} />)}
                </Form.Item>
              </Col>
              <Col span={7} >
                <Form.Item {...formItemLayout} label="手机号码">
                  {getFieldDecorator('mobile', {
                    initialValue: info.mobile
                  })(<Input placeholder="" maxLength={30} disabled={true} />)}
                </Form.Item>
              </Col>
              <Col span={7} >
                <Form.Item {...formItemLayout} label="所属公司">
                  {getFieldDecorator('learnName', {
                    initialValue: info.learnName
                  })(<Input placeholder="" maxLength={30} disabled={true} />)}
                </Form.Item>
              </Col>
            </Row>
            <Row gutter={16}>
              <Col span={7}>
                <Form.Item {...formItemLayout} label="户籍类型">
                  {getFieldDecorator('residentType', {
                    initialValue: info.residentType
                  })(<PSelect disabled style={{ width: '100%' }} type="residentType" />)}
                </Form.Item>
              </Col>
              <Col span={7} >
                <Form.Item {...formItemLayout} label="户籍所在地类型">
                  {getFieldDecorator('residentPlaceType', {
                    initialValue: info.residentPlaceType
                  })(<PSelect disabled style={{ width: '100%' }} type="residentPlaceType" />)}
                </Form.Item>
              </Col>
            </Row>
            <Form.Item {...formLayoutTable} label="合同信息" style={{ marginLeft: "50px" }}>
              <Table
                dataSource={contractDataSource} footer={null} columns={state.contractColumns}
                pagination={false}
              />
            </Form.Item>
            <Row gutter={16}>
              <Col span={10}>
                <Form.Item label="身份证正反面" {...formItemLayout} extra={<span style={{ color: 'orange' }}>
                  人像面
                    </span>} >
                  {info.idCardNoFrontUrl ?
                    getFieldDecorator("idCardNoFrontUrl", {
                      initialValue: info.idCardNoFrontUrl
                    })(
                      <PFromUpload
                        disabled={true}
                        size={1}
                        disabled
                      />
                    ) : <div style={{ width: "104px", height: "104px", border: "1px dashed #ccc", paddingTop: "30px", textAlign: "center" }}>暂无</div>
                  }
                </Form.Item>
              </Col>
              <Col span={2}>
                <Form.Item extra={<span style={{ color: 'orange' }}>
                  国徽面
                    </span>} >
                  {info.idCardNoBackUrl ?
                    getFieldDecorator("idCardNoBackUrl", {
                      initialValue: info.idCardNoBackUrl
                    })(
                      <PFromUpload
                        disabled={true}
                        size={1}
                        disabled
                      />
                    ) : <div style={{ width: "104px", height: "104px", border: "1px dashed #ccc", paddingTop: "30px", textAlign: "center" }}>暂无</div>
                  }
                </Form.Item>
              </Col>
            </Row>
            <Divider style={{ paddingLeft: "15px" }} orientation="left">
              <h3 style={{ fontWeight: 800, fontSize: "20px" }}>学习过程采集照片信息审核</h3>
            </Divider>
            <Form.Item {...formLayoutTable} label="">
              <Table style={{ marginLeft: "100px" }}
                dataSource={selectProofList} footer={null} columns={state.infoReviewColumns}
                pagination={false}
              />
            </Form.Item>
          </div>
        </Form>

        {/* </TabPane>
        </Tabs> */}
      </div>
    );
  }
}
