import { Select } from 'antd'
import { pageNoSignContractPer,publicCommonFileFilePreview } from '../../../services/api';
export function contract() {
  return [
    {
      title: '合同名称',
      dataIndex: 'contractName',
      key: 'contractName',
    },
    {
      title: '有限期',
      key: 'effectStartDate',
      render: (text, record) => {
        return <span>{record.effectStartDate}--{record.effectEndDate}</span>;
      }
    },
    {
      title: '合同类型',
      dataIndex: 'contractType',
      key: 'contractType',
    },
    {
      title: '合同电子版',
      key: 'name',
      render: (text, record) => {
        return (
          <a
            style={{ marginLeft: 15 }}
            onClick={() => {
              if(this.state.info.contractUrl) {
                publicCommonFileFilePreview({
                  url: this.state.info.contractUrl,
                  isLoad: '1'
                })
                .then(data => {
                  if (data.data) {
                    window.open(data.data);
                  }
                });
              }else {
                notification.warning({
                  message: '该合同未上传附件！',
                  description: '请先上传合同文件，方可查看。'
                });
              }
            }}
          >
            预览
          </a>
        );
      }
    },
  ]
}

export function infoReview() {
  return [
    {
      title: '序号',
      dataIndex: 'number',
      key: 'number',
    },
    {
      title: '姓名',
      dataIndex: 'fullName',
      key: 'fullName',
    },
    // {
    //   title: '身份证',
    //   dataIndex: 'identityNumber',
    //   key: 'identityNumber',
    // },
    // {
    //   title: '手机号',
    //   dataIndex: 'name',
    //   key: 'name',
    // },
    // {
    //   title: '现职企业',
    //   dataIndex: 'name',
    //   key: 'name',
    // },
    {
      title: '所学课程名称',
      dataIndex: 'trackName',
      key: 'trackName',
    },
    {
      title: '记录进度',
      key: 'sectionName',
      render: (text, record) => {
        return <span>{record.chapterName}-{record.sectionName}</span>;
      }
    },
    {
      title: '记录时间',
      dataIndex: 'proofDate',
      key: 'proofDate',
    },
    {
      title: '自拍照片',
      dataIndex: 'faceUrl',
      key: 'faceUrl',
      render: (text, record) => {
        let value = "";
        if(text){
          value = "查看";
        }
        return (<a onClick={() => {
          window.open(text)
        }}>{value}</a>);
      }
    },
    {
      title: '是否合格（默认为合格）',
      key: 'checkStatus',
      render: (text, record) => {
        return (
          <Select onChange={this.handleProofListQualified.bind(this, record)} defaultValue="1" style={{ width: 80 }}>
            <Select.Option value="1">合格</Select.Option>
            <Select.Option value="2">不合格</Select.Option>
          </Select>
        );
      }
    },
  ]
}

export function infoReviewDetail() {
  return [
    {
      title: '序号',
      dataIndex: 'number',
      key: 'number',
    },
    {
      title: '姓名',
      dataIndex: 'fullName',
      key: 'fullName',
    },
    {
      title: '所学课程名称',
      dataIndex: 'trackName',
      key: 'trackName',
    },
    {
      title: '记录进度',
      key: 'sectionName',
      render: (text, record) => {
        return <span>{record.chapterName}-{record.sectionName}</span>;
      }
    },
    {
      title: '记录时间',
      dataIndex: 'proofDate',
      key: 'proofDate',
    },
    {
      title: '自拍照片',
      dataIndex: 'faceUrl',
      key: 'faceUrl',
      render: (text, record) => {
        let value = ""
        if (text) {
          value = "查看"
        }
        return (<a onClick={() => {
          window.open(text)
        }}>{value}</a>);
      }
    }
  ]
}