
import { Popover } from 'antd';
import { trainGradeApplyCancel, trainGradeApplyAppeal } from '../../../../services/bkt/apis';
import $pModal from '../../../../utils/modal/pModal';
import $nModal from '../../../../utils/modal/nModal';
import $modal from '../../../../utils/modal';

const warnColor = '#F59A23';
const okColor = '#4B7902';
const errColor = '#D9001B';
export default function () {

  return [
    {
      title: '序号',
      dataIndex: 'number',
      key: 'number',
      width: 60,
      fixed: 'left'
    },
    {
      title: '抽查人员',
      dataIndex: 'checkPerName',
      key: 'checkPerName',
      fixed: 'left',
      // render: value => value || '-',
    },
    {
      title: '抽查时间',
      dataIndex: 'checkDate',
      key: 'checkDate',
      // render: text => text.replace(/(\d{4}).*(\d{3})/,'$1***********$2')
    },
    {
      title: '抽查对象',
      dataIndex: "fullName",
      key: 'fullName',
    },
    {
      title: '手机号码',
      dataIndex: 'mobile',
      key: 'mobile',
      // render: text => text.replace(/(\d{3})\d{4}(\d{4})/,'$1****$2')
    },
    {
      title: '抽查对象身份证',
      dataIndex: "identityNumber",
      key: 'identityNumber',
    },
    {
      title: '报名公司名称',
      dataIndex: 'learnName',
      key: 'learnName',
    },
    {
      title: '所属培训机构',
      dataIndex: 'organName',
      key: 'organName',
    },
    {
      title: '最终审核结果',
      dataIndex: 'checkStatus',
      key: 'checkStatus',
      render: (value) => {
        let text = '-';
        switch (true) {
          case value == '0':
            text = '未抽查';
            break;
          case value == '1':
            text = '抽查合格';
            break;
          case value == '2':
            text = '抽查不合格';
            break;
          case value == '3':
            text = '待复审';
            break;
        }
        return (
          <span>{text}</span>
        );
      }
    },
    {
      title: '操作',
      dataIndex: 'operation',
      key: 'operation',
      width: 80,
      fixed: 'right',
      render: (value, record) => {
        const { checkStatus } = record;
        if(checkStatus==="1" || checkStatus==="2"){
          return (
            <span
              style={{
                color: '#108EE9',
                cursor: 'pointer',
              }}
              onClick={() => {
                this.props.history.push({pathname:"/spotCheck/certificateReview/detail",query:{personApplyId:record.personApplyId}});
              }}
            >
              详情
            </span>
          )
        }else {
          return (
            <span
              style={{
                color: '#108EE9',
                cursor: 'pointer',
              }}
              onClick={() => {
                this.props.history.push({pathname:"/spotCheck/certificateReview",query:{personApplyId:record.personApplyId}});
              }}
            >
              复审
            </span>
          )
        }
      }
    }
  ];
}