import React, { PureComponent } from "react";
// import { connect } from 'dva';
import style from "styled-components";
import {
  Input,
  Button,
  Form,
  Select,
  // DatePicker,
  // InputNumber,
  // Radio,
  // Icon,
  message,
  Drawer
} from "antd";
// import Drawer from 'react-motion-drawer';
// import PSelect from "../../../components/Pro/PSelect";
// import * as api from "../../../services/api";

import {
  enterpriseRoleGroupSave //角色组新增
} from "../../../services/api";
// import { fail } from 'assert';

const FormItem = Form.Item;
const { Option } = Select;

message.config({
  top: 100,
  right: 5,
  duration: 2
});

// @connect(state => ({ profile: state.profile }))
@Form.create()

// 收到的简历备注
export default class NewRoleGroup extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      open: this.props.visiable, //新增角色组
      roleGroupMessage: {
        roleGroupName: ""
      }
    };
  }
  /******************************生命周期******************************/

  componentDidMount = () => {};
  componentWillReceiveProps(props) {
    this.setState({ open: props.visiable });
  }
  /******************************ajax请求******************************/

  /******************************相关事件******************************/

  //表单提交
  handleSaveRoleGroupSubmit = e => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        console.log("values", values);
        const obj = {
          roleGroupName: values.roleGroupName ? values.roleGroupName : "",
          roleGroupId: values.roleGroupId ? values.roleGroupId : ""
        };
        console.log("obj", obj);
        enterpriseRoleGroupSave(obj).then(
          res => {
            console.log("成功信息-保存角色组信息：", res);
            // message.success("角色组创建完成！");
            this.setState({
              open: false
            });
            this.props.refreshList();
            this.props.wedRoleSequence();
          },
          error => {
            message.error(error);
            console.log("错误信息-保存角色组信息：", error);
            this.setState({
              open: false
            });
          }
        );
      }
    });
  };

  /******************************render******************************/

  render() {
    const formItemLayout = {
      labelCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 7
        }
      },
      wrapperCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 12
        },
        md: {
          span: 10
        }
      }
    };
    const { getFieldDecorator } = this.props.form;

    return (
      <Box>
        <Drawer
          // overlayColor="rgba(0, 0, 0,0)"
          placement="right"
          visible={this.state.open}
          title="新增角色组"
          // noTouchClose
          width={600}
          // zIndex={999}
          // className="drawer-box"
          onChange={open => {
            const form = this.props.form;
            if (open === false) {
              form.setFieldsValue({ roleGroupName: "" });
            }
            this.props.onChange(open);
            this.setState({ open });
          }}
          onClose={() => this.setState({ open: false })}
          destroyOnClose
          style={{
            height: "calc(100% - 55px)",
            overflow: "auto",
            paddingBottom: 53
          }}
        >
          <div>
            {/* <div className="drawer-header">新增角色组</div> */}
            <div>
              <Form onSubmit={this.handleSaveRoleGroupSubmit}>
                <FormItem {...formItemLayout} label="角色组名称">
                  {getFieldDecorator("roleGroupName", {
                    rules: [
                      {
                        required: true,
                        message: "角色组名称不能为空"
                      },
                      {
                        pattern: /^[A-Za-z0-9\u4e00-\u9fa5]{1,20}$/,
                        message: "请输入中文，英文，数字!"
                      }
                    ]
                  })(<Input placeholder="请输入角色组名称" maxLength={20} />)}
                </FormItem>
              </Form>
            </div>
            {/* <div className="drawer-footer"> */}
            <div
              style={{
                position: "absolute",
                bottom: 0,
                width: "100%",
                borderTop: "1px solid #e8e8e8",
                padding: "10px 16px",
                textAlign: "right",
                left: 0,
                background: "#fff",
                borderRadius: "0 0 4px 4px"
              }}
            >
              <Button
                style={{
                  marginRight: 8
                }}
                onClick={() => this.setState({ open: false })}
              >
                取消
              </Button>
              <Button
                type="primary"
                htmlType="submit"
                onClick={this.handleSaveRoleGroupSubmit}
              >
                保存角色组
              </Button>
            </div>
          </div>
        </Drawer>
      </Box>
    );
  }
}

/************************样式************************/

const Box = style.div`{
  .drawer-content{
    margin-top:28px;
  }
}`;
