import React, { PureComponent } from "react";
// import { connect } from 'dva';
import style from "styled-components";
import {
  Input,
  Button,
  Form,
  Select,
  // DatePicker,
  // InputNumber,
  // Radio,
  // Icon,
  message,
  Drawer
} from "antd";
// import Drawer from 'react-motion-drawer';
// import PSelect from "../../../components/Pro/PSelect";
// import * as api from "../../../services/api";

import {
  searchRoleGroup, //查询角色组与角色列表功能
  enterpriseRoleSave //角色新增
} from "../../../services/api";

const FormItem = Form.Item;
const { Option } = Select;

message.config({
  top: 100,
  right: 5,
  duration: 2
});

// @connect(state => ({ profile: state.profile }))
@Form.create()

// 收到的简历备注
export default class NewRole extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      open: this.props.visiable, //备注
      roleGroupList: [],
      // roleGroupList: this.props.roleGroupList,
      roleMessage: {
        roleName: "",
        roleGroupId: ""
      }
    };
  }
  /******************************生命周期******************************/

  componentDidMount = () => {
    //  this.getEnterpriseRoleGroupGet();
  };
  componentWillReceiveProps(props) {
    if (props.roleGroupList !== this.state.roleGroupList) {
      this.setState({
        roleGroupList: props.roleGroupList
      });
    }
    this.setState({ open: props.visiable });
    // console.log('props',this.props);
    // this.getEnterpriseRoleGroupGet();
  }

  /******************************ajax请求******************************/

  /******************************相关事件******************************/
  //获得角色组List
  // getEnterpriseRoleGroupGet = () => {
  //   searchRoleGroup().then((data) => {
  //     console.log("getRoleList", data.data);
  //     if (data) {
  //       this.setState({
  //         roleGroupList: data.data,
  //       });
  //     }
  //   });
  // };
  //表单提交
  handleSaveRoleSubmit = e => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        console.log("values", values);
        const obj = {
          roleName: values.roleName ? values.roleName : "",
          roleGroupId: values.roleGroupId ? values.roleGroupId : ""
        };
        console.log("obj", obj);
        enterpriseRoleSave(obj).then(
          res => {
            console.log("成功信息-保存角色信息：", res);
            // message.success("保存成功！");
            this.setState({
              open: false
            });
            this.props.refreshList();
            this.props.wedRoleSequence();
          },
          error => {
            // message.error(error.msg);
            console.log("错误信息-保存角色信息：", error);
          }
        );
      }
    });
  };

  renderRoleGroup = () => {
    // return this.state.roleGroupList.map((val, key) => {
    // return <Option key={key} value={val.roleGroupId + ""}>{val.roleGroupName}</Option>;
    // });
    return this.state.roleGroupList.map((val, key) => {
      if (key !== 0) {
        return (
          <Option key={key} value={val.roleGroupId + ""}>
            {val.roleGroupName}
          </Option>
        );
      }
    });
  };
  /******************************render******************************/

  render() {
    const formItemLayout = {
      labelCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 7
        }
      },
      wrapperCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 12
        },
        md: {
          span: 10
        }
      }
    };
    const { getFieldDecorator } = this.props.form;

    return (
      <Box>
        <Drawer
          title="新增角色"
          // overlayColor="rgba(0, 0, 0,0)"
          placement="right"
          visible={this.state.open}
          // noTouchClose
          width={600}
          // zIndex={999}
          // className="drawer-box"
          onChange={open => {
            const form = this.props.form;
            if (open === false) {
              form.setFieldsValue({ roleName: "", roleGroupId: "" });
            }
            this.props.onChange(open);
            this.setState({ open });
          }}
          onClose={() => this.setState({ open: false })}
          destroyOnClose
          style={{
            height: "calc(100% - 55px)",
            overflow: "auto",
            paddingBottom: 53
          }}
        >
          <div>
            {/* <div className="drawer-header">新增角色</div> */}
            <div>
              <Form onSubmit={this.handleSaveRoleSubmit}>
                <FormItem {...formItemLayout} label="角色名称">
                  {getFieldDecorator("roleName", {
                    initialValue: this.state.roleMessage.roleName,
                    rules: [
                      {
                        required: true,
                        message: "角色名称不能为空"
                      },
                      {
                        pattern: /^[A-Za-z0-9\u4e00-\u9fa5]{1,20}$/,
                        message: "请输入中文，英文，数字!"
                      }
                    ]
                  })(<Input placeholder="请输入角色名称" maxLength={20} />)}
                </FormItem>
                <FormItem {...formItemLayout} label="所属分组:">
                  {getFieldDecorator("roleGroupId", {
                    initialValue: this.state.roleMessage.roleGroupId,
                    rules: [
                      {
                        required: true,
                        message: "请输入所属分组"
                      },
                      {
                        validator: this.checkPhone
                      }
                    ]
                  })(
                    <Select placeholder="请输入所属分组">
                      {this.renderRoleGroup()}
                    </Select>
                  )}
                </FormItem>
              </Form>
            </div>
            {/* <div className="drawer-footer"> */}
            <div
              style={{
                position: "absolute",
                bottom: 0,
                width: "100%",
                borderTop: "1px solid #e8e8e8",
                padding: "10px 16px",
                textAlign: "right",
                left: 0,
                background: "#fff",
                borderRadius: "0 0 4px 4px"
              }}
            >
              <Button
                style={{
                  marginRight: 8
                }}
                onClick={() => this.setState({ open: false })}
              >
                取消
              </Button>
              <Button
                type="primary"
                htmlType="submit"
                onClick={this.handleSaveRoleSubmit}
              >
                保存角色
              </Button>
            </div>
          </div>
        </Drawer>
      </Box>
    );
  }
}

/************************样式************************/

const Box = style.div`{
  .drawer-content{
    margin-top:28px;
  }
}`;
