import React, { Component } from 'react';
import { connect } from 'dva';
import { withRouter } from "dva/router";
import {Button,Table,Modal,DatePicker,Icon} from 'antd';
import './less/report.less';
import PTable from "../../../components/Pro/PTable";
import moment from 'moment';

import { getHolderChangeList,getChangeDetail } from "../../../services/api";

const { RangePicker } = DatePicker;
const dateFormat = 'YYYY-MM-DD';

@connect(state => ({
  global: state.global
}))
@withRouter
export default class ShareholderChangeLog extends Component {
  constructor(props,context){
    super(props,context);
    this.state = {
      eventDetails:[],
      start:false,
      end:false,
      startTime:'',
      endTime:'',
      forceUpdate:false,
      visible:false,
      eventDate:"",
      pageParm:{
        pageSize: "10",
        pageNumber: "1",
        // comId: 1,
        startDate:'',
        endDate:'',
      }
    }
  }

  handleCancel = (e) => {
    this.setState({
      visible: false,
    });
  };

  componentDidMount() {}


    //重置
    resetting = () => {
      this.setState({
        start:false,
        end:false,
        forceUpdate:true,
        startTime:'',
        endTime:'',
        pageParm:{
          pageSize: 10,
          pageNumber: 1,
          startDate:'',
          endDate:'',
        },
      },()=>{
        this.setState({
          forceUpdate:false,
        });
      });

    };

  //点击搜索
  search = () => {
    let pageParm = {...this.state.pageParm};
    pageParm.startDate = this.state.startTime;
    pageParm.endDate = this.state.endTime;
    this.setState({pageParm,forceUpdate:true});
  };

  //得到变更记录明细
  changeDetail = (eventId) => {
    getChangeDetail({id: eventId}).then((data) => {
        this.setState({
          eventDetails : data.data
         });
      }, (err) => {
        console.log(err, "getChangeDetail");
      });
  };

  //展示详情
  showDetails = (eventId, eventDate) => {
    this.setState({
      eventDate,
      visible:true
    });
    this.changeDetail(eventId);
  };

  // 表格渲染
  changeList = () => {
    const columns = [
      {
        title: '变更日期',
        dataIndex: 'eventDate',
        key: 'eventDate',
      },
      {
        title: '变更事项',
        dataIndex: 'changeType',
        key: 'changeType',
      },
      {
        title: '股东总人数',
        dataIndex: 'changeAfterPerNum',
        key: 'changeAfterPerNum',
      },
      {
        title: '出资总金额',
        dataIndex: 'changeAfterAmount',
        key: 'changeAfterAmount',
      },
      {
        title: "操作",
        render: (text, record) => (
          <div>
            <span style={{color: "#108EE9", cursor: "pointer", marginRight: "20px"}} onClick={this.showDetails.bind(this,record.stockChangeEventId, record.eventDate)} >查看</span>
          </div>
        )
      },
    ];

    return (
      <PTable
        columns={columns}
        url="getHolderChangeList"
        pageParm={this.state.pageParm}
        forceUpdate={this.state.forceUpdate}
      />
    );
  };

  renderListRt = () => {
    return(
      <div className="wed">
        <h2 style={{fontSize: '12px', color: '#666666'}}>变更日期：
            <span style={{fontSize: '12px', color: '#999'}}>{this.state.eventDate}</span>
        </h2>
        <ul>
        {this.state.eventDetails.map( (value,index)=>{

            if (value.stockChangeType === '1') { //增资
              return (
                <li style={{borderTop:'1px solid #e9e9e9',padding: '10px 0',listType:'none'}} key={index}>
                  <p>变更事项{index+1}：增资</p>
                  <div>
                    <span style={{display:'inline-block',width: '50%'}}>增资股东：{value.holderName}</span>
                    <span style={{display:'inline-block',width: '50%'}}>增资金额：{value.amount}</span>
                  </div>
                  <div>
                    <span style={{display:'inline-block',width: '50%'}}>增资后持股比例：{value.propStr}</span>
                  </div>
                </li>
                );
            } else if (value.stockChangeType === '2') { //减资
              return (
                <li style={{borderTop:'1px solid #e9e9e9',padding: '10px 0',listType:'none'}} key={index}>
                  <p>变更事项{index+1}：减资</p>
                  <div>
                    <span style={{display:'inline-block',width: '50%'}}>减资股东：{value.holderName}</span>
                    <span style={{display:'inline-block',width: '50%'}}>减资金额：{value.amount}</span>
                  </div>
                  <div>
                    <span style={{display:'inline-block',width: '50%'}}>减资后持股比例：{value.propStr}</span>
                  </div>
                </li>
                );
            } else if (value.stockChangeType === '3') { //股权变更
              return (
                <li style={{borderTop:'1px solid #e9e9e9',padding: '10px 0',listType:'none'}} key={index}>
                  <p>变更事项{index + 1}：股权转让</p>
                  <div>
                    <span style={{display:'inline-block',width: '50%'}}>转让股东：{value.holderName}</span>
                    <span style={{display:'inline-block',width: '50%'}}>受让股东：{value.transName}</span>
                  </div>
                  <div>
                    <span style={{display:'inline-block',width: '50%'}}>转让金额：{value.amount}</span>
                    <span style={{display:'inline-block',width: '50%'}}>转让后持股比例：{value.propStr}</span>
                  </div>
                </li>
                );
            }
          })}
        </ul>
      </div>
    )
  };


  onChangeTime = (date, dateString) =>{
    this.setState({
      start:true,
      end:true,
      startTime:dateString[0],
      endTime:dateString[1],
    });
  };
  render() {
    return (
      <div className="ShareholderChangeLog">
        <div className="change_header">
          <label style={{marginLeft:16,marginBottom:'16px'}}>变更日期：
            <RangePicker
              format={dateFormat}
              onChange={this.onChangeTime}
              allowClear={false}
              style={{width: 230}}
              value={[
                this.state.start ? moment(this.state.startTime,dateFormat) : null,
                this.state.end ? moment(this.state.endTime,dateFormat) : null
              ]}
            />
          </label>
          <Button style={{marginLeft:16,marginBottom:'16px'}} type="primary" onClick={this.search}>搜索</Button>
          <Button style={{marginLeft:16,marginBottom:'16px'}} onClick={this.resetting}>重置</Button>
        </div>
        <Button style={{marginLeft:16,marginBottom:'16px'}} type="primary"
                onClick={()=>{
                  // console.log(">>>>>>>>>>>>>>>>xxxxxx>>>>",this.props);
                  // this.props.history.push(`/enterprise/reported/changeownership`);
                  // this.props.close();
                  this.props.switchToChangeOwnership();
                }}
        // ><Icon type="plus" style={{ fontSize: 14, color: '#fff' }} />股权调整</Button>
        >股权调整</Button>
         <Button style={{marginLeft:16,marginBottom:'16px'}} onClick={()=>{
            // this.props.history.push(`/enterprise/reported/shareholder`);
            this.props.close();
          }}
          >返回</Button>
        {this.changeList()}

        <Modal
          title="股权变更记录"
          visible={this.state.visible}
          footer={false}
          onCancel={this.handleCancel}
          width='700px'
        >
          {this.renderListRt()}
          <Button style={{display:'block',margin:'10px auto'}} type="primary" onClick={this.handleCancel}>关闭</Button>
        </Modal>
      </div>
    );
  }
}
