import React, { Component } from 'react';
import { connect } from 'dva';
import { Input, Button, DatePicker, Table, Modal, message, Select, Icon } from 'antd';
import "./less/report.less";
import * as ajax from "../../../services/api";
import moment from 'moment';
import PTable from "../../../components/Pro/PTable";
import OverseasDetails from './OverseasDetails';
import AssOverseasDetails from './AddOverseasDetails'

const Option = Select.Option;
const confirm = Modal.confirm;
const { RangePicker } = DatePicker;
const dateFormat = 'YYYY-MM-DD';



export default class OverseasBasic extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      // comId: 1,
      open: false,
      open2:false,
      securityRange: [],//安保范围
      nationality: [],//国家，地区
      startTime: null,//开始时间
      endTime: null,//结束时间
      start: false,
      end: false,
      range: '',//安保选中值
      nation: '',//国家选中值
      manageMode: [],//经营模式
      mode: '',//经营模式选中值
      input_val: '',//输入框的值
      visibleDetail: false,
      overseaManageId: '00',
      pageParm: {
        pageSize: "10",
        pageNumber: "1",
        // comId: 1,
        startSerachDate: '',
        endSerachDate: '',
        securityRangeContent: '',
        serachContent: '',
        conturyContent: '',
      },
      forceUpdate: false,
    };
  }

  componentDidMount() {
    this.getDictionaryData(); //获取所有所需要字典数据
  }

  //获取所有所需要字典数据
  getDictionaryData = () => {
    ajax
      .publicCommonDictGetDictByCodeTypes({
        codeTypes: ['nationality', 'manageMode', 'securityRange']
      })
      .then(data => {
        //判断获取数据是否为空
        if (data.data) {
          this.setState({
            nationality: data.data.nationality, //国籍选择
            manageMode: data.data.manageMode,
            securityRange: data.data.securityRange
          });
        }
      });
  };

  //输入框的书写
  inputTracknameChange = (e) => {
    console.log(e.target.value.trim());
    this.setState({
      input_val: e.target.value.trim(),
    })
  };

  //安保类型选中值
  handleChangeAn = (value) => {
    console.log(`selected ${value}`);
    this.setState({
      range: value,
    });
  };

  //国家选中值
  handleChangeNation = (value) => {
    console.log(`selected ${value}`);
    this.setState({
      nation: value,
    });
  };

  //经营模式选中值
  handleChangeMode = (value) => {
    console.log(`selected ${value}`);
    this.setState({
      mode: value,
    });
  };

  //时间选择
  onChangeTime = (date, dateString) => {
    if (dateString[0] !== '') {
      this.setState({
        start: true,
        end: true,
        startTime: dateString[0],
        endTime: dateString[1],
      });
    } else {
      this.setState({
        start: false,
        end: false,
        startTime: '',
        endTime: '',
      });
    }
  };


  //点击搜索
  search = () => {
    let pageParm = { ...this.state.pageParm };
    let serachContent = this.state.input_val;
    pageParm.serachContent = serachContent;
    let securityRangeContent = this.state.range;
    pageParm.securityRangeContent = securityRangeContent;
    if (this.state.start !== false) {
      let startSerachDate = this.state.startTime;
      pageParm.startSerachDate = startSerachDate;
    } else {
      pageParm.startSerachDate = '';
    }
    if (this.state.end !== false) {
      let endSerachDate = this.state.endTime;
      pageParm.endSerachDate = endSerachDate;
    } else {
      pageParm.endSerachDate = '';
    }
    let conturyContent = this.state.nation;
    pageParm.conturyContent = conturyContent;
    let manageMode = this.state.mode;
    pageParm.manageMode = manageMode;
    this.setState({ pageParm });
  };

  //重置
  resetting = () => {
    this.setState({
      input_val: '',//输入框的值
      range: '',//安保选中值
      start: false,
      end: false,
      nation: '',
      mode: '',
      forceUpdate: true,
      pageParm: {
        pageSize: "10",
        pageNumber: "1",
        // comId: 1,
        startSerachDate: '',
        endSerachDate: '',
        securityRangeContent: '',
        serachContent: '',
        conturyContent: '',
      },
    });
  };

  //table 数据变化
  dateTableChange = (data) => {
    // console.log('data', data);
  };

  // 表格渲染
  renderOrderList = () => {
    const columns = [
      {
        title: '经营国家',
        dataIndex: 'nationalityDescription',
        key: 'nationalityDescription',
      },
      {
        title: '经营模式',
        dataIndex: 'manageModeDescription',
        key: 'manageModeDescription',
      },
      {
        title: '经营时间',
        dataIndex: 'time',
        key: 'time',
        render: (text, record) => (
          <p style={{ margin: 0, padding: 0 }}>
            <span>{record.startDate}</span>
            <span style={{ magin: '0 3px' }}>至</span>
            <span>{record.endDate}</span>
          </p>
        )
      },
      {
        title: '备案机关',
        dataIndex: 'recordPoliceName',
        key: 'recordPoliceName',
      },
      {
        title: '安保类型',
        render: (text, record) => (
          <p style={{ margin: 0, padding: 0 }}>
            <span>{record.securityRangeContentArrays[0] != null ? record.securityRangeContentArrays[0] : ''}</span>
            <span style={{ marginLeft: '5px' }}>{record.securityRangeContentArrays[1] != null ? record.securityRangeContentArrays[1] : ''}</span>
            <span style={{ marginLeft: '5px' }}>{record.securityRangeContentArrays[2] != null ? record.securityRangeContentArrays[2] : ''}</span>
            <span style={{ marginLeft: '5px' }}>{record.securityRangeContentArrays[3] != null ? '...' : ''}</span>
          </p>
        )
      },
      {
        title: "操作",
        render: (text, record) => (
          <div>
            <span style={{ color: "#108EE9", cursor: "pointer", marginRight: "20px" }}
              onClick={() => {
                // this.props.props.history.push(`/enterprise/reported/overseasdetails/${record.overseaManageId}`);
                this.setState({
                  overseaManageId: record.overseaManageId,
                  open: true
                });
              }}>修改</span>
            <span style={{ color: "#108EE9", cursor: "pointer" }}
              onClick={this.showDeleteConfirm.bind(this, record.overseaManageId)}>删除</span>
          </div>
        )

      },
    ];

    return (
      <PTable
        columns={columns}
        url="comStockComOverseaManageList"
        pageParm={this.state.pageParm}
        dateChange={this.dateTableChange}
        forceUpdate={this.state.forceUpdate}
        showTotal={total => `共搜索到${total}条记录`}
      />
    );
  };

  //安保类型下拉选择值
  renderSecurityRange = () => {
    return this.state.securityRange.map((val, key) => {
      return <Option key={key} value={val.codeValue + ""}>{val.label}</Option>;
    });
  };

  //国家下拉选择值
  renderNationality = () => {
    return this.state.nationality.map((val, key) => {
      return <Option key={key} value={val.codeValue + ""}>{val.label}</Option>;
    });
  };

  //经营模式下拉选择值
  manageMode = () => {
    return this.state.manageMode.map((val, key) => {
      return <Option key={key} value={val.codeValue + ""}>{val.label}</Option>;
    });
  };

  //删除
  showDeleteConfirm = (orderID) => {
    console.log(orderID);
    let _this = this;
    confirm({
      title: '是否删除所选信息，删除后无法找回。是否确认删除？',
      okText: '确认',
      cancelText: '取消',
      onOk() {
        _this.orderDelete(orderID);
      },
      onCancel() {
        console.log('Cancel');
      },
    });

  };
  // 订单删除
  orderDelete = (orderID) => {
    ajax.comStockDeleteOverseaManageById({ overseaManageId: orderID }).then((data) => {
      console.log('删除成功！');
      this.setState({ forceUpdate: true });
    }, (err) => {
      console.log(err);
    })
  };

  callback = () => {
    this.setState({ open: false, open2: false });
    // this.ajaxInsPage();
    this.setState({ forceUpdate: true });
  };
  //方法调用
  onRef = (ref) => {
    this.child = ref;
  }
  resetFrom = () => {
    this.child.resetFrom();
  }

  render() {
    let display = { display: "block" };
    if (this.state.visibleDetail) {
      display = { display: "none" };
    }

    return (
      <div className="report-mess">
        <div style={display}>
          <div className="form">
            <label>关键字：
            <Input style={{ width: 214, marginBottom: '16px' }}
                placeholder="请输入备案机关"
                onChange={this.inputTracknameChange}
                value={this.state.input_val}
                maxLength={20}
              /></label>
            <label style={{ marginLeft: 16, marginBottom: '16px' }}>安保类型：
            <Select value={this.state.range} style={{ width: 214, marginBottom: '16px' }} onChange={this.handleChangeAn}>
                <Option value="">请选择</Option>
                {this.renderSecurityRange()}
              </Select>
            </label>
            <label style={{ marginLeft: 16, marginBottom: '16px' }}>经营开始日期：
              <RangePicker
                format={dateFormat}
                onChange={this.onChangeTime}
                style={{width: 230}}
                value={[
                  this.state.start ? moment(this.state.startTime, dateFormat) : null,
                  this.state.end ? moment(this.state.endTime, dateFormat) : null
                ]}
              />
            </label>
            <label style={{ marginLeft: 16, marginBottom: '16px' }}>选择国家/地区：
            <Select placeholder="请选择"
                value={this.state.nation}
                style={{ width: 214, marginBottom: '16px' }}
                onChange={this.handleChangeNation}
                showSearch
                optionFilterProp="children"
                filterOption={(input, option) => option.props.children.toLowerCase().indexOf(input.toLowerCase()) >= 0}
              >
                <Option value="">请选择</Option>
                {this.renderNationality()}
              </Select>
            </label>
            <label style={{ marginLeft: 16, marginBottom: '16px' }}>经营模式：
            <Select placeholder="请选择" value={this.state.mode} style={{ width: 214, marginBottom: '16px' }} onChange={this.handleChangeMode}>
                <Option value="">请选择</Option>
                {this.manageMode()}
              </Select>
            </label>
            <Button style={{ marginLeft: 16, marginBottom: '16px' }} type="primary" onClick={this.search}>搜索</Button>
            <Button style={{ marginLeft: 16, marginBottom: '16px' }} onClick={this.resetting}>重置</Button>
          </div>
          <div className="district-butt" style={{ marginTop: 0 }}>
            <Button type="primary" onClick={() => {
              // this.props.props.history.push(`/enterprise/reported/overseasdetails/${'00'}`);
              this.setState({
                overseaManageId: '00',
                open2: true
              });
            }}><Icon type="plus" />新增记录</Button>
          </div>
          {this.renderOrderList()}
        </div>
        {
          this.state.open&& <OverseasDetails
          overseaManageId={this.state.overseaManageId}
          close={this.callback}
          visible={this.state.open}
          onChange={(open) => {
            this.setState({ open });
          }} />
        }
       {
         this.state.open2&&<AssOverseasDetails
          overseaManageId={this.state.overseaManageId}
          visible={this.state.open2}
          onRef={this.onRef}
          close={this.callback}
          onChange={(open2) => { this.setState({ open2 }); }} />
       }
          
      </div>
    );
  }
}
