/**
 * @author  Xyz
 * 分公司管理
 */
import React from 'react';
import {
  Form,
  Input,
  Button,
  message,
  Table,
  Popover,
  Modal
} from 'antd';
import {
  Container,
  SearchItem,
  Options,
} from "./styles";
import PTable from '../../../components/Pro/PTable';

import DrawBranchCompanyDetail from './DrawBranchCompanyDetail';//分公司详情
const FormItem = Form.Item;
@Form.create()
export default class OnJob extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      visible: false,
      pageParm: {     //数据请求 分页信息
        pageSize: '10',//缴交情况
        pageNumber: "1",
        keyWord: "",
      },
    }
  }

  /******************************生命周期******************************/

  componentDidMount = () => {

  }

  /******************************ajax请求******************************/


  /******************************相关事件******************************/

    //新增分公司
  addCompany = () => {
    this.setState({visible: true});
  }
  //修改分公司 item
  upDateItem = () => {
    this.setState({visible: true});
  }

  //关闭 修改 item 抽屉
  closeDrawer = () => {
    this.setState({visible: false});
  }


  onOkDrawer = () => {
    console.log("onOkDrawer");
  }
  onCancelDrawer = () => {
    this.closeDrawer();
  }
  /******************************render******************************/
  renderTable = () => {
    const data1 = [{
      key: '1',
      name: 'John Brown',
      age: 32,
      address: 'New York No. 1 Lake Park',
    }, {
      key: '2',
      name: 'Jim Green',
      age: 42,
      address: 'London No. 1 Lake Park',
    }, {
      key: '3',
      name: 'Joe Black',
      age: 32,
      address: 'Sidney No. 1 Lake Park',
    }];


    const columns1 = [
      {
        title: '姓名',
        dataIndex: 'comName',
        key: 'comName',
        render: text => <a href="javascript:;">{text}</a>,
      },
      {
        title: '职位',
        dataIndex: 'comCerNo',
        key: 'comCerNo',
      },
      {
        title: '所在部门',
        dataIndex: 'address',
        key: 'address',
      },
      {
        title: '手机号',
        dataIndex: 't1',
        key: 't1',
      },
      {
        title: '邮箱',
        dataIndex: 't2',
        key: 't2',
      },
      {
        title: '状态',
        dataIndex: 't3',
        key: 't3',
      },
      {
        title: '操作',
        key: 'action',
        render: (text, record) => (
          <Options>
            <span onClick={this.upDateItem}>查看</span>
          </Options>
        ),
      }
    ];
    {/*<PTable url="enterpriseComManagerListBranchComManager" columns={columns1}/>*/
    }

    return (
      <PTable
        url="enterpriseCompanyComBaseInfoGetBranch"
        pageParm={this.state.pageParm}
        columns={columns1}
        forceUpdate={this.state.forceUpdate}
      />
    );
  }

  render() {
    const {visible} = this.state;
    return (
      <Container>
        <SearchItem>
          关键字：
          <Input className="input" placeholder="请输入负责人/手机号/备案机关"/>
          <Button className="btn" type="primary">搜索</Button>
          <Button>重置</Button>
        </SearchItem>

        {this.renderTable()}

        <DrawBranchCompanyDetail
          visible={visible}
          closeDrawer={this.closeDrawer}
        />

      </Container>
    );
  }
}


