import React, { Component } from 'react';
import { connect } from 'dva';
import {Button,Table,Modal,DatePicker,Icon} from 'antd';
import './less/report.less';
import PTable from "../../../components/Pro/PTable"
import moment from 'moment';
import "moment/locale/zh-cn";
import * as ajax from "../../../services/api";
const { RangePicker } = DatePicker;

const dateFormat = 'YYYY-MM-DD';


export default class ManagementChangeReport extends Component {
  constructor(props,context){
    super(props,context);
    this.state = {
      start:false,
      end:false,
      startTime: null,//开始时间
      endTime: null,//结束时间
      startDate:'',
      endDate:'',
      forceUpdate:false,
      visible:false,
      oldManagerName:'',
      oldManagerIdCardNo:'',
      newManagerName:'',
      newManagerIdCardNo:'',
      positionName:'',
      pageParm:{
        pageSize: 10,
        pageNumber: 1,
        // comId: 1,
      }
    }
  }


  // 表格渲染
  renderOrderList = () => {
    const columns = [
      {
        title: '变更日期',
        dataIndex: 'createTime',
        key: 'createTime',
        render: (text, record) => (
          <p>{record.createTime}</p>
        ),
      },
      {
        title: '变更前管理人员/身份证号',
        dataIndex: 'oldManage',
        key: 'oldManage',
        render: (text, record) => (
          <p>{record.oldManagerName}/{record.oldManagerIdCardNo}</p>
        ),
      },
      {
        title: '变更后管理人员/身份证号',
        dataIndex: 'newManage',
        key: 'newManage',
        render: (text, record) => (
          <p>{record.newManagerName}/{record.newManagerIdCardNo}</p>
        ),
      },
      {
        title: '职务',
        dataIndex: 'positionName',
        key: 'positionName',
      }
    ];

    return (
      <PTable
        columns={columns}
        url="comStockChangeManageList"
        pageParm={this.state.pageParm}
        forceUpdate={this.state.forceUpdate}
      />
    );

  };


    //重置
    resetting = () => {
      this.setState({
        start:false,
        end:false,
        forceUpdate:true,
        pageParm:{
          pageSize: 10,
          pageNumber: 1,
        },
      },()=>{
        this.setState({
          forceUpdate:false,
        });
      });

    };


  //点击搜索
  search = () => {
    let pageParm = {...this.state.pageParm};
    if(this.state.start !== false){
      let startDate = this.state.startTime;
      pageParm.startDate = startDate;
    }else{
      pageParm.startDate = '';
    }
    if(this.state.end !== false){
      let endDate = this.state.endTime;
      pageParm.endDate = endDate;
    }else{
      pageParm.endDate = '';
    }

    this.setState({pageParm});
  };


  onChangeTime = (date, dateString) =>{
    if (dateString[0] !== '') {
      this.setState({
        start: true,
        end: true,
        startTime: dateString[0],
        endTime: dateString[1],
      });
    } else {
      this.setState({
        start: false,
        end: false,
        startTime: '',
        endTime: '',
      });
    }
  };


  render() {
    return (
      <div className="ShareholderChangeLog">
        <div className="change_header" style={{marginTop:'16px'}}>
          <label style={{marginLeft:16,marginBottom:'16px'}}>变更日期：
            <RangePicker
              format={dateFormat}
              onChange={this.onChangeTime}
              style={{width: 230}}
              value={[
                this.state.start ? moment(this.state.startTime,dateFormat) : null,
                this.state.end ? moment(this.state.endTime,dateFormat) : null
              ]}
            />
          </label>
          <Button style={{marginLeft:16,marginBottom:'16px'}} type="primary" onClick={this.search}>搜索</Button>
          <Button style={{marginLeft:16,marginBottom:'16px'}} onClick={this.resetting}>重置</Button>

        </div>
        <Button style={{marginLeft:16,marginBottom:'16px'}} type="primary"
                onClick={()=>{
                  // this.props.history.push(`/enterprise/reported/managementchange`);
                  this.props.closeback();
                }}
        ><Icon type="plus" style={{ fontSize: 14, color: '#fff' }} />新增变更</Button>
          <Button style={{marginLeft:16,marginBottom:'16px'}}
                onClick={()=>{
                  this.props.close();
                }}
        > 返回</Button>
        {this.renderOrderList()}
      </div>
    );
  }
}
