import React, { Component } from 'react';
import { connect } from 'dva';
import { Input, Button, DatePicker, Table, Modal, message, Tooltip, Alert } from 'antd';
import PTable from "../../../components/Pro/PTable";
import * as ajax from "../../../services/api";
import "./less/report.less"
import ManagementAdd from './ManagementAdd';
import ManagementChange from './ManagementChange';
import ManagementChangeReport from './ManagementChangeReport';
import AddManagementlist from './AddManagementlist';

const confirm = Modal.confirm;

export default class ManagementBasic extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      open: false,
      open2: false,
      pageParm: {
        // comId: 1,
        pageSize: "10",
        pageNumber: "1",
      },
      forceUpdate: false,
      visibleDetail: false,
      visibleChangeReport: false,
      visibleDetailMore: false,
      comManagerId: '00',
      name: '',
      sex: '',
      idCardType: '',
      idCardNo: '',
      positionName: '',
      telephone: '',
    }
  }

  // 表格渲染
  renderOrderList = () => {
    const columns = [
      {
        title: '姓名',
        dataIndex: 'name',
        key: 'name',
      },
      {
        title: '性别',
        dataIndex: 'sexName',
        key: 'sexName',
      },
      {
        title: '证件类型',
        dataIndex: 'idCardTypeName',
        key: 'idCardTypeName',
      },
      {
        title: '证件号',
        dataIndex: 'idCardNo',
        key: 'idCardNo',
      },
      {
        title: '职务',
        dataIndex: 'positionName',
        key: 'positionName',
      },
      {
        title: '联系方式',
        dataIndex: 'telephone',
        key: 'telephone',
      },
      {
        title: "操作",
        key: 'yu',
        render: (text, record) => (
          <div>
            <span style={{ color: "#108EE9", cursor: "pointer", marginRight: "20px" }}
              onClick={() => {
                // this.props.props.history.push(`/enterprise/reported/managementadd/${record.comManagerId}`);
                this.setState({
                  comManagerId: record.comManagerId,
                  open: true
                });
              }}>修改</span>
            <span style={{ color: "#108EE9", cursor: "pointer" }}
              onClick={this.showDeleteConfirm.bind(this, record.comManagerId)}>删除</span>
          </div>
        )

      },
    ];

    return (
      <PTable
        columns={columns}
        url="comStockManageList"
        pageParm={this.state.pageParm}
        dateChange={this.dateTableChange}
        forceUpdate={this.state.forceUpdate}
      />
    );
  };


  //table 数据变化
  dateTableChange = (data) => {
    // console.log('data', data);
  };

  // 点击查看展示信息弹窗
  clickHandlerView = (orderID) => {
    console.log(orderID);
    this.setState({
      checkModal: true,
    });
    // this.checkMessageTitle(orderID);
  };
  //删除
  showDeleteConfirm = (orderID) => {
    console.log(orderID);
    let _this = this;
    confirm({
      title: '是否删除所选信息，删除后无法找回。是否确认删除？',
      okText: '确认',
      cancelText: '取消',
      onOk() {
        _this.orderDelete(orderID);
      },
      onCancel() {
        console.log('Cancel');
      },
    });

  };
  // 订单删除
  orderDelete = (orderID) => {
    ajax.comStockDeleteManageById({ comManagerId: orderID }).then((data) => {
      this.setState({ forceUpdate: true });
    });
  };

  callbackChangeReport = () => {
    this.setState({ visibleChangeReport: false, visibleDetailMore: true, comManagerId: '00', });
    // this.ajaxInsPage();
    this.setState({ forceUpdate: true });
  };
  callbackChangeReportClose = () => {
    this.setState({ visibleChangeReport: false });
    // this.ajaxInsPage();
    this.setState({ forceUpdate: true });
  };

  callback = () => {
    this.setState({ open: false, open2: false });
    // this.ajaxInsPage();
    this.setState({ forceUpdate: true });
  };

  callbackMore = () => {
    this.setState({ visibleDetailMore: false });
    // this.ajaxInsPage();
    this.setState({ forceUpdate: true });
  };

  // 调用方法
  onRef = (ref) => {
    this.child = ref;
  };
  resetFrom = () => {
    this.child.resetFrom();
    console.log('1111111111>>>');
  };

  render() {
    let display = { display: "block" };
    if (this.state.visibleDetail || this.state.visibleDetailMore || this.state.visibleChangeReport) {
      display = { display: "none" };
    }
    return (
      <div className="report-mess">
        <Alert
          message={<div style={{ color: '#333' }}>
           注：根据监管要求，至少需要上报企业法人、总经理、副总经理级别的管理层人员信息，部门经理级别按照规定上报。
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        <div style={display}>
          <div className="district-butt" style={{ marginTop: 0 }}>
            <Button type="primary" onClick={() => {
              this.resetFrom();
              this.setState({
                comManagerId: '00',
                open2: true
              });
              // this.props.props.history.push(`/enterprise/reported/managementadd/${'00'}`);
            }}>新增管理人员</Button>
            <Button onClick={() => {
              // this.props.props.history.push(`/enterprise/reported/managementchange`);
              this.setState({
                comManagerId: '00',
                visibleDetailMore: true
              });
            }}>变更管理人员</Button>
            <Button onClick={() => {
              // this.props.props.history.push(`/enterprise/reported/managementchangereport`);
              this.setState({ visibleChangeReport: true });
            }}>变更记录</Button>
          </div>
          {this.renderOrderList()}
        </div>
        {this.state.visibleChangeReport && <ManagementChangeReport comManagerId={this.state.comManagerId} closeback={this.callbackChangeReport} close={this.callbackChangeReportClose} visible={this.state.visibleDetail} />}
        <ManagementAdd
          comManagerId={this.state.comManagerId}
          close={this.callback}
          visible={this.state.open}
          onChange={(open) => { this.setState({ open }); }}
        />
        <AddManagementlist
          comManagerId={this.state.comManagerId}
          close={this.callback}
          onRef={this.onRef}
          visible={this.state.open2}
          onChange={(open2) => { this.setState({ open2 }); }}
        />
        {this.state.visibleDetailMore && <ManagementChange comManagerId={this.state.comManagerId} close={this.callbackMore} visible={this.state.visibleDetailMore} />}
      </div>
    );
  }
}
