import React from 'react';

import {
  Container,
} from "./styles";

import {
  Form,
  Input,
  Button,
  message,
  Table,
  Popover,
  Tabs,
} from 'antd';

import OnJob from './OnJob';
import LeaveJob from './LeaveJob';

const TabPane = Tabs.TabPane;

export default class JobTab extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      cursor: "1"
    };
  }

  /******************************生命周期******************************/

  componentDidMount = () => {

  }

  /******************************ajax请求******************************/


  /******************************相关事件******************************/
  tabChange = (e) => {
    this.setState({cursor: e});
  }

  /******************************render******************************/

  render() {
    const {cursor} = this.state;
    return (
      <Container>
        <Tabs defaultActiveKey={cursor} onChange={this.tabChange}>
          <TabPane tab="跨区经营在职人员" key="1">
            {cursor === "1" && <OnJob/>}
          </TabPane>
          <TabPane tab="跨区域离职人员" key="2">
            {cursor === "2" && <LeaveJob/>}
          </TabPane>
        </Tabs>

      </Container>
    );
  }
}

