import React, { Component } from 'react';
import { connect } from 'dva';
import { withRouter } from 'react-router-dom';
import {
  Input,
  Button,
  DatePicker,
  Table,
  Modal,
  message,
  Tooltip,
  Select,
  Cascader
} from 'antd';
import moment from 'moment';
import "moment/locale/zh-cn";
import * as ajax from '../../../services/api';
import PTable from '../../../components/Pro/PTable';
import './less/report.less';
import DistrictDetails from './DistrictDetails';
import AddDistrictDetails from './AddDistrictDetalis';
import PCascader from '../../../components/Pro/PCascader';
const Option = Select.Option;

const confirm = Modal.confirm;
const { RangePicker } = DatePicker;
const dateFormat = 'YYYY-MM-DD';

const text = (
  <div className='prompt-text'>
    <h2 style={{ color: '#fff', fontSize: '14px', lineHeight: 1.5, margin: 0 }}>
      跨区经营情况用于记录公司跨区经营活动情况。
    </h2>
    <p style={{ fontSize: '12px', margin: 0, lineHeight: 1.4 }}>
      1、如果线下已做备案请【新增记录】。
    </p>
    <p style={{ fontSize: '12px', margin: 0, lineHeight: 1.4 }}>
      2、如果未备案可进入【在线备案】报备跨区经营信息。
    </p>
  </div>
);

@withRouter
@connect()

/** 跨区经营 */
export default class DistrictBasic extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      pageParm: {
        open: true,
        open2: false,
        // comId: 1,
        startSerachDate: '',
        endSerachDate: '',
        cityContent: '',
        provinceContent: '',
        areaContent: '',
        securityRangeContent: '',
        serachContent: '',
        pageSize: '10',
        pageNumber: '1'
      },
      forceUpdate: false,
      crossManageId: '00',
      securityRange: [], //安保范围
      areas: [], //地区
      input_val: '', //输入框的值
      range: '', //安保选中值
      startTime: null, //开始时间
      endTime: null, //结束时间
      arera_Val: [], //区域选中值
      start: false,
      end: false
    };
  }

  componentDidMount() {
    this.securityRangeList();
    // this.getDistrict();
  }

  securityRangeList = () => {
    ajax.publicCommonDictGetDictByCodeTypes({ codeTypes: 'securityRange' }).then(data => {
      if (data.data) {
        this.setState({
          securityRange: data.data.securityRange
        });
      }
    });
  };

  //省市区
  // getDistrict = () => {
  //   ajax.getDistrictData().then(data => {
  //     let areas = data.data.map(val => {
  //       return {
  //         value: val.regionId,
  //         label: val.regionName,
  //         children: val.childs.map(valChild => {
  //           return {
  //             value: valChild.regionId,
  //             label: valChild.regionName,
  //             children: valChild.childs.map(valChildChild => {
  //               return {
  //                 value: valChildChild.regionId,
  //                 label: valChildChild.regionName
  //               };
  //             })
  //           };
  //         })
  //       };
  //     });
  //     //console.log('areas:'+JSON.stringify(areas));
  //     this.setState({
  //       areas: areas
  //     });
  //   });
  // };

  //table 数据变化
  dateTableChange = data => {
    console.log('data', data);
  };

  //输入框的书写
  inputTracknameChange = e => {
    this.setState({
      input_val: e.target.value.trim()
    });
  };

  //时间选择
  onChangeTime = (date, dateString) => {
    if (dateString[0] !== '') {
      this.setState({
        start: true,
        end: true,
        startTime: dateString[0],
        endTime: dateString[1]
      });
    } else {
      this.setState({
        start: false,
        end: false,
        startTime: '',
        endTime: ''
      });
    }
  };

  //点击搜索
  search = () => {
    let pageParm = { ...this.state.pageParm };
    if (this.state.start !== false) {
      let startSerachDate = this.state.startTime;
      pageParm.startSerachDate = startSerachDate;
    } else {
      pageParm.startSerachDate = '';
    }
    if (this.state.end !== false) {
      let endSerachDate = this.state.endTime;
      pageParm.endSerachDate = endSerachDate;
    } else {
      pageParm.endSerachDate = '';
    }
    if (this.state.arera_Val.length !== 0) {
      let provinceContent = this.state.arera_Val[0];
      let cityContent = this.state.arera_Val[1];
      let areaContent = this.state.arera_Val[2];
      pageParm.cityContent = cityContent;
      pageParm.provinceContent = provinceContent;
      pageParm.areaContent = areaContent;
    } else {
      pageParm.cityContent = '';
      pageParm.provinceContent = '';
      pageParm.areaContent = '';
    }
    let securityRangeContent = this.state.range;
    pageParm.securityRangeContent = securityRangeContent;
    let serachContent = this.state.input_val;
    pageParm.serachContent = serachContent;
    this.setState({ pageParm });
  };

  //重置
  resetting = () => {
    this.setState({
      input_val: '', //输入框的值
      range: '', //安保选中值
      arera_Val: [], //区域选中值
      start: false,
      end: false,
      pageParm: {
        // comId: 1,
        startSerachDate: '',
        endSerachDate: '',
        cityContent: '',
        provinceContent: '',
        areaContent: '',
        securityRangeContent: '',
        serachContent: '',
        pageSize: '10',
        pageNumber: '1'
      },
      forceUpdate: true
    });
  };

  // 表格渲染
  renderOrderList = () => {
    const columns = [
      {
        title: '跨区经营市县',
        key: 'we',
        render: (text, record) => (
          <div>
            <p>
              <span>{record.provinceDescription}</span>
              {record.cityDescription ? (
                <span>-{record.cityDescription}</span>
              ) : (
                ''
              )}
              {record.areaDescription ? (
                <span>-{record.areaDescription}</span>
              ) : (
                ''
              )}
            </p>
          </div>
        )
      },
      {
        title: '负责人',
        dataIndex: 'responsPer',
        key: 'responsPer'
      },
      {
        title: '联系方式',
        dataIndex: 'responsPerPhone',
        key: 'responsPerPhone'
      },
      {
        title: '经营时间',
        dataIndex: 'startDate',
        key: 'startDate'
      },
      {
        title: '备案机关',
        dataIndex: 'recordPoliceName',
        key: 'recordPoliceName'
      },
      {
        title: '安保类型',
        render: (text, record) => (
          <p style={{ margin: 0, padding: 0 }}>
            <span>
              {record.securityRangeContentArrays[0] != null
                ? record.securityRangeContentArrays[0]
                : ''}
            </span>
            <span style={{ marginLeft: '5px' }}>
              {record.securityRangeContentArrays[1] != null
                ? record.securityRangeContentArrays[1]
                : ''}
            </span>
            <span style={{ marginLeft: '5px' }}>
              {record.securityRangeContentArrays[2] != null
                ? record.securityRangeContentArrays[2]
                : ''}
            </span>
            <span style={{ marginLeft: '5px' }}>
              {record.securityRangeContentArrays[3] != null ? '...' : ''}
            </span>
          </p>
        )
      },
      {
        title: '操作',
        key: 'yu',
        render: (text, record) => (
          <div>
            <span
              style={{
                color: '#108EE9',
                cursor: 'pointer',
                marginRight: '20px'
              }}
              onClick={() => {
                // this.props.props.history.push(`/enterprise/reported/districtdetails/${record.crossManageId}`);
                this.setState({
                  crossManageId: record.crossManageId,
                  open: true
                });
              }}
            >
              {/* 修改 */}
              查看
            </span>
            {/* <span
              style={{ color: "#108EE9", cursor: "pointer" }}
              onClick={this.showDeleteConfirm.bind(this, record.crossManageId)}
            >
              删除
            </span> */}
          </div>
        )
      }
    ];

    return (
      <PTable
        columns={columns}
        url='comStockCrossManageList'
        pageParm={this.state.pageParm}
        // dateChange={this.dateTableChange}
        forceUpdate={this.state.forceUpdate}
        showTotal
      />
    );
  };

  //删除
  showDeleteConfirm = orderID => {
    console.log(orderID);
    let _this = this;
    confirm({
      title: '是否删除所选信息，删除后无法找回。是否确认删除？',
      okText: '确认',
      cancelText: '取消',
      onOk() {
        _this.orderDelete(orderID);
      },
      onCancel() {
        console.log('Cancel');
      }
    });
  };

  // 订单删除
  orderDelete = orderID => {
    ajax
      .comStockDeleteCrossManageById({ crossManageId: orderID })
      .then(data => {
        this.setState({ forceUpdate: true });
      });
  };

  //安保类型下拉选择值
  renderSecurityRange = () => {
    return this.state.securityRange.map((val, key) => {
      return (
        <Option key={key} value={val.codeValue + ''}>
          {val.label}
        </Option>
      );
    });
  };

  //安保类型选中值
  handleChangeAn = value => {
    console.log(`selected ${value}`);
    this.setState({
      range: value
    });
  };

  //区域选择值
  onChangeDistrict = value => {
    console.log('区域选择值', value);
    this.setState({
      arera_Val: value
    });
  };
  // 调用方法
  onRef = ref => {
    this.child = ref;
  };
  resetFrom = () => {
    this.child.resetFrom();
  };

  callback = () => {
    this.setState({ open: false, open2: false });
    // this.ajaxInsPage();
    this.setState({ forceUpdate: true });
  };

  render() {
    let display = { display: 'block' };
    if (this.state.visible) {
      display = { display: 'none' };
    }

    return (
      <div className='report-mess'>
        <div style={display}>
          <div className='form'>
            <label>
              关键字：
              <Input
                style={{ width: 224, marginBottom: '16px' }}
                placeholder='请输入负责人/手机号/备案机关'
                onChange={this.inputTracknameChange}
                maxLength={20}
                value={this.state.input_val}
              />
            </label>
            <label style={{ marginLeft: 16, marginBottom: '16px' }}>
              安保类型：
              <Select
                value={this.state.range}
                style={{ width: 214 }}
                onChange={this.handleChangeAn}
              >
                <Option value=''>请选择</Option>
                {this.renderSecurityRange()}
              </Select>
            </label>
            <label style={{ marginLeft: 16, marginBottom: '16px' }}>
              经营开始时间：
              <RangePicker
                format={dateFormat}
                onChange={this.onChangeTime}
                style={{ width: 230 }}
                value={[
                  this.state.start
                    ? moment(this.state.startTime, dateFormat)
                    : null,
                  this.state.end ? moment(this.state.endTime, dateFormat) : null
                ]}
              />
            </label>
            <label style={{ marginLeft: 16, marginBottom: '16px' }}>
              选择区域：
              {/* <Cascader
                options={this.state.areas}
                placeholder='请选择'
                style={{ width: 250 }}
                onChange={this.onChangeDistrict}
                value={this.state.arera_Val}
              /> */}
               <PCascader 
                placeholder="请选择" 
                style={{ width: 250 }} 
                onChange={this.onChangeDistrict}
                value={this.state.arera_Val}
                />
            </label>
            <Button
              style={{ marginLeft: 16, marginBottom: '16px' }}
              type='primary'
              onClick={this.search}
            >
              搜索
            </Button>
            <Button
              style={{ marginLeft: 16, marginBottom: '16px' }}
              onClick={this.resetting}
            >
              重置
            </Button>
          </div>
          <div className='district-butt' style={{ marginTop: 0 }}>
            {/* <Tooltip placement="bottomLeft" title={text}>
              <Button
                type="primary"
                onClick={() => {
                  this.resetFrom();
                  // this.props.props.history.push(`/enterprise/reported/districtdetails/${'00'}`);
                  this.setState({
                    crossManageId: "00",
                    open2: true
                  });
                }}
              >
                新增记录
              </Button>
            </Tooltip> */}
            <Tooltip placement='bottomLeft' title={text}>
              <Button
                onClick={() => {
                  // window.history.go(0);
                  /*** 点击按钮跳转 备案许可申报 页面。*/
                  console.log('this', this);
                  this.props.history.push('/PoliceDeclare/DeclarationList');
                }}
                type='danger'
                ghost
              >
                在线备案
              </Button>
            </Tooltip>
          </div>
          {this.renderOrderList()}
        </div>
        <DistrictDetails
          crossManageId={this.state.crossManageId}
          visible={this.state.open}
          close={this.callback}
          onChange={open => {
            this.setState({ open });
          }}
        />
        <AddDistrictDetails
          crossManageId={this.state.crossManageId}
          visible={this.state.open2}
          onRef={this.onRef}
          close={this.callback}
          onChange={open2 => {
            this.setState({ open2 });
          }}
        />
      </div>
    );
  }
}
