/**
 * @author CYQ
 * 企业管理--监管设置页面
 */
import React from "react";
import { Form, Button, Cascader, Alert, Tabs } from "antd";
import style from "styled-components";
import {
  getSysPoliceList,
  saveComRegulatorSet,
  getComRegulatorSet
} from "../../../services/api";
const formItemLayout = {
  labelCol: {
    xs: {
      span: 4
    },
    sm: {
      span: 4
    },
    md: {
      span: 3
    }
  },
  wrapperCol: {
    xs: {
      span: 24
    },
    sm: {
      span: 16
    },
    md: {
      span: 14
    }
  }
};
const FormItem = Form.Item;
const { TabPane } = Tabs;
@Form.create()
export default class PlaceSupervisor extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      regulator: [],
      info: []
    };
  }

  /******************************生命周期******************************/

  componentWillMount() {
    this.__getComRegulatorSet();
    this.__getSysPoliceList();
  }
  //获取已经配置过机构的信息
  __getComRegulatorSet() {
    getComRegulatorSet({
      regulatorType:'1'
    }).then(res => {
      if (res.retType === "0") {
        this.setState({
          info: res.data
        });
      }
    });
  }
  //获取所有派出所信息
  __getSysPoliceList() {
    getSysPoliceList({
      regulatorType:'1'
    }).then(data => {
      let regulator = data.data.map(val => {
        return {
          value: val.policeId,
          label: val.policeName,
          children:
            val.childList &&
            val.childList.map(valChild => {
              return {
                value: valChild.policeId,
                label: valChild.policeName,
                children:
                  Object.prototype.toString
                    .call(valChild.childList)
                    .slice(8, -1) == "Array" &&
                  valChild.childList.length != 0 &&
                  valChild.childList.map(valChildChild => {
                    return {
                      value: valChildChild.policeId,
                      label: valChildChild.policeName
                    };
                  })
              };
            })
        };
      });
      this.setState({
        regulator: regulator
      });
    });
  }
  /******************************相关事件******************************/
  _submit() {
    this.props.form.validateFields((err, values) => {
      if (!err) {
        saveComRegulatorSet({
          cityOrgId: values.regulator[0],
          districtOrgId: values.regulator[1],
          policeStationId: values.regulator[2],
          regulatorType:'1'
        }).then(data => {
          if (data.retType === "0") {
          }
        });
      }
    });
  }

  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <div>
        <Alert
          message={
            <div style={{ color: "#333" }}>
              <span>
                受公安系统监管的机构企业，请按照企业的实际监管情况设置您的监管机构信息；
              </span>
              <br />
              <span>
                设置后，机构企业提交的申报数据、企业数据、员工数据等讲由相应监管机构进行管理。
              </span>
            </div>
          }
          type="warning"
          style={{ marginBottom: 16 }}
          showIcon
        />
        <Form>
          <Form.Item {...formItemLayout} label="所属监管机构">
            {getFieldDecorator("regulator", {
              initialValue: [
                this.state.info.cityOrgId,
                this.state.info.districtOrgId,
                this.state.info.policeStationId
              ],
              // initialValue: this.props.companyInfo.comName,
              rules: [
                {
                  required: true,
                  message: "请先选择监管机构"
                }
              ]
            })(
              <Cascader
                options={this.state.regulator}
                placeholder="请选择所属监管机构"
                // changeOnSelect
              />
            )}
          </Form.Item>
        </Form>
        <FormItem {...formItemLayout} label=" " colon={false}>
          <Button
            type="primary"
            onClick={() => {
              this._submit();
            }}
          >
            保存
          </Button>
        </FormItem>
        {/*<Button type="primary" onClick={() => { this._submit() }}>保存</Button>*/}
      </div>
    );
  }
}

export const Container = style.div`{
    padding: 10px 24px 24px;
  }`;
