import React, { Component } from 'react';
import st from 'styled-components';
import { connect } from 'dva';
import {
  // Button,
  // Alert,
  Popover,
  Input,
  Select,
} from 'antd';
import { withRouter } from 'dva/router';
import ExcelButtonOline from '../../../../../components/ExcelButtonOline';
import DepartSelect from '../../../../../components/user/DepartSelect';
import { publicCommonDictGetDictByCodeTypes, getPerType } from '../../../../../services/api';

import columnFun from './certificateColumn';
import tablePage from '../../../../../utils/hoc/tablePage';

const { Option } = Select;
@connect(state => ({
  global: state.global
}))
@tablePage()
@withRouter
export default class Submitted extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      params: null,
      jobSkillLevels: [{
        label: "全部", codeValue: ""
      }], //人员等级列表
      perTypeList: [], // 人员类别
    };
  }

  componentDidMount() {

  }
  componentWillMount() {
    publicCommonDictGetDictByCodeTypes({
      codeTypes: 'perCerLevel',
      // industryType,
      // institutionType
    }).then(res => {
      const jobSkillLevels = [...this.state.jobSkillLevels, ...res.data.perCerLevel];
      this.setState({
        jobSkillLevels
      });
    });
    getPerType({ codeType: 'perType' }).then(
      response => {
        if (response.data) {
          if (response.data) {
            const firstValue = {
              codeType: "perType",
              codeValue: "",
              label: "全部"
            };
            const perTypeList = [firstValue, ...response.data];
            this.setState({
              perTypeList,
              perType: perTypeList[0].codeValue
            });
          }
        }
      },
      err => {
        console.log(err);
      }
    );
  }

  // 表格渲染
  __renderOrderList = () => {
    const columns = columnFun.call(this);
    const { PageTable, isInit } = this.props;
    if (!isInit) return;
    return (
      <PageTable
        columns={columns}
        url="pageForPerCerInfo"
        // scroll={{ x: '1600px' }}
      />
    );
  };

  render() {
    const { SearchForm, Form } = this.props;
    const { getFieldDecorator, setFieldsValue } = this.props.form;
    return (
      <div className="tab_inner">
        {/* <Alert
          message={<div style={{ color: '#333' }}>
            <span>本页面为已提交保安岗位适应性培训记录页面，您可以实时查询学员的信息及状态。</span>
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        /> */}
        <SearchForm
          arrange={values => {
            values.departIds = values.departIds.map(item => item.split('-')[0]).join(',');
            this.setState({
              params: values //储存参数，供导出使用
            });
            return values;
          }}
          Btns={FormBtns}
        >
          <FormContainer>
            <Form.Item label="关键词">
              {getFieldDecorator('keyWord', {
                initialValue: ''
              })(
                <Input style={{ width: 240 }} placeholder="请输入姓名/手机号码/身份证" />
              )}
            </Form.Item>
            <Form.Item label="部门">
              {getFieldDecorator('departIds', {
                initialValue: []
              })(
                <DepartSelect
                  style={{ width: 240 }}
                  className="w-400 ipt-h"
                  dropdownStyle={{ maxHeight: 250, overflow: 'auto' }}
                  placeholder="请选择部门(默认为全部)"
                  treeDefaultExpandAll
                  allowClear
                  showSearch={true}
                  multiple
                  showCheckedStrategy={'TreeSelect.SHOW_ALL'}
                  onChange={values => {
                    setFieldsValue({departIds: values});
                  }}
                />
              )}
            </Form.Item>
            <Form.Item label="人员类别">
              {getFieldDecorator('perType', {
                initialValue: ''
              })(
                <Select
                  style={{ width: 240 }}
                  placeholder="请选择"
                  onChange={(value) => {
                    setFieldsValue({perType: value});
                  }}
                // disabled={this.props.companyInfo.industryType === '02' && this.state.perId !== ''}
                >
                  {(() => {
                    return this.state.perTypeList.map((val, key) => {
                      return (
                        <Option key={key} value={val.codeValue + ''}>
                          {val.label}
                        </Option>
                      );
                    });
                  })()}
                </Select>
              )}
            </Form.Item>
            <Form.Item label="资格证持证状态">
              {getFieldDecorator('czzt', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 240 }} >
                  <Option value="">全部</Option>
                  <Option value="0">未持证</Option>
                  <Option value="1">已持证</Option>
                </Select>
              )}
            </Form.Item>
            {/* <Form.Item label="等级证持证状态">
              {getFieldDecorator('materialApproveStatus', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 240 }} >
                  <Option value="">全部</Option>
                  <Option value="0">未核对</Option>
                  <Option value="1">核对通过</Option>
                  <Option value="2">核对不通过</Option>
                </Select>
              )}
            </Form.Item> */}
            <Form.Item label="保安等级">
              {getFieldDecorator('perCerLevel', {
                initialValue: ''
              })(
                <Select
                  style={{ width: 240 }}
                  placeholder="请选择"
                  onChange={(value) => {
                    setFieldsValue({perCerLevel: value});
                  }}
                >
                  {(() => {
                    return this.state.jobSkillLevels.map((item, index) => {
                      return (
                        <Option key={index} value={item.codeValue}>{item.label}</Option>
                      );
                    });
                  })()}
                </Select>
              )}
            </Form.Item>
          </FormContainer>
        </SearchForm>
        <Btns>
          <Popover content={<span style={{ display: 'block', padding: 10 }}>搜索后可导出搜索结果</span>}>
            <ExcelButtonOline
              disabled={!this.props.clicked}
              params={this.state.params}
              downloadname={`${this.props.global.companyInfo.comName}_保安证书.xls`}
              apiurl="system/per-cer-baseinfo/export-per-cer-info"
            >
              导出检索结果
            </ExcelButtonOline>
          </Popover>
        </Btns>
        {/* 表格 */}
        {this.__renderOrderList()}
      </div >
    );
  }
}

const FormBtns = st.div`
  background: #f9f9f9;
  padding-left: 50px;
  padding-bottom: 10px;
  button{
    margin-right: 15px;
  }
`;
const Btns = st.div`
  margin-top: 15px;
  button {
    margin-right: 15px;
  }
`;
const FormContainer = st.div`
  display: flex;
  background: #f9f9f9;
  padding: 15px 100px 15px 15px;
  flex-wrap: wrap;
  .ant-form-item{
    width: 30%;
    margin-bottom: 10px;
    margin-right: 0;
    box-sizing: border-box;
    text-align: right;
  }
`;