import React, { Component } from "react";
import { connect } from "dva";
import { Tabs } from "antd";
import queryString from "query-string";

import BasicInformationPage from "./BasicInformationPage";
import DetailedInformationPage from "./DetailedInformationPage";
import CertificateInformationPage from "./CertificateInformationPage";
import ContractInfo from "./ContractInfo";
import Identification from "./Identification";
import IDPhoto from './IDPhoto';
// import styles from './less/PersonnelInformationNav.less';

const { TabPane } = Tabs;

@connect(state => ({
  profile: state.profile
}))
export default class PersonnelInformationNav extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      tabPane_two: true,
      perId: ""
    };
  }

  componentDidMount() {
    const sd = queryString.parse(this.props.location.search).perId;  // 人员id
    const authStatus = queryString.parse(this.props.location.search).authStatus; //人员状态的判断，不让修改
    const reAddMember = queryString.parse(this.props.location.search).reAddMember; 
    const departId = queryString.parse(this.props.location.search).departId;  

    //从离职列表复职按钮调过来的情况是1 获取人员信息并且新增
    if (sd !== undefined && reAddMember != 1) {
      this.setState({
        tabPane_two: false
      });
    }
    this.setState({
      perId: sd,
      authStatus,
      reAddMember,
      departId //用来判定跳回到组织架构页面的定位
    });
  }

  //改变tab详细信息是否可以点击
  changeTabTwo = () => {
    this.setState({
      tabPane_two: false
    });
  };

  //基础信息向详细信息传值
  getChildId = event_id => {
    this.setState(
      {
        perId: event_id
      },
      () => {
        console.log("id的值id的值id的值", event_id);
      }
    );
  };

  handleSubmit = e => {
    e.preventDefault();
    this.props.form.validateFieldsAndScroll((err, values) => {
      if (!err) {
        this.props.dispatch({
          type: "form/submitRegularForm",
          payload: values
        });
      }
    });
  };
  callback = key => {
    // console.log("test");
    // console.log(key);
  };
  render() {
    return (
      <div>
        <Tabs
          tabBarStyle={{ marginLeft: 24, marginRight: 24 }}
          defaultActiveKey="1"
          onChange={this.callback}
        >
          <TabPane tab="基础信息" key="1">
            <BasicInformationPage
              props={this.props}
              handleChangeTab={this.changeTabTwo}
              getId={this.getChildId.bind(this)}
              perId={this.state.perId}
              authStatus={this.state.authStatus}
              reAddMember={this.state.reAddMember}
              departId={this.state.departId}
            />
          </TabPane>
          {
            !this.state.tabPane_two&&<TabPane tab="详细信息" key="2">
              <DetailedInformationPage
                props={this.props}
                perId={this.state.perId}
              />
            </TabPane>
          }
          {
            !this.state.tabPane_two&& <TabPane tab="证书信息" key="3">
            <CertificateInformationPage
              props={this.props}
              perId={this.state.perId}
            />
          </TabPane>
          }
         {
           !this.state.tabPane_two&&<TabPane tab="合同信息" key="4" >
            <ContractInfo
              props={this.props}
              perId={this.state.perId}
            />
          </TabPane>
         }
          
         {
           !this.state.tabPane_two&&<TabPane tab="身份证照片" key="5" >
            <Identification
              props={this.props}
              perId={this.state.perId}
            />
          </TabPane>
         }
          
          {
           !this.state.tabPane_two&&<TabPane tab="标准证件照片" key="6" >
            <IDPhoto
              props={this.props}
              perId={this.state.perId}
            />
           </TabPane>
          }
        </Tabs>
      </div>
    );
  }
}
