import React, { Component } from 'react';
import { Button } from 'antd';
import IEBrowserPrompt from "../../../components/Pro/IEBrowserPrompt/IEBrowserPrompt";
import "./less/IEReminder.less";

export default class IEReminder extends Component {
    constructor(props, context) {
        super(props, context);
        this.state = {
            isIEBrowser: false,
        };
    }

    /**
  * 生命周期
  */
    componentDidMount() {
        //
    }

    showModal = () => {
        this.setState({
            isIEBrowser: true,
        });
    }

    cancel = (mode) => {
        console.log(mode);
        this.setState({
            isIEBrowser: mode,
        });
    }

    render() {
        return (
            <div className="IEReminder">
                <div className="reminder-message">
                    <span>对不起，您当前的浏览器不支持！为保证系统安全，推荐使用Chrome，360或火狐浏览器的最新版本进行操作！</span>
                    <Button type="primary" onClick={this.showModal}>
                        查看支持浏览器
                    </Button>
                </div>
                <IEBrowserPrompt isIEBrowser={this.state.isIEBrowser} cancel={mode => this.cancel(mode)} />
            </div>
        );
    }
}

