import React, { Component } from 'react';
import { connect } from 'dva';

import { Alert, Steps, Upload, message, Button } from 'antd';

import './less/batch.less';
import { host } from '../../../services/api';
import axios from 'axios';
import store from 'store';
const { Step } = Steps;

@connect(state => ({
  global: state.global
}))
// 批量导入-导出/修改组织机构
export default class ExportChanges extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      //
    };
  }

  handleClickLink = () => {
    return (
      // <Button type="primary" onClick={() => window.open(`${lib.host}/static/template/OrderPerson_Template.xls`, "_self")}>导出员工信息</Button>
      <Button
        type="primary"
        onClick={() => {
          // console.log(this.props.global);
          // window.open(
          //   `${host}/system/com-depart/export-depart?comId=${
          //     this.props.global.companyInfo.comId
          //   }`,
          //   "_self"
          // );
          axios({
            method: 'get',
            url: `${host}/system/com-depart/export-depart?comId=${
              this.props.global.companyInfo.comId
            }`, //后台请求地址
            responseType: 'blob',
            headers: {
              access_token: store.get('saas')['access_token'],
        Accesstoken: store.get('saas')['access_token']|| sessionStorage.userV5Token,

            }
          }).then(data => {
            if (!data) {
              return;
            }
            let url = window.URL.createObjectURL(data.data);
            let link = document.createElement('a');
            link.style.display = 'none';
            link.href = url;
            link.setAttribute('download', `组织架构信息.xls`);
            document.body.appendChild(link);
            link.click();
          });
        }}
      >
        导出员工信息
      </Button>
    );
  };

  handleClickUpload = () => {
    const props = {
      name: 'xfile',
      action: `${host}/system/com-depart/get-import-depart-json`,
      headers: {
        authorization: 'Basic c2Fhc3dlYjp3ZWI='
      },
      onChange(info) {
        console.log(info, 'onChange-info');
        if (info.file.status !== 'uploading') {
          console.log(info.file, info.fileList);
        }
        if (info.file.status === 'done') {
          message.success(`${info.file.name} 成功上传！`);
        } else if (info.file.status === 'error') {
          message.error(`${info.file.name} 上传失败！`);
        }
      }
    };
    console.log(props, 'props');

    return (
      <Upload {...props}>
        <Button type="primary">选择上传文件</Button>
      </Upload>
    );
  };

  render() {
    console.log(this.props, 'this.props.companyInfo');

    return (
      <div className="ExportChanges">
        {/* <div className="batch-header">
          <Breadcrumb>
            <Breadcrumb.Item><a href="">组织架构</a></Breadcrumb.Item>
            <Breadcrumb.Item><a href="">运营二部</a></Breadcrumb.Item>
            <Breadcrumb.Item className="batch-span">批量导入/导出</Breadcrumb.Item>
          </Breadcrumb>
        </div> */}
        <div className="batch-content">
          <div className="batch-body">
            {/* <div className="batch-tabs">
              <ul className="clearfix">
                <li onClick={() => { this.props.history.push(`/batch`) }}>
                  <span>新建组织机构</span>
                </li>
                <li className="active">
                  <span>导出/修改组织机构</span>
                </li>
              </ul>
            </div> */}
            {/* <Alert
              message="导入会覆盖原有员工的信息，如需更新已存在的员工，请先导出通讯录，在导出表格里进行修改。"
              type="warning"
              showIcon
            /> */}
            <div className="tabs-content">
              <Steps direction="vertical" size="small" current={1}>
                <Step
                  // title="导出所有员工信息，批量修改员工信息"
                  title="导出所有员工信息"
                  description={this.handleClickLink()}
                />
                {/*  <Step
                  title="上传修改好的员工信息表"
                  description={this.handleClickUpload()}
                /> */}
              </Steps>
            </div>
          </div>
        </div>
      </div>
    );
  }
}
