import React, { PureComponent } from 'react';
// import { connect } from 'dva';
import moment from 'moment';
import "moment/locale/zh-cn";
import style from 'styled-components';
import {
  Form,
  Input,
  Button,
  Row,
  Col,
  Select,
  Icon,
  message,
  DatePicker,
  InputNumber
} from 'antd';
import { connect } from 'dva';
import $nModal from '../../../utils/modal/nModal';
import PFromUpload from '../../../components/Pro/PFromUpload';
import bcx_utils from '../../../common/bcx_utils';
import {
  getCertificationData,
  systemComVaseInfoGet,
  publicCommonDictGetDictByCodeTypes,
  // enterpriseCompanyGetComIndustryinfo,
  enterpriseCompanyUpdateComAuthInfo,
  enterpriseCompanySendLegalAuthCode,
  enterpriseComAuthInfoCheckLegalAuthCode,
  enterpriseCompanyComIndustryGetIndustryConfigByComId //新增特殊字段接口，10-16
} from '../../../services/api';

// @connect(state => ({
//   monitor: state.monitor,
// }))
const dateFormat = 'YYYY-MM-DD';
const { TextArea } = Input;
const FormItem = Form.Item;
const { Option } = Select;
const formItemLayout = {
  labelCol: {
    xs: { span: 6 },
    sm: { span: 6 }
  },
  wrapperCol: {
    xs: { span: 12 },
    sm: { span: 12 }
  }
};

@connect(state => ({
  companyInfo: state.global.companyInfo
}))
@Form.create()

/**
 * 完善企业认证信息
 */
export default class InitialAuthenticationInformation extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      infos: {}, //法人代表信息
      // industryInfo: [],// 行业资质
      nationality: [], //国籍信息
      idCardType: [], //证件类型
      conf_safeRange: [], //安保范围
      comCerType: [], //证件类型
      // comCerUrl: "",//工商注册信息 图片上传
      ifSendCode: false, //是否已经发送验证码
      count: 60, //验证码计时
      showIndustry: false,
      specialArray: []
    };
  }

  /******************************生命周期******************************/

  componentDidMount = () => {
    this.publicCommonDictGetDictByCodeTypes();
  };

  /******************************ajax请求******************************/

  //查询字典> 企业信息> 获得行业信息配置字段
  publicCommonDictGetDictByCodeTypes = () => {
    let tmp = {
      codeTypes: ['nationality', 'idCardType', 'conf_safeRange', 'comCerType']
    };
    publicCommonDictGetDictByCodeTypes(tmp)
      .then(
        ({ data: { nationality, idCardType, conf_safeRange, comCerType } }) => {
          this.setState({
            nationality,
            idCardType,
            conf_safeRange,
            comCerType
          });
          return getCertificationData({}); //企业信息
        },
        err => {
          console.log(err);
        }
      )
      .then(
        ({ data }) => {
          if (!data) {
            return;
          }
          this.setState({
            infos: data
          });
          return enterpriseCompanyComIndustryGetIndustryConfigByComId({
            institutionType: data.institutionType
          }); //企业信息-认证申请-获得企业机构特殊信息
        },
        err => {
          console.log(err);
        }
      )
      .then(
        data => {
          if (!data) {
            return;
          }
          if (data && data.data.length) {
            // this.enterpriseCompanyGetComIndustryinfo();
            this.setState({ showIndustry: true }); //隐藏特殊字段；10-11，冠男取消隐藏

            const specialArray = data.data.map((val, i) => {
              if (val.fieldType && val.fieldType === '4') {
                val.fieldOptions = val.fieldOptions
                  ? val.fieldOptions.split(',')
                  : [];
              }
              if (val.fieldType && val.fieldType === '5') {
                val.fieldOptions = val.fieldOptions
                  ? val.fieldOptions.split(',')
                  : [];
                val.fieldValue = val.fieldValue
                  ? val.fieldValue.split(',')
                  : [];
              }
              return Object.assign({}, val, {
                key: i + 1
              });
            });
            this.setState({
              specialArray
            });
          }
        },
        err => {
          console.log('企业信息-认证申请-获得企业机构特殊信息', err);
        }
      );
  };
  //企业信息-认证申请-行业资质查询
  // enterpriseCompanyGetComIndustryinfo = () => {
  //   enterpriseCompanyGetComIndustryinfo({}).then(
  //     ({ data }) => {
  //       console.log(data);
  //       if (!data || data.length === 0) {
  //         return;
  //       }
  //       this.setState({
  //         industryInfo: data
  //       });
  //       console.log(data);
  //     },
  //     (err) => {
  //       console.log(err);
  //     }
  //   );
  // }

  //获取手机验证码
  enterpriseCompanySendLegalAuthCode = () => {
    const phone = this.props.form.getFieldValue('legalRepPhone');
    bcx_utils.preventRepeatAsync(callback =>
      callback(resolve => {
        enterpriseCompanySendLegalAuthCode({ t: '', sign: '', phone }).then(
          data => {
            resolve(false);
          },
          err => {
            console.log(err);
            resolve(false);
          }
        );
      })
    );
  };

  //手机验证===验证验证码，检查手机验证码和企业ID是否匹配，10分钟后验证码过期
  enterpriseComAuthInfoCheckLegalAuthCode = resolve => {
    const phone = this.props.form.getFieldValue('legalRepPhone');
    const code = this.props.form.getFieldValue('code');
    enterpriseComAuthInfoCheckLegalAuthCode({ phone, code }).then(
      data => {
        resolve(true);
      },
      err => {
        console.log(err);
        // message.error(err.msg);
        resolve(false);
      }
    );
  };

  /******************************相关事件******************************/
  /****
   * 特殊字段
   */
  showSpecialFields = () => {
    const arr = this.state.specialArray.map((value, index) => {
      return (
        <div key={index}>
          {this.renderMap(
            value.fieldType,
            value.fieldName,
            value.fieldCode,
            parseInt(value.isRequired, 10),
            value.fieldValue,
            value.maxLength,
            value.fieldOptions,
            value.scriptFunction,
            value.isEdit
          )}
        </div>
      );
    });
    return arr;
  };

  renderMap = (
    fieldType,
    fieldName,
    fieldCode,
    isRequired,
    fieldValue,
    maxLength,
    fieldOptions,
    scriptFunction,
    isEdit
  ) => {
    // const formItemLayout = {
    //   labelCol: {
    //     xs: {
    //       span: 24
    //     },
    //     sm: {
    //       span: 7
    //     }
    //   },
    //   wrapperCol: {
    //     xs: {
    //       span: 24
    //     },
    //     sm: {
    //       span: 12
    //     },
    //     md: {
    //       span: 10
    //     }
    //   }
    // };
    const { getFieldDecorator } = this.props.form;
    const disabled = isEdit == 0;
    if (fieldType === '1') {
      return (
        <FormItem {...formItemLayout} label={fieldName}>
          {getFieldDecorator(`${fieldCode}`, {
            initialValue: fieldValue || '',
            rules: [
              {
                required: isRequired,
                message: `请输入${fieldName}`
              }
            ]
          })(<Input 
          disabled={disabled} 
          placeholder="请输入" maxLength={maxLength} />)}
        </FormItem>
      );
    } else if (fieldType === '2') {
      let max;
      if (maxLength) {
        max = Number(1 + new Array(parseInt(maxLength, 10) + 1).join('0')) - 1;
      } else {
        max = 999999;
      }
      return (
        <FormItem {...formItemLayout} label={fieldName}>
          {getFieldDecorator(`${fieldCode}`, {
            initialValue: fieldValue || '',
            rules: [
              {
                required: isRequired,
                message: `请输入${fieldName}`
              }
            ]
          })(<InputNumber 
          disabled={disabled} 
          min={1} max={max} maxLength={maxLength} />)}
        </FormItem>
      );
    } else if (fieldType === '3') {
      return (
        <FormItem {...formItemLayout} label={fieldName}>
          {getFieldDecorator(`${fieldCode}`, {
            initialValue: fieldValue ? moment(fieldValue, dateFormat) : null,
            rules: [
              {
                required: isRequired,
                message: `请选择${fieldName}`
              },
              {
                validator: (rule, value, callback) => {
                  const moment = require('moment');
                  scriptFunction
                    ? eval(`${scriptFunction}`)(rule, value, callback)
                    : callback();
                }
              }
            ]
          })(<DatePicker disabled={disabled} placeholder="请选择" style={{ width: '100%' }} />)}
        </FormItem>
      );
    } else if (fieldType === '4') {
      return (
        <FormItem {...formItemLayout} label={fieldName}>
          {getFieldDecorator(`${fieldCode}`, {
            initialValue: fieldValue || '',
            rules: [
              {
                required: isRequired,
                message: `请选择${fieldName}`
              }
            ]
          })(
            <Select disabled={disabled} placeholder="请选择" className="sls-style">
              {/* <Option value=" ">请选择</Option> */}
              {fieldOptions.map((val, i) => {
                return (
                  <Option key={i} value={val.split(':')[0] + ''}>
                    {val.split(':')[1]}
                  </Option>
                );
              })}
            </Select>
          )}
        </FormItem>
      );
    } else if (fieldType === '5') {
      return (
        <FormItem {...formItemLayout} label={fieldName}>
          {getFieldDecorator(`${fieldCode}`, {
            initialValue: fieldValue || '',
            rules: [
              {
                required: isRequired,
                message: `请选择${fieldName}`
              }
            ]
          })(
            <Select
              mode="multiple"
              disabled={disabled}
              style={{ width: '100%' }}
              placeholder="请选择"
            >
              {fieldOptions.map((val, i) => {
                return (
                  <Option key={i} value={val.split(':')[0] + ''}>
                    {val.split(':')[1]}
                  </Option>
                );
              })}
            </Select>
          )}
        </FormItem>
      );
    } else if (fieldType === '8') {
      return (
        <FormItem {...formItemLayout} label={fieldName}>
          {getFieldDecorator(`${fieldCode}`, {
            initialValue: fieldValue || '',
            rules: [
              {
                required: isRequired,
                message: `请选择${fieldName}`
              }
            ]
          })(<PFromUpload disabled={disabled} num={1} />)}
          <span>每张不超过:8M,格式为:jpg，jpeg，png</span>
        </FormItem>
      );
    } else if (fieldType === '9') {
      return (
        <FormItem {...formItemLayout} label={fieldName}>
          {getFieldDecorator(`${fieldCode}`, {
            initialValue: fieldValue ? moment(fieldValue, dateFormat) : null,
            rules: [
              {
                required: isRequired,
                message: `请选择${fieldName}`
              }
            ]
          })(<DatePicker disabled={disabled} placeholder="请选择" style={{ width: '100%' }} />)}
        </FormItem>
      );
    } else if (fieldType === '10') {
      return (
        <FormItem {...formItemLayout} label={fieldName}>
          {getFieldDecorator(`${fieldCode}`, {
            initialValue: fieldValue || '',
            rules: [
              {
                // required: isRequired, message: `请选择${fieldName}`,
                required: isRequired,
                message: `请输入${fieldName}`
              }
            ]
          })(
            // <TextArea rows={3} placeholder="请填写公司注册详细地址" maxLength={maxLength} />
            <TextArea
              rows={3}
              disabled={disabled}
              placeholder={`请输入${fieldName}`}
              maxLength={maxLength}
            />
          )}
        </FormItem>
      );
    }
  };

  /*********上传 */
  handleCancel = () => this.setState({ previewVisible: false });
  handlePreview = file => {
    this.setState({
      previewImage: file.url || file.thumbUrl,
      previewVisible: true
    });
  };
  handleChange = ({ fileList }) => this.setState({ fileList });

  //表单提交
  handleSubmit = e => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      //特殊字段日期类型处理
      Object.keys(values).forEach(key => {
        if (
          key.slice(0, 4) === 'conf' &&
          (key.slice(-4) === 'Date' || key.slice(-4) === 'date')
        ) {
          values[key] = values[key] ? values[key].format('YYYY-MM-DD') : null;
        }
      });
      if (!err) {
        $nModal({
          title: '请准确核对信息',
          okText: "确认无误，提交",
          cancelText: '返回修改',
          content: <div style={{color:'orange'}}>
            法定代表人、注册资金、经营范围/培训内容信息提交后，企业将无法自信修改。只能通过公安备案许可服务，由公安审核通过后进行更新，请准确核对信息，确认无误后再提交。
          </div>,
          onOk: close => {
            close();
            systemComVaseInfoGet({}).then(
              response => {
                this.props.dispatch({
                  type: 'global/companyInfo',
                  payload: response.data
                });
              },
              err => {
                console.log(err, 'systemComVaseInfoGet-err-获取企业详情');
              }
            );
            this.companyUpdate(values);
          }
        });
        // let _this = this;
        // this.validCode = false; //防止重复验证

        // const ajaxValid = () => {
        //   return new Promise(resolve => {
        //     _this.validCode = true;
        //     _this.enterpriseComAuthInfoCheckLegalAuthCode(resolve);
        //   });
        // };

        // async function ajaxValidCode() {
        //   let ifValid = await ajaxValid();
        //   if (ifValid) {
        //     //修改企业认证信息
        //     _this.companyUpdate(values);
        //   }
        // }

        // if (this.validCode === false) {
        //   ajaxValidCode();
        // }

        // systemComVaseInfoGet-response-更新企业详情
        
      }
    });
  };

  //修改企业认证信息
  companyUpdate = values => {
    // const { fixedAssets, annualTurnover, annualProfitTax } = this.state.infos;
    // const ajax = {
    //   nationality: values.nationality,
    //   legalRepName: values.legalRepName,
    //   legalRepPhone: values.legalRepPhone,
    //   idCardType: values.idCardType,
    //   idCardNo: values.idCardNo,
    //   regAmount: values.regAmount,
    //   comCerType: values.comCerType,
    //   comCerNo: values.comCerNo,
    //   comCerUrl: values.comCerUrl,
    //   fixedAssets: values.fixedAssets,
    //   annualTurnover: values.annualTurnover,
    //   annualProfitTax: values.annualProfitTax,
    //   // fixedAssets,
    //   // annualTurnover,
    //   // annualProfitTax,
    //   conf_safeRange: values.conf_safeRange,
    //   conf_securityLicenseNum: values.conf_securityLicenseNum,
    //   conf_securityLicenseUrl: values.conf_securityLicenseUrl,
    // }
    const ajax = values;
    bcx_utils.preventRepeatAsync(callback =>
      callback(resolve => {
        //修改企业认证信息
        enterpriseCompanyUpdateComAuthInfo(ajax).then(
          ({ msg }) => {
            // message.success(msg);
            this.props.addStep();
            resolve();
          },
          err => {
            // message.error(err.msg);
            resolve();
          }
        );
      })
    );
  };

  //文件上传事件

  imageChange = (type, result) => {
    this.setState({ [type]: result.join() });
  };

  //发送验证码
  sendCode = () => {
    const { ifSendCode } = this.state;
    const mobile = this.props.form.getFieldValue('legalRepPhone');
    const mobileError = this.props.form.getFieldError('legalRepPhone');
    //判断是否正确的手机号码，然后开始计时
    if (mobile !== undefined && mobileError === undefined) {
      if (ifSendCode) {
        return;
      } else {
        this.setState({ ifSendCode: true });
        this.enterpriseCompanySendLegalAuthCode();
        this.codeTime = window.setInterval(() => {
          const { count } = this.state;
          if (count !== 1) {
            this.setState(preState => ({
              count: preState.count - 1
            }));
          } else {
            clearInterval(this.codeTime);
            this.setState({ ifSendCode: false, count: 60 });
          }
        }, 1000);
      }
    } else {
      bcx_utils.preventRepeat(() => {
        message.error('请输入正确的手机号码', 1.8);
      }, 2000);
    }
  };

  /******************************render******************************/

  //国籍/地区
  renderNationality = () => {
    return this.state.nationality.map(val => (
      <Option value={val.codeValue + ''} key={val.codeValue}>
        {val.label}
      </Option>
    ));
  };

  //证件类型
  renderIdCardType = () => {
    return this.state.idCardType.map(val => (
      <Option value={val.codeValue + ''} key={val.codeValue}>
        {val.label}
      </Option>
    ));
  };

  //证件类型
  renderIdComCerType = () => {
    return this.state.comCerType.map(val => (
      <Option value={val.codeValue + ''} key={val.codeValue}>
        {val.label}
      </Option>
    ));
  };
  //证件类型-号码验证
  checkIdCardNo = (rule, value, callback) => {
    const { form } = this.props;
    const idType = form.getFieldValue('idCardType');
    if (
      idType === '1' &&
      value &&
      !/^(^[1-9]\d{7}((0\d)|(1[0-2]))(([0|1|2]\d)|3[0-1])\d{3}$)|(^[1-9]\d{5}[1-9]\d{3}((0\d)|(1[0-2]))(([0|1|2]\d)|3[0-1])((\d{4})|\d{3}[Xx])$)$/.test(
        value
      )
    ) {
      callback('请输入正确的身份证号码！');
    } else {
      callback();
    }
  };
  //安保范围
  renderSecurityRange = () => {
    return this.state.conf_safeRange.map(val => (
      <Option value={val.codeValue + ''} key={val.codeValue}>
        {val.label}
      </Option>
    ));
  };

  //验证码
  renderValidButton = () => {
    const { ifSendCode, count } = this.state;
    if (ifSendCode) {
      return (
        <Button type="primary" disabled={ifSendCode}>
          {`${count} s`}
        </Button>
      );
    } else {
      return (
        <Button type="primary" className="getCaptcha" onClick={this.sendCode}>
          {'验证码'}
        </Button>
      );
    }
  };

  checkJiShuMore = (rule, value, callback) => {
    if (
      value &&
      !/^-?(([0-9][0-9]{0,9})|(([0]\.\d{1,4}|[1-9][0-9]{0,9}\.\d{1,4})))$/.test(
        value
      )
    ) {
      callback('最多输入10位整数，并且小数点后面最多输入4位！');
    } else {
      callback();
    }
  };

  render() {
    /*********上传 */
    const { previewVisible, previewImage, fileList } = this.state;
    const { getFieldDecorator,getFieldValue } = this.props.form;

    const uploadButton = (
      <div>
        <Icon type="plus" />
        <div className="ant-upload-text">上传</div>
      </div>
    );

    // const formItemLayout = {
    //   labelCol: {
    //     xs: { span: 6 },
    //     sm: { span: 6 },
    //   },
    //   wrapperCol: {
    //     xs: { span: 12 },
    //     sm: { span: 12 },
    //   },
    // };
    const {
      legalRepName = '',
      legalRepPhone = '',
      nationality = '',
      idCardType = '',
      idCardNo = '',
      regAmount = '',
      comCerType = '',
      comCerNo = '',
      comCerUrl = '',
      fixedAssets = '',
      annualTurnover = '',
      annualProfitTax = ''
    } = this.state.infos;

    const { showIndustry } = this.state;
    // const { industryInfo, showIndustry } = this.state;

    // //保安服务许可证号
    // const findsecurityLicenseNum = () => {
    //   const result = industryInfo.find(val => val.fieldCode.trim() === "conf_securityLicenseNum");
    //   if (!result) {
    //     return "";
    //   } else {
    //     return result.fieldValue;
    //   }
    // }
    // //安保范围
    // const findRange = () => {
    //   const result = industryInfo.find(val => val.fieldCode.trim() === "conf_safeRange");
    //   if (!result) {
    //     return [];
    //   }
    //   if (result.fieldValue == "") {
    //     return [];
    //   }
    //   return result.fieldValue.split(',');
    // }
    // //上传保安服务许可证
    // const findSecurityLicenseUrl = () => {
    //   const result = industryInfo.find(val => val.fieldCode.trim() === "conf_securityLicenseUrl");
    //   if (!result) {
    //     return "";
    //   } else {
    //     return result.fieldValue;
    //   }
    // }

    return (
      <Container>
        <header className="password-header">完善企业认证信息</header>
        {Object.keys(this.state.infos).length !== 0 && (
          <Form onSubmit={this.handleSubmit} style={{ marginTop: 24 }}>
            <Row>
              <Col span={6} className="authentication-sub-title">
                <span>法定代表人信息</span>
              </Col>
            </Row>
            <FormItem {...formItemLayout} label="法人代表人" extra={<span style={{color:'red'}}>注：分公司请填写分公司负责人信息。</span>}>
              {getFieldDecorator('legalRepName', {
                initialValue: legalRepName,
                rules: [
                  {
                    required: true,
                    message: '请输入法人代表人'
                  },
                  {
                    pattern: /^[\u4e00-\u9fa5]+$/,
                    message: '请输入负责人，中文'
                  }
                ]
              })(<Input placeholder="请输入" maxLength={10} />)}
            </FormItem>
            <FormItem {...formItemLayout} label="手机号码">
              {getFieldDecorator('legalRepPhone', {
                initialValue: legalRepPhone,
                rules: [
                  {
                    required: true,
                    message: '请输入手机号码'
                  },
                  {
                    pattern: /^1[0-9]{10}$/,
                    message: '手机号格式错误！'
                  }
                ]
              })(<Input placeholder="请输入" maxLength={11} />)}
            </FormItem>

            {/* <FormItem {...formItemLayout} label="验证码">
              <div style={{ display: 'flex', marginTop: 5 }}>
                {getFieldDecorator('code', {
                  rules: [{
                    pattern: /^[0-9]{6}$/, message: '请输入正确验证码!',
                  }, {
                    required: true, message: '请输入验证码！',
                  }],
                })(
                  <Input placeholder="请输入" maxLength={6} />
                )}
                <div style={{ width: 20, height: "100%" }}></div>
                {this.renderValidButton()}
              </div>
            </FormItem> */}

            <FormItem {...formItemLayout} label="国籍/地区">
              {getFieldDecorator('nationality', {
                initialValue: nationality,
                rules: [
                  {
                    required: true,
                    message: '请输入国籍/地区'
                  }
                ]
              })(
                <Select placeholder="请选择">{this.renderNationality()}</Select>
              )}
            </FormItem>
            <FormItem {...formItemLayout} label="证件类型">
              {getFieldDecorator('idCardType', {
                initialValue: idCardType,
                rules: [
                  {
                    required: true,
                    message: '请输入证件类型'
                  }
                ]
              })(
                <Select placeholder="请选择">{this.renderIdCardType()}</Select>
              )}
            </FormItem>
            <FormItem {...formItemLayout} label="证件号码">
              {getFieldDecorator('idCardNo', {
                initialValue: idCardNo,
                rules: [
                  {
                    required: true,
                    message: '请输入证件号码'
                  },
                  {
                    validator: this.checkIdCardNo
                  }
                ]
              })(<Input placeholder="请输入" maxLength={18} />)}
            </FormItem>
            <Row>
              <Col span={6} className="authentication-sub-title">
                <span>工商注册信息</span>
                <span style={{marginLeft: 15, color: 'rgb(255, 102, 0)'}}>若为分/子公司，请填写分/子公司的工商注册信息</span>
              </Col>
            </Row>
            {
              this.props.companyInfo.institutionType != '0104' && 
              <FormItem {...formItemLayout} label="注册资金(万元)" extra={parseInt(getFieldValue('regAmount'))>999999&&<span style={{color:'#faad14'}}>本字段单位为“万元”，请确认输入是否正确</span>}>
                {getFieldDecorator('regAmount', {
                  initialValue: regAmount,
                  rules: [
                    {
                      validator: this.checkJiShuMore
                    },
                    {
                      required: true,
                      message: '请输入注册资金'
                    }
                    // {
                    //   pattern: /(^([1-9][0-9]{1,5}|0)(\.\d{1,4})*$)/,
                    //   message: '请以数字填写注册资金，例如：20000.0000万元（最大填写数字：999999.9999万元）',
                    // }
                  ]
                })(<Input placeholder="请输入" maxLength={15} />)}
              </FormItem>
            }
            {
              this.props.companyInfo.institutionType != '0104' &&
              <FormItem {...formItemLayout} label="固定资产（万元）" extra={parseInt(getFieldValue('fixedAssets'))>999999&&<span style={{color:'#faad14'}}>本字段单位为“万元”，请确认输入是否正确</span>}>
                {getFieldDecorator('fixedAssets', {
                  initialValue: fixedAssets,
                  rules: [
                    {
                      validator: this.checkJiShuMore
                    },
                    {
                      required: true,
                      message:'请输入固定资产'
                    }
                  ]
                })(<Input placeholder="请输入" maxLength={15} />)}
              </FormItem>
            }

            {
              this.props.companyInfo.institutionType != '0104' &&
              <FormItem {...formItemLayout} label="年营业额（万元）" extra={parseInt(getFieldValue('annualTurnover'))>999999&&<span style={{color:'#faad14'}}>本字段单位为“万元”，请确认输入是否正确</span>}>
                {getFieldDecorator('annualTurnover', {
                  initialValue: annualTurnover,
                  rules: [
                    {
                      validator: this.checkJiShuMore
                    },
                    {
                      required: true,
                      message:'请输入年营业额'
                    }
                  ]
                })(<Input placeholder="请输入" maxLength={15} />)}
              </FormItem>
            }
            {
              this.props.companyInfo.institutionType != '0104' && 
              <FormItem {...formItemLayout} label="年利税（万元）" extra={parseInt(getFieldValue('annualProfitTax'))>999999&&<span style={{color:'#faad14'}}>本字段单位为“万元”，请确认输入是否正确</span>}>
                {getFieldDecorator('annualProfitTax', {
                  initialValue: annualProfitTax,
                  rules: [
                    {
                      validator: this.checkJiShuMore
                    },
                    {
                      required: true,
                      message:'请输入年利税'
                    }
                  ]
                })(<Input placeholder="请输入" maxLength={15} />)}
              </FormItem>
            }
            <FormItem {...formItemLayout} label="证件类型">
              {getFieldDecorator('comCerType', {
                initialValue: comCerType,
                rules: [
                  {
                    required: true,
                    message: '请输入证件类型'
                  }
                ]
              })(
                <Select placeholder="请选择">
                  {this.renderIdComCerType()}
                </Select>
              )}
            </FormItem>
            <FormItem {...formItemLayout} label="证件号">
              {getFieldDecorator('comCerNo', {
                initialValue: comCerNo,
                rules: [
                  {
                    required: true,
                    message: '请输入证件号'
                  },
                  {
                    pattern: /[0-9]/,
                    message: '证件格式错误'
                  }
                ]
              })(<Input placeholder="请输入" maxLength={18} />)}
            </FormItem>

            <FormItem {...formItemLayout} label="上传证件扫描件">
              <div className="clearfix">
                {getFieldDecorator('comCerUrl', {
                  initialValue: comCerUrl,
                  rules: [
                    {
                      required: true,
                      message: '请上传证件扫描件'
                    }
                  ]
                })(<PFromUpload num={1} />)}

                <p>每张不超过:8M,格式为:jpg，jpeg，png</p>
                {/*<p style={{color: "#f5222d"}}>请上传附件</p>*/}
              </div>
            </FormItem>
            {showIndustry && (
              <div>
                <Row>
                  <Col span={6} className="authentication-sub-title">
                    <span>资质信息</span>
                  </Col>
                </Row>
                {this.showSpecialFields()}
                {/* <FormItem {...formItemLayout} label="安保范围"
                >
                  {getFieldDecorator('conf_safeRange', {
                    initialValue: findRange(),
                    rules: [{
                      required: true, message: '请输入安保范围',
                    }],
                  })(
                    <Select
                      placeholder="请选择"
                      mode="multiple"
                      style={{ width: '100%' }}
                    >
                      {this.renderSecurityRange()}
                    </Select>
                  )}
                </FormItem>
                <FormItem {...formItemLayout} label="保安服务许可证号"
                >
                  {getFieldDecorator('conf_securityLicenseNum', {
                    initialValue: findsecurityLicenseNum(),
                    rules: [{
                      required: true, message: '请输入保安服务许可证号',
                    }],
                  })(
                    <Input placeholder="请填写" maxLength={20} />
                  )}
                </FormItem>

                <FormItem {...formItemLayout} label="上传保安服务许可证"
                >
                  <div className="clearfix">
                    {getFieldDecorator('conf_securityLicenseUrl', {
                      initialValue: findSecurityLicenseUrl(),
                      rules: [{
                        required: true, message: '请上传保安服务许可证',
                      }],
                    })(
                      <PFromUpload num={1} />
                    )}
                    <p>每张不超过:8M,格式为:jpg，jpeg，png</p>
                  </div>
                </FormItem> */}
              </div>
            )}
            <FormItem {...formItemLayout} label=" " colon={false}>
              <Button
                style={{ marginRight: '8px' }}
                onClick={() => {
                  this.props.preStep();
                }}
              >
                返回上一步
              </Button>
              <Button className="submit" type="primary" htmlType="submit">
                确定并下一步
              </Button>
            </FormItem>
          </Form>
        )}
      </Container>
    );
  }
}

/*********************样式*************************** */
const Container = style.div`{
  .password-header{
      font-size: 20px;
      color: #333333;
      padding-bottom:16px;
      border-bottom:1px solid #e9e9e9;
  }
  .ant-btn-primary.getCaptcha{
      background-color: #0F71FF;
  }
  .authentication-sub-title{
      text-align:right;
      font-size: 16px;
      color: #333333;
      margin-bottom:24px;
  }
  .ant-upload-select-picture-card i {
    font-size: 32px;
    color: #999;
  }
      
  .ant-upload-select-picture-card .ant-upload-text {
    margin-top: 8px;
    color: #666;
  }
}`;
