import React, { Component } from 'react';
import { Breadcrumb } from 'antd';

export default class InsuranceDetails extends Component {
  constructor(props, context) {
    super(props, context);
    const params = new URLSearchParams(props.location.search);
    this.state = {
      url: decodeURIComponent(params.get('url'))
    };
  }
  render() {
    // console.log(this.props.location.state.url)
    return (
      <div>
        <Breadcrumb
          style={{
            margin: '10px',
            padding: '0px 0px 10px 10px',
            borderBottom: '1px solid #E9E9E9'
          }}
        >
          <Breadcrumb.Item>
            <a
              onClick={() => {
                this.props.history.push(
                  `/insurancemanagement/enterpriseinsurance`
                );
              }}
            >
              保险管理
            </a>
          </Breadcrumb.Item>
          <Breadcrumb.Item>购买在线保险</Breadcrumb.Item>
        </Breadcrumb>
        <iframe
          title="购买在线保险"
          src={this.state.url}
          style={{ height: 'calc(100vh - 225px)' }}
          width="100%"
          frameBorder="0"
          allowFullScreen={true}
          allowtransparency="true"
        >
          您的浏览器不支持iframe，请升级
        </iframe>
      </div>
    );
  }
}
