import React, { Component } from 'react';
import { connect } from 'dva';
import { Tabs, Alert } from 'antd';

import Infomation from './Information';
import Authentication from './Authentication';
import Invoice from './Invoice';
import Insurance from './InsuranceBasic';
import { getCertificationData } from '../../../services/api';

import styles from './Company.less';

const { TabPane } = Tabs;

@connect(state => ({
  profile: state.profile,
  industryType: state.global.companyInfo.industryType
}))
export default class Company extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      status: '0' //认证是否通过
    };
  }

  componentDidMount() {
    // fakeChartData1().then((data) => {
    //   console.log(data);
    // });
    /* const { dispatch } = this.props;
    dispatch({
      type: 'profile/fetchBasic',
    }); */
    // console.log('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>',this.child);
    // getCertificationData({}).then((data) => {
    //   console.log('公司状态公司状态公司状态' + data);
    //   if (data.data) {
    //     console.log('123' + JSON.stringify(data.data));
    //     this.setState({
    //       status: data.data.authStatus,
    //     });
    //   }
    // });
  }

  handleSubmit = e => {
    e.preventDefault();
    this.props.form.validateFieldsAndScroll((err, values) => {
      if (!err) {
        this.props.dispatch({
          type: 'form/submitRegularForm',
          payload: values
        });
      }
    });
  };
  callback = key => {
    console.log(key);
    this.setState({ status: '0' });
  };

  changeStatus = () => {
    this.setState({ status: '1' });
  };
  goToDeclare = () => {
    this.props.history.push('/PoliceDeclare/DeclarationList');
  }

  render() {
    let showStatus = '认证信息';
    // if (this.state.status === '0') {
    //   showStatus = (
    //     <div>认证申请<em className={styles.red}>(未认证)</em></div>
    //   );
    // } else if (this.state.status === '1') {
    //   showStatus = (
    //     <div>认证申请<em className={styles.red}>(认证中)</em></div>
    //   );
    // } else if (this.state.status === '2') {
    //   showStatus = (
    //     <div>认证申请<em className={styles.green}>(已认证)</em></div>
    //   );
    // } else if (this.state.status === '3') {
    //   showStatus = (
    //     <div>认证申请<em className={styles.red}>(认证不通过)</em></div>
    //   );
    // }else if(this.state.status === ''){
    //   showStatus = (
    //     <div>认证申请<em className={styles.red}>(未认证)</em></div>
    //   );
    // }
    // console.log("xxxxxxxxxxxxxx",showStatus);

    const tips = (
      <Alert
        message={
          <div>
            <div>
              部分企业信息无法直接修改，若您需要修改的，请到
              <span style={{ color: '#40a9ff', cursor: 'pointer' }} onClick={this.goToDeclare}>【备案许可申报】</span>页面，选择
              <span style={{ color: '#f90' }}>
                保安服务（培训）许可证项目变更审核
              </span>
              进行变更。
            </div>
          </div>
        }
        type="warning"
        showIcon
        style={{ marginBottom: '15px' }}
      />
    );

    return (
      <div className={styles.Company} style={{ padding: '10px 24px 24px' }}>
        <Tabs defaultActiveKey="1">
          <TabPane tab="基础信息" key="1">
            {this.props.industryType === '01' && tips}
            <Infomation />
          </TabPane>
          <TabPane tab={showStatus} key="2">
            {this.props.industryType === '01' && tips}
            <Authentication changeStatus={this.changeStatus} />
          </TabPane>
          {/* <TabPane tab={<div>发票管理<em className={styles.green}>(已完善)</em></div>} key="3"> */}
          {this.props.industryType !== '02' ? (
            <TabPane tab={<div>发票管理</div>} key="3">
              {this.props.industryType === '01' && tips}
              <Invoice />
            </TabPane>
          ) : null}
          {/* <TabPane tab="企业保险" key="4">
            <Insurance props={this.props} styles={styles}/>
          </TabPane> */}
        </Tabs>
      </div>
    );
  }
}
