/**
 * @author  Xyz
 * 分公司管理层变更记录
 */
import React from 'react';
import moment from 'moment';
import {
  DatePicker,
  Button,
  Table
} from 'antd';
import {
  SearchItem,
  Options
} from "./styles";
import PTable from '../../../components/Pro/PTable';


export default class TabManage extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      pageParm: {
        pageSize: '10',//缴交情况
        pageNumber: "1",
        startDate: "",
        endDate: ""
      },
      forceUpdate: false,
    }
  }

  /******************************生命周期******************************/

  componentDidMount = () => {
  }

  /******************************ajax请求******************************/


  /******************************相关事件******************************/
  onDateChange = (date, [startDate, endDate]) => {
    const {pageParm} = this.state;
    pageParm.startDate = startDate;
    pageParm.endDate = endDate;
    this.setState({pageParm});
  }

  search = () => {
    this.setState({forceUpdate: true}, () => {
      this.setState({forceUpdate: false});
    });
  }

  resetSearch = () => {
    const pageParm = {
      pageSize: '10',//缴交情况
      pageNumber: "1",
      startDate: "",
      endDate: ""
    }
    this.setState({pageParm});
  }
  /******************************render******************************/
  renderTable = () => {

    const columns1 = [
      {
        title: '变更日期',
        dataIndex: 'changeDate',
        key: 'changeDate',
        render: text => text.slice(0, 10),
      },
      {
        title: '变更前管理人员/身份证号',
        dataIndex: 'oldManagerIdCardNo',
        key: 'oldManagerIdCardNo',
      },
      {
        title: '变更后管理人员/身份证号',
        dataIndex: 'newManagerIdCardNo',
        key: 'newManagerIdCardNo',
      },
      {
        title: '职位',
        dataIndex: 'positionName',
        key: 'positionName',
      },
    ];
    return (
      <PTable
        pageParm={this.state.pageParm}
        url="enterpriseComManagerListBranchRecord"
        columns={columns1}
        forceUpdate={this.state.forceUpdate}
      />
    );
  }

  render() {
    const {startDate, endDate} = this.state.pageParm;
    const format = "YYYY-MM-DD";
    const dateValue = startDate == "" ? "" : [moment(startDate, format), moment(endDate, format)];
    return (
      <div>
        <SearchItem marginBottom="16">
          变更日期：
          <DatePicker.RangePicker
            style={{width: 214, marginRight: 16}}
            onChange={this.onDateChange}
            value={dateValue}
          />
          <Button className="btn" type="primary" onClick={this.search}>搜索</Button>
          <Button onClick={this.resetSearch}>重置</Button>
        </SearchItem>
        {this.renderTable()}
      </div>
    );
  }
}

