/**
 * @author  Xyz
 * 分公司管理层
 */
import React from 'react';

import {
  Alert,
  Table,
} from 'antd';
import {
  Options,
} from "./styles";

import DrawBranchTab from './DrawBranchTab';//分公司详情
import PTable from '../../../components/Pro/PTable';


export default class TabManage extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      visible: false,
      pageParm: {
        pageSize: '10',//缴交情况
        pageNumber: "1"
      },
      comManagerId: ""
    }
  }

  /******************************生命周期******************************/

  componentDidMount = () => {
  }


  /******************************ajax请求******************************/


  /******************************相关事件******************************/

    //查看详情
  viewDetail = (comManagerId) => {
    this.setState({
      visible: true,
      comManagerId
    });
  }
  closeDrawer = () => {
    this.setState({visible: false});
  }

  /******************************render******************************/
  renderTable = () => {


    const columns1 = [
      {
        title: '姓名',
        dataIndex: 'name',
        key: 'name',
      },
      {
        title: '性别',
        dataIndex: 'sex',
        key: 'sex',
      },
      {
        title: '证件类型',
        dataIndex: 'address',
        key: 'address',
      },
      {
        title: '证件号',
        dataIndex: 'idCardNo',
        key: 'idCardNo',
      },
      {
        title: '职务',
        dataIndex: 'positionName',
        key: 'positionName',
      },
      {
        title: '联系方式',
        dataIndex: 'telephone',
        key: 'telephone',
      },
      {
        title: '操作',
        key: 'action',
        render: (text, {comManagerId = ""}) => (
          <Options>
            <span onClick={this.viewDetail.bind(this, comManagerId)}>查看</span>
          </Options>
        ),
      }
    ];
    return (
      <PTable
        pageParm={this.state.pageParm}
        url="enterpriseComManagerListBranchComManager"
        columns={columns1}/>
    );
  }

  render() {
    const {visible, comManagerId} = this.state;
    return (
      <div>
        <Alert
          message="[分公司名称]管理层信息，由[分公司名称]录入及修改。当前仅支持总公司查看分公司管理层信息"
          type="warning"
          style={{marginBottom: 16}}
          showIcon/>
        {this.renderTable()}

        <DrawBranchTab
          visible={visible}
          closeDrawer={this.closeDrawer}
          comManagerId={comManagerId}
        />
      </div>
    );
  }
}

