/**
 * @author  Xyz
 * 分公司管理
 */
import React from 'react';
import {
  Form,
  Input,
  Button,
  message,
  Table,
  Alert,
  Modal,
  Tabs
} from 'antd';
import {
  Container,
  SearchItem,
  Options,
} from "./styles";
import PTable from '../../../components/Pro/PTable';

import {AddCompanyTip} from './components';
import DrawChildCompanyBasic from './DrawChildCompanyBasic';//分公司详情
import DrawChildCompanyIdentification from './DrawChildCompanyIdentification';//分公司详情

const FormItem = Form.Item;
const { TabPane } = Tabs;
@Form.create()
export default class ChildCompanyManager extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      isBasicOpen: false,
      isIdentificationOpen: false,
      pageParm: {
        pageSize: '10',//缴交情况
        pageNumber: "1",
        keyWord: "",
      },
      forceUpdate: false,
      comId: ""
    }
  }

  /******************************生命周期******************************/

  componentDidMount = () => {

  }

  /******************************ajax请求******************************/


  /******************************相关事件******************************/

  addCompany = () => {
    this.setState({isBasicOpen: true});
  }
  //查看基础信息 item
  basicInfoOpen = (record) => {
    this.setState({
      isBasicOpen: true,
      comId: record["comBranchId"]
    });
  }
  //查看认证信息
  indetificationOpen = (record) => {
    this.setState({
      isIdentificationOpen: true,
      comId: record["comBranchId"]
    });
    console.log("传入 draw id ", record["comBranchId"]);
  }

  closeBasicDrawer = () => {
    this.setState({isBasicOpen: false});
  }

  closeIdentDrawer = () => {
    this.setState({isIdentificationOpen: false});
  }

  //删除提示框
  deleteConfirm = () => {
    Modal.confirm({
      title: '删除后将无法查看子公司信息，是否确认删除？',
      okText: '确定',
      cancelText: '取消',
      onOk: () => {
        console.log('OK');
      },
      onCancel: () => {
        console.log('Cancel');
      },
    });
  }
  search = () => {
    this.setState({forceUpdate: true}, () => {
      this.setState({forceUpdate: false});
    });
  }

  resetSearch = () => {
    const pageParm = {
      pageSize: '10',//缴交情况
      pageNumber: "1",
      keyWord: "",
    }
    this.setState({pageParm});
  }

  inputChange = (e) => {
    const pageParm = this.state.pageParm;
    pageParm.keyWord = e.target.value;
    this.setState({pageParm});
  }

  /******************************render******************************/
  renderTable = () => {

    const columns1 = [
      {
        title: '子公司名称',
        dataIndex: 'comName',
        key: 'comName',
      },
      {
        title: '统一社会信用代码',
        dataIndex: 'comCerNo',
        key: 'comCerNo',
      },
      {
        title: '法定代表人',
        dataIndex: 'legalRepName',
        key: 'legalRepName',
      },
      {
        title: '法人手机',
        dataIndex: 'legalRepPhone',
        key: 'legalRepPhone',
      },
      {
        title: '注册地址',
        dataIndex: 'regAddress',
        key: 'regAddress',
      },
      {
        title: '操作',
        key: 'action',
        render: (text, record) => (
          <Options>
            <span onClick={this.basicInfoOpen.bind(this, record)}>基础信息</span>
            <span onClick={this.indetificationOpen.bind(this, record)}>认证信息</span>
            {/* <span onClick={this.deleteConfirm}>删除</span> */}
          </Options>
        ),
      }
    ];
    return (
      <PTable
        url="enterpriseCompanyComBaseInfoGetBranchCom"
        pageParm={this.state.pageParm}
        columns={columns1}
        forceUpdate={this.state.forceUpdate}
      />
    );
  }

  render() {
    const {isBasicOpen, isIdentificationOpen, pageParm: {keyWord}} = this.state;
    return (
      <Container>
        <Tabs defaultActiveKey="1" >
          <TabPane tab="子公司管理" key="1" >
              <Alert
                message="子公司独立注册并填写总公司信息后，自动关联到当前企业。如有疑问请联系客服：400-662-9696。"
                type="warning"
                style={{marginBottom: 16}}
                showIcon/>
              <SearchItem marginBottom="16">
                关键字：
                <Input className="input" placeholder="请输入法定代表人/手机号" onChange={this.inputChange} value={keyWord}/>
                <Button className="btn" type="primary" onClick={this.search}>搜索</Button>
                <Button onClick={this.resetSearch}>重置</Button>
              </SearchItem>

              {this.renderTable()}

              <DrawChildCompanyBasic
                visible={isBasicOpen}
                closeDrawer={this.closeBasicDrawer}
                comId={this.state.comId}
              />
              <DrawChildCompanyIdentification
                visible={isIdentificationOpen}
                closeDrawer={this.closeIdentDrawer}
                comId={this.state.comId}
              />
          </TabPane>
        </Tabs>
      </Container>
    );
  }
}


