/**
 * 详细信息
 */
import React, { Component } from 'react';
import {
  systemPerBaseInfoGetPerBaseInfo,
  publicCommonDictGetDictByCodeTypes
} from '../../../../services/api';
import {
  Form,
  Input,
  Radio,
  DatePicker,
  Cascader,
  Select,
  Button,
  Tooltip,
  InputNumber
} from 'antd';
import moment from 'moment';
const FormItem = Form.Item;
const { Option } = Select;
const RadioGroup = Radio.Group;
const { TextArea } = Input;
const formItemLayout = {
  labelCol: {
    xs: { span: 12 },
    sm: { span: 6 }
  },
  wrapperCol: {
    xs: { span: 12 },
    sm: { span: 8 }
  }
};
@Form.create()
export default class DetailInfo extends Component {
  constructor(props) {
    super(props);
    this.state = {
      perId: props.perId,
      detailInfo: {},//详细信息数据
      nationList: [], //国籍下拉选择
      educationList: [], //学历下拉选择
      bloodList: [], //血型下拉选择
      nationMoreList: [], //民族下拉选择
      politicalList: [], //政治面貌下拉选择
      maritalList: [], //婚姻下拉选择
      drivingList: [] //驾照下拉选择
    };
  }

  componentDidMount() {
    this._getDetailInfo(this.state.perId);
    this._getAllDictInformation();
  }
  componentWillReceiveProps(nextProps) {
    console.log(nextProps);
    if (nextProps.perId !== this.state.perId) {
      this.setState({
        perId: nextProps.perId
      });
      this._getDetailInfo(nextProps.perId);
    }
  }
  //获取详细信息数据
  _getDetailInfo(perId) {
    systemPerBaseInfoGetPerBaseInfo({ perId }).then(res => {
      console.log(res);
      if (res.retType === '0') {
        this.setState({
          detailInfo: res.data
        });
      }
    });
  }
  //一次性获取所有字典数据
  _getAllDictInformation = () => {
    publicCommonDictGetDictByCodeTypes({
      codeTypes:
        'nationality,education,bloodType,nation,politicalStatus,maritalStatus,drivingLicenseLevel'
    }).then(
      data => {
        console.log(data);
        //判断获取数据是否为空
        if (data.data) {
          this.setState({
            nationList: data.data.nationality, //国籍下拉选择
            educationList: data.data.education, //学历下拉选择
            bloodList: data.data.bloodType, //血型下拉选择
            nationMoreList: data.data.nation, //民族下拉选择
            politicalList: data.data.politicalStatus, //政治面貌下拉选择
            maritalList: data.data.maritalStatus, //婚姻下拉选择
            drivingList: data.data.drivingLicenseLevel //驾照下拉选择
          });
        }
      },
      err => {
        console.log(err);
      }
    );
  };

  render() {
    const { getFieldDecorator } = this.props.form;

    return (
      <div className="map-per-detail" >
        <Form style={{height:'600px',overflow:'auto'}}>
          <FormItem {...formItemLayout} label="出生日期">
            {getFieldDecorator('birthday', {
              initialValue: moment(
                this.state.detailInfo.birthday,
                'YYYY-MM-DD'
              ),
              // rules: [{ required: true, message: '请选择出生日期!' }]
            })(<DatePicker className="width-400" disabled />)}
          </FormItem>
          <FormItem {...formItemLayout} label="性别">
            {getFieldDecorator('sex', {
              initialValue: this.state.detailInfo.sex,
              // rules: [{ required: false, message: '请选择性别!' }]
            })(
              <RadioGroup disabled>
                <Radio value="1">男</Radio>
                <Radio value="2" style={{ marginLeft: '46px' }}>
                  女
                </Radio>
              </RadioGroup>
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="国籍">
            {getFieldDecorator('nationality', {
              initialValue: this.state.detailInfo.nationality,
              // rules: [{ required: true, message: '请选择国籍!' }]
            })(
              <Select className="width-400" placeholder="请选择" disabled>
                {this.state.nationList.map((val, key) => {
                  return (
                    <Option key={key} value={val.codeValue + ''}>
                      {val.label}
                    </Option>
                  );
                })}
              </Select>
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="籍贯">
            {getFieldDecorator('originPlace', {
              initialValue: this.state.detailInfo.originPlace,
              // rules: [
              //   {
              //     required: false,
              //     message: '请输入籍贯!'
              //   }
              // ]
            })(
              <Input
                className="width-400"
                placeholder="请填写"
                disabled
              />
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="学历">
            {getFieldDecorator('education', {
              initialValue: this.state.detailInfo.education
            })(
              <Select className="width-400" placeholder="请选择" disabled>
                {this.state.educationList.map((val, key) => {
                  return (
                    <Option key={key} value={val.codeValue + ''}>
                      {val.label}
                    </Option>
                  );
                })}
              </Select>
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="身高">
            {getFieldDecorator('height', {
              initialValue: this.state.detailInfo.height,
              rules: [
                {
                  required: false,
                  message: '请输入身高!'
                },
                {
                  validator: this.checkHeight
                }
              ]
            })(
              <Input
                placeholder="请填写"
                addonAfter="CM"
                disabled
              />
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="血型">
            {getFieldDecorator('bloodType', {
              initialValue: this.state.detailInfo.bloodType,
              rules: [{ required: false, message: '请选择血型!' }]
            })(
              <Select className="width-400" placeholder="请选择" disabled>
                {/* {this.bloodList()} */}
                {this.state.bloodList.map((val, key) => {
                  return (
                    <Option key={key} value={val.codeValue + ''}>
                      {val.label}
                    </Option>
                  );
                })}
              </Select>
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="民族">
            {getFieldDecorator('nation', {
              initialValue: this.state.detailInfo.nation,
              // rules: [{ required: false, message: '请选择民族!' }]
            })(
              <Select className="width-400" placeholder="请选择" disabled>
                {this.state.nationMoreList.map((val, key) => {
                  return (
                    <Option key={key} value={val.codeValue + ''}>
                      {val.label}
                    </Option>
                  );
                })}
              </Select>
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="政治面貌">
            {getFieldDecorator('politicalStatus', {
              initialValue: this.state.detailInfo.politicalStatus,
              // rules: [{ required: false, message: '请选择政治面貌!' }]
            })(
              <Select className="width-400" placeholder="请选择" disabled>
                {this.state.politicalList.map((val, key) => {
                  return (
                    <Option key={key} value={val.codeValue + ''}>
                      {val.label}
                    </Option>
                  );
                })}
              </Select>
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="婚姻状况">
            {getFieldDecorator('maritalStatus', {
              initialValue: this.state.detailInfo.maritalStatus,
              // rules: [{ required: false, message: '请选择婚姻状况!' }]
            })(
              <Select className="width-400" placeholder="请选择" disabled>
                {this.state.maritalList.map((val, key) => {
                  return (
                    <Option key={key} value={val.codeValue + ''}>
                      {val.label}
                    </Option>
                  );
                })}
              </Select>
            )}
          </FormItem>
          {this.state.detailInfo.residentProvince !== '' ? (
            <FormItem {...formItemLayout} label="户籍地址">
              {getFieldDecorator('resident', {
                initialValue: [
                  parseInt(this.state.detailInfo.residentProvince),
                  parseInt(this.state.detailInfo.residentCity),
                  parseInt(this.state.detailInfo.residentArea)
                ],
                // rules: [
                //   {
                //     type: 'array',
                //     required: false,
                //     message: '请选择你的户籍地址!'
                //   }
                // ]
              })(
                <Cascader
                  options={this.state.areas}
                  placeholder="请选择"
                  className="width-400"
                  disabled
                />
              )}
            </FormItem>
          ) : (
            <FormItem {...formItemLayout} label="户籍地址">
              {getFieldDecorator('resident', {
                initialValue: ['', '', ''],
                rules: [
                  {
                    type: 'array',
                    required: false,
                    message: '请选择你的户籍地址!'
                  }
                ]
              })(
                <Cascader
                  options={this.state.areas}
                  placeholder="请选择"
                  className="width-400"
                  disabled
                />
              )}
            </FormItem>
          )}
          <FormItem {...formItemLayout} label="详细地址">
            {getFieldDecorator('residenceAddress', {
              initialValue: this.state.detailInfo.residenceAddress,
              rules: [
                {
                  required: false,
                  message: '请输入地址!'
                }
              ]
            })(
              <Input
                className="width-400"
                placeholder="请填写身份证件详细地址"
                disabled
              />
            )}
          </FormItem>
          {this.state.detailInfo.domicileProvince !== '' ? (
            <FormItem {...formItemLayout} label="居住住址">
              {getFieldDecorator('domicile', {
                initialValue: [
                  parseInt(this.state.detailInfo.domicileProvince),
                  parseInt(this.state.detailInfo.domicileCity),
                  parseInt(this.state.detailInfo.domicileArea)
                ],
                rules: [
                  {
                    type: 'array',
                    required: false,
                    message: '请选择你的居住住址!'
                  }
                ]
              })(
                <Cascader
                  options={this.state.areas}
                  placeholder="请选择"
                  className="width-400"
                  disabled
                />
              )}
            </FormItem>
          ) : (
            <FormItem {...formItemLayout} label="居住住址">
              {getFieldDecorator('domicile', {
                initialValue: ['', '', ''],
                // rules: [
                //   {
                //     type: 'array',
                //     required: false,
                //     message: '请选择你的居住住址!'
                //   }
                // ]
              })(
                <Cascader
                  options={this.state.areas}
                  placeholder="请选择"
                  className="width-400"
                  disabled
                />
              )}
            </FormItem>
          )}
          <FormItem {...formItemLayout} label="详细地址">
            {getFieldDecorator('domicileAddress', {
              initialValue: this.state.detailInfo.domicileAddress,
              // rules: [
              //   {
              //     required: false,
              //     message: '请输入地址!'
              //   }
              // ]
            })(
              <Input
                className="width-400"
                placeholder="请填写详细居住地址"
                disabled
              />
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="紧急联系人">
            {getFieldDecorator('contactper', {
              initialValue: this.state.detailInfo.contactper,
              // rules: [
              //   {
              //     required: false,
              //     message: '请输入紧急联系人!'
              //   }
              // ]
            })(
              <Input
                className="width-400"
                placeholder="请填写"
                disabled
              />
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="紧急联系人手机号">
            {getFieldDecorator('contactPhone', {
              initialValue: this.state.detailInfo.contactPhone,
              // rules: [
              //   { required: false, message: '' },
              //   {
              //     validator: this.checkPhone
              //   }
              // ]
            })(
              <Input
                className="width-400"
                placeholder="请填写正确手机号码"
                disabled
              />
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="驾照等级">
            {getFieldDecorator('drivingLicenseLevel', {
              initialValue: this.state.detailInfo.drivingLicenseLevel,
              // rules: [{ required: false, message: '请选择驾照等级!' }]
            })(
              <Select className="width-400" placeholder="请选择" disabled>
                {this.state.drivingList.map((val, key) => {
                  return (
                    <Option key={key} value={val.codeValue + ''}>
                      {val.label}
                    </Option>
                  );
                })}
              </Select>
            )}
          </FormItem>
        </Form>
      </div>
    );
  }
}
