/**
 * 基础信息
 */
import React, { Component } from 'react';
import {
  systemPerBaseInfoGetPerBaseInfo,
  publicCommonDictGetDictByCodeTypes,
  systemComDepartGetDepartTree,
  getPerType,
  systemComRoleFindAllRole
} from '../../../../services/api';
import { Form, Input, Select, DatePicker, TreeSelect } from 'antd';
import moment from 'moment';
const FormItem = Form.Item;
const formItemLayout = {
  labelCol: {
    xs: { span: 12 },
    sm: { span: 6 }
  },
  wrapperCol: {
    xs: { span: 12 },
    sm: { span: 8 }
  }
};
@Form.create()
export default class BaseInfo extends Component {
  constructor(props) {
    super(props);
    console.log(props);
    this.state = {
      perId: props.perId,
      baseInfo: {},
      idCardType: [],
      treeData: [
        //树
        { title: '', key: '' }
      ],
      perTypeList: [], //人员类别
      roldType: [] //角色类别
    };
  }

  componentDidMount() {
    this._getBaseInfo(this.state.perId);
    this._getIdcardType();
    this._getDepartTree();
    this._getResponse();
    this._getRoldList();
  }
  componentWillReceiveProps(nextProps) {
    console.log(nextProps);
    if (nextProps.perId !== this.state.perId) {
      this.setState({
        perId: nextProps.perId
      });
      this._getBaseInfo(nextProps.perId);
    }
  }
  //获取基础信息
  _getBaseInfo(perId) {
    console.log('重新请求');
    systemPerBaseInfoGetPerBaseInfo({ perId }).then(res => {
      if (res.retType === '0') {
        this.setState({
          baseInfo: res.data
        });
      }
    });
  }
  //证件类型
  _getIdcardType() {
    publicCommonDictGetDictByCodeTypes({ codeTypes: 'idCardType' }).then(
      data => {
        console.log(data);
        //判断获取数据是否为空
        if (data.data) {
          this.setState({
            idCardType: data.data.idCardType
          });
        }
      }
    );
  }
  //选择部门
  _getDepartTree = () => {
    const recursion = treeData => {
      // TreeSelect组件所需值： title， value, key, children disabled
      return treeData.map(item => {
        item.title = item.departName;
        item.key = item.departId;
        item.value = item.departId;
        // "isExistsDataAuth": "1",  //权限 1有权限 0：没权限
        item.disabled = item.isExistsDataAuth == 0;
        if (item.childDepart) {
          item.children = recursion(item.childDepart);
        }
        return item;
      });
    };
    // 获取到组织架构列表
    systemComDepartGetDepartTree().then(res => {
      const DATA = recursion(res.data);
      this.setState({
        treeData: DATA,
        departId: DATA[0].key
      });
    });
  };
  //获取人员类别
  _getResponse = () => {
    getPerType({ codeType: 'perType' }).then(
      response => {
        console.log(response);
        if (response.data) {
          this.setState({
            perTypeList: response.data
          });
        }
      },
      err => {
        console.log(err);
      }
    );
  };
  //角色下拉选择
  _getRoldList = () => {
    systemComRoleFindAllRole({}).then(data => {
      console.log('角色下拉选择data:', data);
      //判断获取数据是否为空
      if (data.data) {
        this.setState({
          roldType: data.data
        });
      }
    });
  };
  renderIdCard = () => {
    return this.state.idCardType.map((val, key) => {
      return (
        <Option key={key} value={val.codeValue + ''}>
          {val.label}
        </Option>
      );
    });
  };
  render() {
    const { getFieldDecorator } = this.props.form;

    return (
      <div>
        <Form>
          <FormItem className="head-portrait" {...formItemLayout} label="头像">
            <div className="pic">
              {this.state.baseInfo.photoUrl ? (
                <img
                  src={this.state.baseInfo.photoUrl}
                  alt="avatar"
                  style={{
                    width: '60px',
                    height: '60px',
                    borderRadius: '50%'
                  }}
                />
              ) : (
                <span
                  style={{
                    width: '60px',
                    height: '60px',
                    textAlign: 'center',
                    display: 'inline-block',
                    lineHeight: '58px',
                    color: '#999',
                    borderRadius: '50%',
                    border: '1px solid #999'
                  }}
                >
                  暂无
                </span>
              )}
            </div>
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="人员类别"
            className="fixed-width"
          >
            {getFieldDecorator('perType', {
              initialValue: this.state.baseInfo.perType
            })(
              <Select className="width-400" placeholder="请选择" disabled>
                {/* {this.perTypeList()} */}
                {this.state.perTypeList.map((val, key) => {
                  return (
                    <Option key={key} value={val.codeValue + ''}>
                      {val.label}
                    </Option>
                  );
                })}
              </Select>
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="姓名" className="fixed-width">
            {getFieldDecorator('name', {
              initialValue: this.state.baseInfo.name
            })(<Input className="w-400" placeholder="请输入" disabled />)}
          </FormItem>

          <FormItem
            {...formItemLayout}
            label="证件类型"
            className="document-type lmb-sd"
          >
            {getFieldDecorator('idCardType', {
              initialValue: this.state.baseInfo.idCardType
            })(
              <Select
                placeholder="请选择"
                onChange={this.handleChangeIdCardType}
                disabled
              >
                {this.renderIdCard()}
              </Select>
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="证件号码"
            className="fixed-width certificate-number"
          >
            {getFieldDecorator('idCardNo', {
              initialValue: this.state.baseInfo.idCardNo
            })(
              <Input className="w-400" placeholder="请填写证件号码" disabled />
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="用户名" className="fixed-width">
            {getFieldDecorator('userName', {
              initialValue: this.state.baseInfo.userName,
              rules: [{ required: true }]
            })(
              <Input
                className="w-400"
                placeholder="请输入"
                maxLength={16}
                disabled
              />
            )}
          </FormItem>
          <FormItem {...formItemLayout} label="手机号" className="fixed-width">
            {getFieldDecorator('mobilePhone', {
              initialValue: this.state.baseInfo.mobilePhone
            })(<Input className="w-400 ipt-h" placeholder="请输入" disabled />)}
          </FormItem>
          <FormItem {...formItemLayout} label="邮箱" className="fixed-width">
            {getFieldDecorator('email', {
              initialValue: this.state.baseInfo.email
            })(
              <Input
                className="w-400"
                placeholder="请输入"
                maxLength={50}
                disabled
              />
            )}
          </FormItem>
          {/* <FormItem {...formItemLayout} label="角色" className="fixed-width">
            {getFieldDecorator('roleId', {
              initialValue: this.state.baseInfo.roleId
            })(
              <Select
                mode="multiple"
                placeholder="请选择角色"
                className="w-400 ipt-h"
                disabled
              >
                {this.state.roldType.map((val, key) => {
                  return (
                    <Option key={key} value={val.roleId + ''}>
                      {val.roleName}
                    </Option>
                  );
                })}
              </Select>
            )}
          </FormItem> */}
          <FormItem
            {...formItemLayout}
            label="所属部门"
            className="fixed-width"
          >
            {getFieldDecorator('departId', {
              //   initialValue: this.state.baseInfo.departId
              initialValue: this.state.baseInfo.departName
            })(
              <Input disabled></Input>
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="入职日期"
            className="fixed-width"
          >
            {getFieldDecorator('entryDate', {
              initialValue: this.state.baseInfo.entryDate
                ? moment(this.state.baseInfo.entryDate, 'YYYY-MM-DD')
                : null
            })(<DatePicker className="w-400" disabled />)}
          </FormItem>
        </Form>
      </div>
    );
  }
}
