/**
 * 保安人员的搜索列表
 */
import React, { Component } from 'react';
// import { Pagination, Drawer, Form, Input } from 'antd';
import './attendance.less';
import { getComTaskPerLocation,getComTempTaskPerLocation } from '../../../../services/api';
import { message } from 'antd';

export default class PersonSearchList extends Component {
  constructor(props) {
    super(props);
    this.state = {
      // searchData: {
      //   //搜索数据
      //   pageNumber: 1,
      //   pageSize: 20,
      //   comTempTaskId: props.selectedAttenData.comTempTaskId
      // },
      pageSize: 20,
      comTempTaskId: props.selectedAttenData.comTempTaskId,
      selectedIndex: props.clickAttenPersonIndex || null, //选中哪个列表
      total: 0, //搜索总条数
      selectedAttenData: props.selectedAttenData || null, //传过来选中的驻勤点的信息
      attenPersonList: [], //保安员列表
      height: null //人员列表的最大高度
    };
  }

  componentDidMount() {
    this.getPersonList(this.state.comTempTaskId);
    const height = document.documentElement.clientHeight - 120 - 130 - 160 - 63;
    this.setState({ height });
    console.log(this.props.selectedAttenData)
  }
  componentWillReceiveProps(nextProps) {
    if (this.state.comTempTaskId !== nextProps.selectedAttenData.comTempTaskId) {
      this.getPersonList(nextProps.selectedAttenData.comTempTaskId);
    }
    console.log(nextProps.selectedAttenData)
    this.setState({
      selectedIndex: nextProps.clickAttenPersonIndex,
      selectedAttenData: nextProps.selectedAttenData,
      comTempTaskId: nextProps.selectedAttenData.comTempTaskId
    });
  }
  //获取驻勤点对应的保安员列表
  getPersonList(comTempTaskId, pageNumber = 1, pageSize = this.state.pageSize) {
    // getComTaskPerLocation({
      getComTempTaskPerLocation({
      pageNumber,
      pageSize,
      comTempTaskId
    }).then(res => {
      if (res.retType === '0') {
        if (res.data.data.length > 0) {
          this.props.attenPersonList(res.data.data);
          this.setState({
            attenPersonList: res.data.data,
            total: res.data.total
          });
        }else{
          message.warning("该驻勤点没有人员")
        }
      }
    });
  }
  render() {
    return (
      <div className="security search-list amap_lib_placeSearch">
        <div className="security-personnel">
          <span>
            {this.state.selectedAttenData &&
              this.state.selectedAttenData.taskName}
          </span>
          <span
            className="close"
            onClick={() => {
              this.props.close();
              this.props.attenPersonList([]);
              this.setState({
                selectedIndex: null
              });
            }}
          >
            x
          </span>
        </div>
        <div className="list">
          <div className="item attendance-detail">
            <div>负责人:{this.state.selectedAttenData.name}</div>
            <div>身份证号:{this.state.selectedAttenData.idCardNo}</div>
            <div>手机号码:{this.state.selectedAttenData.mobilePhone}</div>
            <div>地址:{this.state.selectedAttenData.taskAddress}</div>
            <div>保安员数量:{this.state.selectedAttenData.perNum}名</div>
            <div>
              服务企业类型:{this.state.selectedAttenData.serviceObjectTypeName}
            </div>
          </div>
          <div
            className="attendance-data"
            style={{ maxHeight: this.state.height }}
          >
            {this.state.attenPersonList.map((item, index) => {
              return (
                <div
                  key={index}
                  className="item"
                  onClick={() => {
                    //考虑人员是否有经纬度信息
                    if (item.lnglat) {
                      this.props.onClickSearchPerson(item, index);
                      this.setState({
                        selectedIndex: index
                      });
                    } else {
                      message.warning('当前人员暂未拥有位置信息');
                    }
                  }}
                >
                  <div
                    className={
                      this.state.selectedIndex === index
                        ? 'selected poibox'
                        : 'poibox'
                    }
                  >
                    {/* 同时拥有经纬度信息的时候，才能给出图标。作为区分 */}
                    {item.lnglat && (
                      <div className="amap_lib_placeSearch_poi poibox-icon">
                        {index}
                      </div>
                    )}
                    <div style={{ marginLeft: 25 }}>
                      <div className="name">{item.name}</div>
                      <div className="text">手机号码:{item.mobilePhone}</div>
                      <div className="text">证件号码:{item.idCardNo}</div>
                    </div>
                  </div>
                </div>
              );
            })}
          </div>
        </div>
        <div
          className="see-more"
          style={{
            display: this.state.total > this.state.pageSize ? 'block' : 'none'
          }}
        >
          <span
            onClick={() => {
              this.getPersonList(this.state.comTempTaskId, 1, this.state.total);
            }}
          >
            查看更多
          </span>
        </div>
        {/* <Pagination
          total={this.state.total}
          size="small"
          onChange={number => {
            this.getPersonList(number);
          }}
          defaultPageSize={this.state.searchData.pageSize}
          current={this.state.searchData.pageNumber}
          style={{ display: this.state.total > 1 ? 'block' : 'none' }}
        /> */}
      </div>
    );
  }
}
