/**
 * 驻勤点的搜索列表
 */
import React, { Component } from "react";
import { Pagination, Button, Input, Icon } from "antd";
import "./attendance.less";
import PersonSearchList from "./PersonSearchList";
import { getComTaskList, getComTempTaskList } from "../../../../services/api";
export default class AttendanceSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      layerSatatus: props.layerSatatus,
      activityNo: props.activityNo,
      // isSecuOrAtten: props.isSecuOrAtten,
      searchData: {
        //搜索数据
        pageNumber: 1,
        pageSize: 7,
        taskName: null
      },
      // selectedIndex: props.selectedIndex || null, //选中哪个列表
      selectedIndex: null, //选中哪个列表
      selectedAttenData: props.selectedAttenData || null, //选中的驻勤点的信息
      clickAttenPersonIndex: props.clickAttenPersonIndex || null,
      clickEventIndex: props.clickEventIndex || null,
      total: 0, //搜索总页数
      attendanceList: [], //搜索出的驻勤点的数据
      iconData: props.iconData || [], //图标列表
      // attenPersonList: [] //驻勤点对应的人员信息
      height: null, //搜索列表的最大高度
      eventList: [{
        name: '活动事件1',
        lnglat: [106.22445, 38.486085],
        describe: '活动事件测试信息',
        id: '1'
      }, {
        name: '活动事件2',
        lnglat: [106.225293, 38.485052],
        describe: '活动事件测试信息',
        id: '2'
      }, {
        name: '活动事件3',
        lnglat: [106.222696, 38.485312],
        describe: '活动事件测试信息',
        id: '3'
      }],
    };
  }

  componentDidMount() {
    const height = document.documentElement.clientHeight - 120 - 130 - 40;
    this.setState({ height });
    this.getAttendanceList(1); //默认页面中是空搜索
    this.props.eventList(this.state.eventList);
  }
  componentWillReceiveProps(nextPorps) {
    this.setState({
      layerSatatus: nextPorps.layerSatatus,
      // selectedIndex: nextPorps.selectedIndex,
      selectedAttenData: nextPorps.selectedAttenData,
      clickAttenPersonIndex: nextPorps.clickAttenPersonIndex,
      iconData: nextPorps.iconData,
      activityNo: nextPorps.activityNo,
      clickEventIndex:nextPorps.clickEventIndex
    });
  }
  //获取搜索值
  getAttendanceList(pageNumber) {
    // this.props.onClickSelectedAttenData(null);
    this.props.attenPersonList([]);
    //先重置分页数据
    this.setState(
      {
        searchData: {
          ...this.state.searchData,
          pageNumber
        },
        selectedIndex: null, //清空驻勤的点击哪个列表的信息
        selectedAttenData: null
      },
      () => {
        //临保任务的列表（与普通防控的不同之处）
        // getComTaskList({
        getComTempTaskList({
          ...this.state.searchData,
          activityNo: this.state.activityNo
        }).then(res => {
          if (res.retType === "0") {
            this.setState({
              attendanceList: res.data.data,
              total: res.data.total
            });
            this.props.attendanceList(res.data.data);
          }
        });
      }
    );
  }
  render() {
    return (
      <div
        style={{
          display:
            this.state.layerSatatus === "attendance"
              ? // ? this.state.isSecuOrAtten === '0'
              "block"
              : "none"
          // : 'none'
        }}
      >
        {/* 驻勤地点 */}
        {/* 驻勤点搜索条件框 */}
        <div className="security drawer_container">
          <Input
            placeholder="请输入驻勤点:"
            style={{ width: 210 }}
            onChange={e => {
              this.setState({
                searchData: {
                  ...this.state.searchData,
                  taskName: e.target.value.trim()
                }
              });
            }}
            onPressEnter={() => {
              //按下回车获取列表值
              this.getAttendanceList(1);
            }}
          />
          <Button
            type="primary"
            onClick={() => {
              //获取搜索值
              this.getAttendanceList(1);
            }}
          >
            <Icon type="search" style={{ fontSize: "16px" }} />
          </Button>
        </div>

        {/* 驻勤点搜索列表值 */}
        <div
          className="security search-list amap_lib_placeSearch"
          style={{
            display:
              this.state.attendanceList.length > 0
                ? this.state.selectedAttenData
                  ? "none"
                  : "block"
                : "none"
          }}
        >
          <div className="security-personnel">
            <span>驻勤地点</span>
          </div>
          <div className="list" style={{ maxHeight: this.state.height }}>
            {this.state.attendanceList.map((item, index) => {
              let markIcon = null;
              if (!!item.taskStationType) {
                for (let i = 0; i < this.state.iconData.length; i++) {
                  if (this.state.iconData[i].key === item.taskStationType) {
                    markIcon = this.state.iconData[i].markerIcon;
                  }
                }
              }
              return (
                <div
                  key={index}
                  className="item"
                  onClick={() => {
                    this.props.onClickSelectedAttenData(item, index);
                    this.setState({
                      selectedIndex: index
                      // selectedAttenData: item //选中的数据
                    });
                  }}
                >
                  <div
                    className={
                      // this.state.selectedIndex === index
                      //   ? 'selected poibox'
                      //   :
                      "poibox"
                    }
                  >
                    {markIcon ? (
                      <div
                        className="amap_lib_placeSearch_poi mark-icon"
                        style={{ background: "url(" + markIcon + ")" }}
                      >
                        {/* {index} */}
                      </div>
                    ) : (
                        <div className="amap_lib_placeSearch_poi">
                          {/* {index} */}
                        </div>
                      )}

                    <div style={{ marginLeft: 25, marginTop: 2 }}>
                      <div className="name">{item.taskName}</div>
                      <div className="text">地址：{item.taskAddress}</div>
                    </div>
                  </div>
                </div>
              );
            })}
          </div>

          <Pagination
            total={this.state.total}
            size="small"
            onChange={number => {
              this.getAttendanceList(number);
            }}
            defaultPageSize={this.state.searchData.pageSize}
            current={this.state.searchData.pageNumber}
            style={{ display: this.state.total > 1 ? "block" : "none" }}
          />
        </div>

        {/* 事件列表 */}
        <div className="security search-list amap_lib_placeSearch"
          style={{
            top: '400px',
            display:
              this.state.attendanceList.length > 0
                ? this.state.selectedAttenData
                  ? "none"
                  : "block"
                : "none"
          }}>
          <div className="security-personnel">
            <span>事件列表</span>
          </div>
          <div className="list" style={{ maxHeight: this.state.height }}>
            {this.state.eventList.map((item, index) => {
              // let markIcon = null;
              // if (!!item.taskStationType) {
              //   for (let i = 0; i < this.state.iconData.length; i++) {
              //     if (this.state.iconData[i].key === item.taskStationType) {
              //       markIcon = this.state.iconData[i].markerIcon;
              //     }
              //   }
              // }
              return (
                <div
                  key={index}
                  className="item"
                  onClick={() => {
                    this.props.onClickEventData(item, index);
                    this.setState({
                      clickEventIndex: index
                    });
                  }}
                >
                  <div
                    className={
                      this.state.clickEventIndex === index
                        ? 'selected poibox'
                        : 'poibox'
                    }
                  >
                    <div className="amap_lib_placeSearch_poi">
                      {index}
                    </div>

                    <div style={{ marginLeft: 25, marginTop: 2 }}>
                      <div className="name">{item.name}</div>
                      {/* <div className="text">地址：{item.taskAddress}</div> */}
                    </div>
                  </div>
                </div>
              );
            })}
          </div>
        </div>

        {/* 对应驻勤点的保安员列表 */}
        {this.state.selectedAttenData && (
          <PersonSearchList
            selectedAttenData={this.state.selectedAttenData}
            clickAttenPersonIndex={this.state.clickAttenPersonIndex}
            close={() => {
              this.setState({
                selectedIndex: null,
                selectedAttenData: null
              });
              // this.props.onClosePerson()
              // this.props.onClickSelectedAttenData(null);
            }}
            attenPersonList={attenPersonList => {
              this.props.attenPersonList(attenPersonList);
            }}
            onClickSearchPerson={(clickPersonData, index) => {
              this.props.onClickSearchPerson(clickPersonData, index);
            }}
          />
        )}
      </div>
    );
  }
}
