/**
 * 临保的防控指挥
 * 地图页面
 */
import React, { PureComponent } from "react";
import style from "styled-components";
import citys from "../../../mock/city";
import { connect } from "dva";
import "./command.less";
// import "../Command/command.less";
import TIM from "tim-js-sdk";
import Detail from "./mapModule/Detail";
import tim from "../../utils/imInitialize";
import {
  createGroup,
  sendVideoRoomMsg,
  getComPerLocationPageList
} from "../../services/api";
import { message, Button, Modal, Input, Form, Row, Col, Icon } from "antd";
import IM from "../Command/IM/index";
import Video from "../Command/Video/index";
import Vectorgraph from "./mapModule/Vectorgraph";
import Record from "../Command/Record/index";
import SwitchMap from "./mapModule/SwitchMap";
import AttendanceSearch from "./mapModule/Attendance/AttendanceSearch";
import AttendanceType from "./mapModule/Attendance/AttendanceType";
import PersonSearch from "./mapModule/Person/PersonSearch";
import BeijingVideo from '../Command/mapModule/BeijingVideo';
import store1 from "../../../src/index";
import { routerRedux } from "dva/router";
import queryString from "query-string";
const { TextArea } = Input;
const formItemLayout = {
  labelCol: {
    xs: {
      span: 7
    },
    sm: {
      span: 7
    },
    md: {
      span: 6
    }
  },
  wrapperCol: {
    xs: {
      span: 24
    },
    sm: {
      span: 20
    },
    md: {
      span: 18
    }
  }
};
@connect(state => ({
  mobilePhone: state.user.currentUser.mobilePhone,
  imSig: state.global.imSig,
  imIsLogin: state.global.imIsLogin,
  comName: state.global.companyInfo.comName,
  nextReqMessageID: state.im.nextReqMessageID,
  conversationList: state.im.conversationList,
  currentMessageList: state.im.currentMessageList
}))
@Form.create()
export default class CommandTemporary extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      mapObject: null,
      citys: citys,
      mouseTool: null,
      //地图部门功能全局化
      map: null,
      mass: null,
      markers: [], //搜索到的驻点数据
      //驻勤点图层
      attenPersonList: [], //驻勤点下的人员列表
      attenPersonMarkers: [], //驻勤点下的人员的数据
      attendanceMarkers: [], //驻勤点的数据
      selectedAttenData: null, //地图上点击哪一个驻勤点
      clickAttenPersonIndex: null, //地图上点击哪一个人员
      //人员图层
      personMarkers: [], //人员打点
      personList: [], //人员数据
      personClickIndex: null, //人员点击图层中的哪一个人员

      infoWindow: null, //全局定义信息窗体（在初始化地图的时候，也初始化信息窗体）
      imStatus: false, //是否展示im的可视化页面
      videoStatus: false, //视频通话页面是否显示
      /*****保安员******/
      isSecuOrAtten: "0", //是选中保安员或者是驻勤点(0是保安员(默认),1是驻勤点)
      securityModalStatus: false, //保安员的弹窗状态
      filterModal: false, //按条件搜索展示状态
      searchList: [], //搜索到的列表
      totalPage: 0, //搜索总页数
      /*****驻勤点******/
      attendanceModalStatus: false, //驻勤点的弹窗状态
      placeSearch: null, //驻勤点的搜索功能
      attendanceSearch: null, //驻勤点搜索值
      //
      showDetail: false, //显示详情弹窗
      selectedPoints: [], //通过矢量图选中的多个数据点
      overlays: [], //矢量图绘制的点（主要用在清空矢量图）
      selectedPointsStatus: false, //显示选中多人数据的弹窗
      selectedIndex: null, //搜索保安员，选中地图中的选点
      selectedData: {
        phone: ""
      }, //选中的点的数据
      //调度的内容
      dispatchType: "", //调度类型（text文字,voice语音,video视频）
      // creatType: 'person', //'person'个人，‘group’群组
      createTaskStatus: false, //创建任务弹窗状态
      schedulingContent: "", //调度任务内容
      schedulingName: "", //调度任务名称
      needCreateConversation: false, //是否需要创建单人会话
      initMapOk: false, //初始化地图是否完成
      mapIndex: null, //需要的是那个地图图层
      layerSatatus: "attendance", //海量点图层(attendance是驻勤点图层，mass是海量图层,person是人员图层)
      normalMap: null, //正常的图层（变成是驻勤点图层）
      locaMap: null, //海量图层
      personMap: null, //人员图层
      // massData: [], //海量点数据
      massDataTotalPage: 0, //海量点的总页数
      allData: [], //全部的海量点数据
      searchData: {
        pageNumber: 1,
        pageSize: 7,
        keyWord: null
      },
      personPerId: null, //选中打开哪个人的详细信息id
      paintValue: "cancel", //选中的是用哪个图形画图
      conversationID: "", //当前在地图中选中的哪个人或群组的id
      loadingState: false, //给一个加载的状态
      loadingText: "",
      beijing: false, //北京搜索框的展示状态
      beijingVideo: false, //北京视频的展示状态
      gaoqi: false, //高崎搜索框的展示状态
      // caijiVideo: false, //采集状态,
      // huodongVideo: false, //活动票证分析状态
      //录音
      showRecord: false, //是否显示录音的页面
      spinLoading: false, //全局加载状态
      onlyPersonVoiceStatus: false, //个人调度的录音状态
      activityNo: ""
    };
  }

  /******************************生命周期******************************/
  componentDidMount() {
    // 隐藏左侧菜单栏
    document.querySelector(".ant-layout-sider").style.display = "none";
    document.querySelector(".ant-layout-content").style.margin = "0px";
    document.querySelector(".oneKeySearchHidden").style.display = "none";
    //隐藏顶部菜单栏
    document.querySelector(".ant-layout-header").style.display = "none";
    this.loadMapScript();
    tim.on(TIM.EVENT.KICKED_OUT, () => {
      console.log("被剔出");
      const { dispatch } = store1;
      dispatch(routerRedux.push("/user/logOn"));
    });
    const activityNo = queryString.parse(this.props.location.search).activityNo;
    console.log(activityNo);
    if (activityNo) {
      this.setState({
        activityNo
      });
    }
  }
  componentWillUnmount() {
    // 显示左侧菜单栏
    document.querySelector(".ant-layout-sider").style.display = "block";
    document.querySelector(".ant-layout-content").style.margin = "16px";
    document.querySelector(".oneKeySearchHidden").style.display = "block";
    window.AMap = null;
  }
  loadMapScript = () => {
    //基础地图底层
    const script = document.createElement("script");
    script.src =
      "https://webapi.amap.com/maps?v=1.4.15&key=9066916e054aa3083a6f081a2a9f9d7a&plugin=AMap.ControlBar";
    document.body.appendChild(script);

    //loca图层
    const script2 = document.createElement("script");
    script2.src =
      "https://webapi.amap.com/loca?v=1.3.0&key=9066916e054aa3083a6f081a2a9f9d7a";
    document.body.appendChild(script2);

    //视频调度sdk
    const script4 = document.createElement("script");
    script4.src =
      "https://sqimg.qq.com/expert_qq/webrtc/3.0.6/WebRTCAPI.min.js";
    document.body.appendChild(script4);

    const script3 = document.createElement("script");
    script3.src = "http://cache.amap.com/lbs/static/addToolbar.js";
    if (!"AMap" in window) {
      document.body.appendChild(script3);
    }
    this.loading();
  };
  loading = () => {
    let _this = this;
    function nextStep() {
      return new Promise(resolve => {
        setTimeout(() => {
          resolve("AMap" in window);
        }, 500);
      });
    }

    async function ajaxMap() {
      let ifComplete = false;
      for (var i = 0; i < 10; i++) {
        if (!ifComplete) {
          console.log("没有");
          ifComplete = await nextStep();
        } else {
          if (ifComplete) {
            const { AMap, Loca } = window;
            console.log("第" + i + "次加载" + "地图初始化中。。。");
            if (!AMap) {
              _this.loadMapScript();
            } else {
              _this.initialMap();
            }
            break;
          } else {
            message.error("网络超时");
          }
        }
      }
    }
    ajaxMap();
  };
  initialMap = () => {
    const { AMap, Loca } = window;
    const normalMap = new AMap.Map("map_container", {
      resizeEnable: true,
      rotateEnable: true,
      pitchEnable: true,
      zoom: 12,
      viewMode: "2D", //开启2D视图
      buildingAnimation: true, //楼块出现是否带动画
      expandZoomRange: true,
      zooms: [3, 20]
    });
    const locaMap = new AMap.Map("map_container2", {
      features: ["bg", "road"],
      mapStyle: "amap://styles/midnight",
      zoom: 5,
      viewMode: "2D",
      skyColor: "#33216a"
    });
    const personMap = new AMap.Map("map_container3", {
      resizeEnable: true,
      rotateEnable: true,
      pitchEnable: true,
      zoom: 12,
      viewMode: "2D", //开启2D视图
      buildingAnimation: true, //楼块出现是否带动画
      expandZoomRange: true,
      zooms: [3, 20]
    });
    this.setState({ normalMap, locaMap, personMap });
    if (AMap.ControlBar) {
      locaMap.addControl(
        new AMap.ControlBar({
          showZoomBar: false,
          showControlButton: true
        })
      );
      normalMap.addControl(
        new AMap.ControlBar({
          showZoomBar: false,
          showControlButton: true
        })
      );
      personMap.addControl(
        new AMap.ControlBar({
          showZoomBar: false,
          showControlButton: true
        })
      );
    }
    this.setState({ map: normalMap });
    //初始化海量点数据
    const pageNumber = 1,
      pageSize = 500;
    this.massPoints(pageNumber, pageSize, locaMap);
    let infoWindow = new AMap.InfoWindow({
      isCustom: true, //使用自定义窗体
      offset: new AMap.Pixel(16, -45)
    });
    this.setState({
      infoWindow
    });
    normalMap.on("zoomchange", info => {
      // console.log(info);
      let zoom = normalMap.getZoom(); //获取当前地图级别
      // console.log(zoom);
      // console.log(this.state.mass1);
      // console.log(this.state.mass2);
      // if (zoom > 6) {
      //   for (let i = 0; i < this.state.massDataTotalPage; i++) {
      //     let index = i + 1;
      //     this.state['mass' + index].setStyle({
      //       url: 'https://a.amap.com/jsapi_demos/static/images/mass1.png',
      //       anchor: new AMap.Pixel(3, 3),
      //       size: new AMap.Size(5, 5)
      //     });
      //   }
      // } else {
      //   for (let i = 0; i < this.state.massDataTotalPage; i++) {
      //     let index = i + 1;
      //     this.state['mass' + index].setStyle({
      //       url: 'https://a.amap.com/jsapi_demos/static/images/mass1.png',
      //       anchor: new AMap.Pixel(3, 3),
      //       size: new AMap.Size(1.5, 1.5)
      //     });
      //   }
      // }
    });
    //创建矢量图画图工具
    this.createMouseTool(this.state.map);
  };
  //创建矢量图画图工具
  createMouseTool(currentMap) {
    const { AMap } = window;
    AMap.plugin(["AMap.MouseTool", "AMap.PlaceSearch"], () => {
      const mouseTool = new AMap.MouseTool(currentMap);
      this.setState({
        mouseTool
      });
      //添加事件
      AMap.event.addListener(mouseTool, "draw", e => {
        this.setState({
          overlays: e.obj
        });
        let polygonPoints = e.obj.getPath();
        // 整理多边形点的数据 变成[[],[]]的格式
        polygonPoints.map(point => {
          return [point.lng, point.lat];
        });
        let selectedPoints = null;
        if (this.state.layerSatatus === "attendance") {
          //正常图层的时候
          // selectedPoints = this.state.searchList.filter(pos => {//这是第一版的搜索列表数据
          selectedPoints = this.state.attenPersonList.filter(pos => {
            //取的数据是该驻勤点下的人员数据
            if (pos.lnglat) {
              // 地图点的坐标转换成[]
              const posArray = [pos.lnglat[0], pos.lnglat[1]];
              // const posArray = [pos.lnglat.lng, pos.lnglat.lat];
              return AMap.GeometryUtil.isPointInRing(posArray, polygonPoints);
            }
          });
        } else if (this.state.layerSatatus === "mass") {
          //海量图层
          selectedPoints = this.state.allData.filter(pos => {
            if (pos.lnglat) {
              // 地图点的坐标转换成[]
              // const posArray = [pos.lnglat[0], pos.lnglat[1]];
              const posArray = [pos.lnglat.lng, pos.lnglat.lat];
              return AMap.GeometryUtil.isPointInRing(posArray, polygonPoints);
            }
          });
        } else if (this.state.layerSatatus === "person") {
          selectedPoints = this.state.personList.filter(pos => {
            if (pos.lnglat) {
              // 地图点的坐标转换成[]
              const posArray = [pos.lnglat[0], pos.lnglat[1]];
              // const posArray = [pos.lnglat.lng, pos.lnglat.lat];
              return AMap.GeometryUtil.isPointInRing(posArray, polygonPoints);
            }
          });
        }
        if (selectedPoints.length === 0) {
          Modal.error({
            title: "没有选中项",
            onOk: () => {
              this.state.map.remove([e.obj]);
            }
          });
        } else {
          this.setState({
            selectedPoints,
            selectedPointsStatus: true
          });
        }
      });
      // new AMap.PlaceSearch({});
      let placeSearch = new AMap.PlaceSearch({
        pageSize: 6, // 单页显示结果条数
        pageIndex: 1, // 页码
        city: "010", // 兴趣点城市
        citylimit: true, //是否强制限制在设置的城市内搜索
        map: this.state.map, // 展现结果的地图实例
        panel: "panel", // 结果列表将在此容器中进行展示。
        autoFitView: true // 是否自动调整地图视野使绘制的 Marker点都处于视口的可见范围
      });
      this.setState({ placeSearch });
      // 关键字查询
      //  placeSearch.search('厦门市软件园三期');
    });
  }
  //初始海量数据
  massPoints(pageNumber, pageSize, locaMap) {
    //真正的海量图搜索
    getComPerLocationPageList({ pageNumber, pageSize }).then(res => {
      const data = this.state.allData;
      data.push(...res.data.data);
      this.setState({
        massDataTotalPage: res.data.totalPage,
        allData: data
      });
      if (res.retType === "0" && res.data.total > 0) {
        let style = [
          {
            //0是圆圈
            url: "https://a.amap.com/jsapi_demos/static/images/mass1.png",
            anchor: new AMap.Pixel(0, 0),
            size: new AMap.Size(2, 2)
          }
        ];
        let mass = new AMap.MassMarks(res.data.data, {
          opacity: 0.8,
          zIndex: 111,
          cursor: "pointer",
          style: style
          // icon: "//a.amap.com/jsapi_demos/static/demo-center/icons/poi-marker-default.png",
          // position: [116.406315,39.908775],
          // offset: new AMap.Pixel(-13, -30)
        });
        this.setState({ ["mass" + pageNumber]: mass });
        const that = this;
        mass.on("click", function(e) {
          let infoWindow = new AMap.InfoWindow({
            isCustom: true, //使用自定义窗体
            content: that.createInfoWindow(e.data),
            offset: new AMap.Pixel(16, -45)
          });
          infoWindow.open(locaMap, e.data.lnglat);
        });
        //先把海量点关掉，后面有需要再开
        mass.setMap(locaMap);
        const nextPageNumber = pageNumber + 1;
        if (
          nextPageNumber < res.data.totalPage ||
          nextPageNumber === res.data.totalPage
        ) {
          this.massPoints(nextPageNumber, pageSize, locaMap);
        } else {
          //数据加载完了，检查im有没有失效
          if (!!!this.props.imIsLogin) {
            console.log("重新请求");
            if (this.props.mobilePhone) {
              this.props.dispatch({
                type: `global/imLogin`,
                payload: {
                  username: this.props.mobilePhone
                }
              });
            }
          }
        }
      }
    });
  }
  //切换图层
  switchMap(value) {
    this.state.mouseTool.close(true);
    this.state.map.clearInfoWindow();
    this.setState({
      paintValue: "cancel"
    });
    if (value !== this.state.layerSatatus) {
      //有切换的时候才进行数据的处理
      //如果是切换地图的
      this.setState({ searchList: [] });
      //为真的时候是海量图，为假是普通图
      // if (!this.state.layerSatatus) {
      if (value === "attendance") {
        //换成驻勤点图
        this.setState({
          layerSatatus: value,
          map: this.state.normalMap
        });
        //创建矢量图画图工具
        this.createMouseTool(this.state.normalMap);
      } else if (value === "mass") {
        //换成海量图层
        this.setState({
          layerSatatus: value,
          map: this.state.locaMap
        });
        //创建矢量图画图工具
        this.createMouseTool(this.state.locaMap);
      } else if (value === "person") {
        this.setState({
          layerSatatus: value,
          map: this.state.personMap
        });
        //创建矢量图画图工具
        this.createMouseTool(this.state.personMap);
      }
    }
  }
  //人员图层对搜索出的人员打点
  markPersonList(personList, where = "") {
    // where代表搜索的值，“软件园三期”“百川信”有特殊的打点位置需求
    if (this.state.personMarkers) {
      this.state.map.remove(this.state.personMarkers);
    }
    if (this.state.beijingMarkers) {
      this.state.map.remove(this.state.beijingMarkers);
    }
    if (this.state.gaoqiMarkers) {
      this.state.map.remove(this.state.gaoqiMarkers);
    }
    let personMarkers = [];
    personList.map((item, index) => {
      // const map = this.state.map;
      if (item.lnglat) {
        var marker = new AMap.Marker({
          position: new AMap.LngLat(item.lnglat[0], item.lnglat[1]), // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
          title: item.name,
          content:
            '<div class="amap_lib_placeSearch_poi poibox-icon">' +
            index +
            "</div>",
          key: item.perId,
          indexText:index
        });
        const that = this;
        //手动驻的点给点击事件
        AMap.event.addListener(marker, "click", function() {
          // that.setState({
          //   selectedIndex: index //要定位选中的是第几个
          //   // selectedData: that.state.searchList[index]
          // });
          let infoWindow = new AMap.InfoWindow({
            isCustom: true, //使用自定义窗体
            content: that.createInfoWindow(that.state.personList[index]),
            offset: new AMap.Pixel(16, -45)
          });
          infoWindow.open(that.state.map, marker.getPosition());
          const markers = that.state.personMarkers;
          markers.map((itemMark, i) => {
            if (itemMark.w.key === item.perId) {
              markers[i].setContent(
                '<div class="selected"><div class="amap_lib_placeSearch_poi poibox-icon">' +
                itemMark.w.indexText +
                  "</div></div>"
              );
            } else {
              markers[i].setContent(
                '<div class="amap_lib_placeSearch_poi poibox-icon">' +
                itemMark.w.indexText +
                  "</div>"
              );
            }
          });
          that.setState({
            personMarkers: markers,
            personClickIndex: index
          });
          that.state.map.setCenter(marker.getPosition());
        });
        personMarkers.push(marker);
      }
    });
    this.state.map.add(personMarkers);
    if (where === "厦门软件园三期" || where === "软件园三期") {
      let allMark = [];
      //假的点,用来居中到软三的作用
      var marker1 = new AMap.Marker({
        position: new AMap.LngLat(118.051211, 24.60608) // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
      });
      allMark.push(marker1);
      var marker2 = new AMap.Marker({
        position: new AMap.LngLat(118.047843, 24.611016) // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
      });
      allMark.push(marker2);
      this.state.map.setFitView(allMark);
    } else {
      this.state.map.setFitView(personMarkers); //自适应显示所有的标注点
    }
    this.setState({ personMarkers });
  }
  //搜索出的驻勤点打点
  markerAttendanceList(attendanceList, typeName = "") {
    if (typeName === "" && !!this.state.attendanceMarkers) {
      //如果是搜索列表的打点，先删除之前地图上的搜索的驻勤标记
      this.state.map.remove(this.state.attendanceMarkers);
    }
    let attendanceMarkers = [];
    attendanceList.map((item, index) => {
      //用来判断改驻勤点有没有驻勤点类型，有的话就要用对应的驻勤点类型的图标，没有的话就用原本的
      let markIcon = null;
      if (!!item.taskStationType) {
        for (let i = 0; i < this.state.iconData.length; i++) {
          if (this.state.iconData[i].key === item.taskStationType) {
            markIcon = this.state.iconData[i].markerIcon;
          }
        }
      }
      const map = this.state.map;
      if (item.lnglat) {
        var marker = new AMap.Marker({
          position: new AMap.LngLat(item.lnglat[0], item.lnglat[1]), // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
          title: item.name,
          // icon: item.markerIcon || markerIcon[0].icon
          content: markIcon
            ? '<div class="amap_lib_placeSearch_poi poibox-icon mark-icon" style="background:url(' +
              markIcon +
              ')">' +
              "</div>"
            : '<div class="amap_lib_placeSearch_poi poibox-icon">' + "</div>"
        });
        const that = this;
        //手动驻的点给点击事件
        AMap.event.addListener(marker, "click", function() {
          let infoWindow = new AMap.InfoWindow({
            isCustom: true, //使用自定义窗体
            content: that.createAttendanceInfoWindow(item),
            offset: new AMap.Pixel(16, -45)
          });
          infoWindow.open(map, marker.getPosition());
        });
        attendanceMarkers.push(marker);
      }
    });
    this.state.map.add(attendanceMarkers);
    this.state.map.setFitView(attendanceMarkers); //自适应显示所有的标注点
    if (typeName) {
      //此处的功能，主要用于删除地图上的驻勤点时候的区分
      //这是底部16个的驻点
      const data = this.state[typeName] || [];
      data.push(...attendanceMarkers);
      this.setState({
        [typeName]: data
      });
    } else {
      //这是通过搜索得到的驻点
      this.setState({ attendanceMarkers });
    }
  }
  //事件列表的打点
  markerEventList(eventList) {
    // if (!!this.state.attendanceMarkers) {
    //   //先删除之前地图上的人员标记
    //   this.state.map.remove(this.state.attenPersonMarkers);
    // }
    let eventMarkers = [];
    //如果有人员数据，自适应全部人员数据，不然就自适应驻勤点的数据
    if (eventList.length > 0) {
      // this.state.map.remove(this.state.attendanceMarkers);
      eventList.map((item, index) => {
        const map = this.state.map;
        if (item.lnglat) {
          var marker = new AMap.Marker({
            position: new AMap.LngLat(item.lnglat[0], item.lnglat[1]), // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
            title: item.name,
            content:
              '<div class="amap_lib_placeSearch_poi poibox-icon">' +
              index +
              "</div>"
          });
          const that = this;
          //人员驻的点给点击事件
          AMap.event.addListener(marker, "click", function() {
            let infoWindow = new AMap.InfoWindow({
              isCustom: true, //使用自定义窗体
              content: that.createEventInfoWindow(item),
              offset: new AMap.Pixel(16, -45)
            });
            infoWindow.open(map, marker.getPosition());
            const markers = that.state.eventMarkers;
            markers.map((item, i) => {
              if (i === index) {
                markers[index].setContent(
                  '<div class="selected"><div class="amap_lib_placeSearch_poi poibox-icon">' +
                    index +
                    "</div></div>"
                );
              } else {
                markers[i].setContent(
                  '<div class="amap_lib_placeSearch_poi poibox-icon">' +
                    i +
                    "</div>"
                );
              }
            });
            that.setState({
              eventMarkers: markers,
              clickEventIndex: index //地图上点中哪一个
            });
            that.state.map.setCenter(marker.getPosition());
          });
          eventMarkers.push(marker);
        }
      });
      this.setState({ eventMarkers });
      this.state.map.add(eventMarkers);
      this.state.map.setFitView(eventMarkers); //自适应显示所有的人员标注点
    } else {
      // this.state.map.add(this.state.attendanceMarkers);
      // this.state.map.setFitView(this.state.attendanceMarkers); //自适应显示所有的驻勤点标注点
      // this.state.map.clearInfoWindow();
    }
    // this.setState({attenPersonList})
  }
  //对搜索的驻勤点对应的人员进行打点
  markerAttenPersonList(attenPersonList) {
    if (!!this.state.attendanceMarkers) {
      //先删除之前地图上的人员标记
      this.state.map.remove(this.state.attenPersonMarkers);
    }
    let attenPersonMarkers = [];
    //如果有人员数据，自适应全部人员数据，不然就自适应驻勤点的数据
    if (attenPersonList.length > 0) {
      // this.state.map.remove(this.state.attendanceMarkers);
      attenPersonList.map((item, index) => {
        const map = this.state.map;
        if (item.lnglat) {
          var marker = new AMap.Marker({
            position: new AMap.LngLat(item.lnglat[0], item.lnglat[1]), // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
            title: item.name,
            content:
              '<div class="amap_lib_placeSearch_poi poibox-icon">' +
              index +
              "</div>"
          });
          const that = this;
          //人员驻的点给点击事件
          AMap.event.addListener(marker, "click", function() {
            let infoWindow = new AMap.InfoWindow({
              isCustom: true, //使用自定义窗体
              content: that.createInfoWindow(item),
              offset: new AMap.Pixel(16, -45)
            });
            infoWindow.open(map, marker.getPosition());
            const markers = that.state.attenPersonMarkers;
            markers.map((item, i) => {
              if (i === index) {
                markers[index].setContent(
                  '<div class="selected"><div class="amap_lib_placeSearch_poi poibox-icon">' +
                    index +
                    "</div></div>"
                );
              } else {
                markers[i].setContent(
                  '<div class="amap_lib_placeSearch_poi poibox-icon">' +
                    i +
                    "</div>"
                );
              }
            });
            that.setState({
              attenPersonMarkers: markers,
              clickAttenPersonIndex: index //地图上点中哪一个
            });
            that.state.map.setCenter(marker.getPosition());
          });
          attenPersonMarkers.push(marker);
        }
      });
      this.setState({ attenPersonMarkers });
      this.state.map.add(attenPersonMarkers);
      this.state.map.setFitView(attenPersonMarkers); //自适应显示所有的人员标注点
    } else {
      this.state.map.add(this.state.attendanceMarkers);
      this.state.map.setFitView(this.state.attendanceMarkers); //自适应显示所有的驻勤点标注点
      this.state.map.clearInfoWindow();
    }
    // this.setState({attenPersonList})
  }
  //定义单个的人员信息窗体
  createInfoWindow(data) {
    const { name, com, idCardNo, attendancePoints, perId, photoUrl } = data;
    var content = [];
    const imgHeader = [];
    if (photoUrl) {
      imgHeader.push("<img src=" + photoUrl + ">");
    } else {
      imgHeader.push(
        "<span class='img-span'>" +
          name.substring(name.length - 2, name.length) +
          "</span>"
      );
    }
    content.push(
      "<div><div class='image'>" +
        imgHeader +
        "</div><div class='content-text'><div class='text'>" +
        name +
        "</div><div class='text'>证件号码：" +
        idCardNo +
        "</div></div>"
    );
    content.join("<br/>");
    var info = document.createElement("div");
    info.className = "content-window-card";
    //可以通过下面的方式修改自定义窗体的宽高
    info.style.width = "400px";
    // 定义内容
    var middle = document.createElement("div");
    middle.className = "info-middle";
    middle.innerHTML = content;
    info.appendChild(middle);
    //定义详情
    var detail = document.createElement("div");
    detail.className = "detail-div";
    info.appendChild(detail);
    //定义关闭按钮
    var detail = document.createElement("div");
    detail.className = "close-div";
    var a = document.createElement("a");
    a.innerHTML = "x";
    // a.style.marginLeft = '95px';
    a.onclick = () => {
      this.state.map.clearInfoWindow();
    };
    detail.appendChild(a);
    info.appendChild(detail);
    //定义三个调度按钮
    var top = document.createElement("div");
    top.className = "info-button";
    var button1 = document.createElement("span");
    button1.className = "button";
    button1.innerHTML = "文字调度";
    button1.onclick = () => {
      this.character(data);
    };
    var button2 = document.createElement("span");
    button2.className = "button";
    button2.innerHTML = "语音调度";
    button2.onclick = () => {
      this.voice(data);
    };
    var button3 = document.createElement("span");
    button3.className = "button";
    button3.innerHTML = "视频调度";
    button3.onclick = () => {
      this.video([data]);
    };
    top.appendChild(button1);
    top.appendChild(button2);
    top.appendChild(button3);
    info.appendChild(top);
    // 定义底部内容
    var bottom = document.createElement("div");
    bottom.className = "info-bottom";
    bottom.style.position = "relative";
    bottom.style.top = "-1px";
    bottom.style.margin = "0 auto";
    var sharp = document.createElement("img");
    sharp.src = "https://webapi.amap.com/images/sharp.png";
    bottom.appendChild(sharp);
    info.appendChild(bottom);
    return info;
  }
  //定义事件信息窗体
  createEventInfoWindow(data) {
    const { name, time, describe } = data;
    var content = [];
    content.push(
      "<div class='event-content-text'><div class='text center'>" +
        name +
        "</div><div class='text'>" +
        describe +
        "</div></div>"
    );
    content.join("<br/>");
    var info = document.createElement("div");
    info.className = "content-window-card";
    //可以通过下面的方式修改自定义窗体的宽高
    info.style.width = "200px";
    // 定义内容
    var middle = document.createElement("div");
    middle.className = "info-middle";
    middle.innerHTML = content;
    info.appendChild(middle);
    //定义详情
    var detail = document.createElement("div");
    detail.className = "detail-div";
    info.appendChild(detail);
    //定义关闭按钮
    var detail = document.createElement("div");
    detail.className = "close-div";
    var a = document.createElement("a");
    a.innerHTML = "x";
    // a.style.marginLeft = '95px';
    a.onclick = () => {
      this.state.map.clearInfoWindow();
    };
    detail.appendChild(a);
    info.appendChild(detail);

    var top = document.createElement("div");
    top.className = "info-button";
    info.appendChild(top);
    // 定义底部内容
    var bottom = document.createElement("div");
    bottom.className = "info-bottom";
    bottom.style.position = "relative";
    bottom.style.top = "-1px";
    bottom.style.margin = "0 auto";
    var sharp = document.createElement("img");
    sharp.src = "https://webapi.amap.com/images/sharp.png";
    bottom.appendChild(sharp);
    info.appendChild(bottom);
    return info;
  }
  //驻勤点的信息窗体
  createAttendanceInfoWindow(data) {
    const { name, taskAddress, idCardNo, perNum, mobilePhone, taskName } = data;
    var content = [];
    content.push(
      "<div><div class='atten-content-text'><div class='text head'>" +
        taskName +
        "</div><div class='text'>负责人：" +
        name +
        "</div><div class='text'>手机号码：" +
        mobilePhone +
        "</div><div class='text'>证件号码：" +
        idCardNo +
        "</div><div class='text'>地址：" +
        taskAddress +
        "</div><div class='text'>保安员数量：" +
        perNum +
        "名</div></div>"
    );
    content.join("<br/>");
    var info = document.createElement("div");
    info.className = "content-window-card";
    //可以通过下面的方式修改自定义窗体的宽高
    info.style.width = "300px";
    // 定义内容
    var middle = document.createElement("div");
    middle.className = "info-middle";
    middle.innerHTML = content;
    info.appendChild(middle);
    //定义详情
    var detail = document.createElement("div");
    detail.className = "detail-div";
    info.appendChild(detail);
    //定义关闭按钮
    var detail = document.createElement("div");
    detail.className = "close-div";
    var a = document.createElement("a");
    a.innerHTML = "x";
    a.onclick = () => {
      this.state.map.clearInfoWindow();
    };
    detail.appendChild(a);
    info.appendChild(detail);
    //定义三个调度按钮
    var top = document.createElement("div");
    top.className = "info-button";
    var button1 = document.createElement("span");
    button1.className = "button";
    button1.innerHTML = "保安人员位置详情";
    button1.onclick = () => {
      this.state.map.clearInfoWindow();
      this.setState({ selectedAttenData: data });
    };
    button1.style.borderRight = "unset";
    button1.style.background = "#50aaf7";
    button1.style.color = "#ffffff";
    top.appendChild(button1);
    info.appendChild(top);
    // 定义底部内容
    var bottom = document.createElement("div");
    bottom.className = "info-bottom";
    bottom.style.position = "relative";
    bottom.style.top = "-1px";
    bottom.style.margin = "0 auto";
    var sharp = document.createElement("img");
    sharp.src = "https://webapi.amap.com/images/sharp.png";
    bottom.appendChild(sharp);
    info.appendChild(bottom);
    return info;
  }
  //人员详细信息事件
  detail(perId) {
    this.setState({
      showDetail: true,
      personPerId: perId
    });
  }
  getMessageList(conversationID) {
    const { nextReqMessageID, currentMessageList } = this.props;
    tim
      .getMessageList({ conversationID, nextReqMessageID, count: 15 })
      .then(imReponse => {
        // 更新messageID，续拉时要用到
        this.props.dispatch({
          type: "im/updateCurrentConversationCont",
          payload: {
            nextReqMessageID: imReponse.data.nextReqMessageID,
            isCompleted: imReponse.data.isCompleted,
            currentMessageList: [
              ...imReponse.data.messageList,
              ...currentMessageList
            ] // 更新当前消息列表，从头部插入
          }
        });
      });
  }
  //视频调度（单人与多人）
  video(info = [], schedulingName = "个人") {
    //输入人员信息，调度名称
    const Members = [];
    info.map(item => {
      Members.push(item.mobilePhone);
    });
    const Room_No = Math.round(new Date() / 1000);
    this.setState({
      Room_No,
      MemberList: Members.join(",")
    });
    sendVideoRoomMsg({
      Room_No, //房间号
      MemberList: Members.join(","), //所有调度成员
      Yardman_Name: this.props.comName, //本人的公司名
      Yardman_Task_Name: schedulingName, //调度任务名称
      Yardman_Task_Explain: "" //调度任务说明(视频的时候不用填)
    }).then(res => {
      if (res.retType === "0") {
        this.state.map.clearInfoWindow();
        this.setState({
          createTaskStatus: false, //关掉任务创建页面
          videoStatus: true //把视频页面打开
        });
      }
    });
  }
  //文字调度事件（单人）
  character(info) {
    //添加会话（单人对单人）
    tim.getConversationProfile(`C2C${info.mobilePhone}`).then(({ data }) => {
      // 3.1 更新当前会话
      this.props.dispatch({
        type: `im/updateCurrentConversation`,
        payload: data.conversation
      });
      this.setState({
        conversationID: `C2C${info.mobilePhone}`,
        imStatus: true,
        selectedData: info, //这个会把搜索列表的红标记去掉
        needCreateConversation: true
      });
      // 3.2 获取消息列表
      this.getMessageList(data.conversation.conversationID);
      return Promise.resolve();
    },err=>{
      // message.error(err.toString())
    })
    this.state.map.clearInfoWindow();
  }
  //文字调度（多人，先创建群组）
  createGroup() {
    const Members = [];
    const memberList = [];
    Members.push(this.props.adminPhone + "admin");
    this.state.selectedPoints.map(item => {
      Members.push(item.mobilePhone);
      memberList.push({
        userID: item.mobilePhone + ""
      });
    });
    let options = {
      name: this.state.schedulingName,
      type: TIM.TYPES.GRP_PRIVATE,
      memberList
    };
    tim
      .createGroup(options)
      .then(info => {
        //创建成功之后，往里面发送一条消息
        this.sendTextMessage(info.data.group.groupID);
        this.setState({ selectedPointsStatus: false }); //关闭调度的窗口
      })
      .catch(err => {
        console.log(err);
      });
  }
  //语音调度（单人）单人的就是打开会话，然后调用录音
  voice(data) {
    this.setState({
      onlyPersonVoiceStatus: true,
      selectedData: data
    });
    this.state.map.clearInfoWindow();
  }
  //语音调度（多人）,//先创建一个群，录完音，在这个会话中发送该录音
  voiceGroup(url, time) {
    const memberList = [];
    this.state.selectedPoints.map(item => {
      memberList.push({
        userID: item.mobilePhone + ""
      });
    });
    let options = {
      name: this.state.schedulingName,
      type: TIM.TYPES.GRP_PRIVATE,
      memberList
    };
    tim
      .createGroup(options)
      .then(info => {
        //创建成功之后，往里面发送一条消息
        this.sendCustomMessage(
          info.data.group.groupID,
          url,
          time,
          TIM.TYPES.CONV_GROUP
        );
        this.state.map.remove([this.state.overlays]);
        this.state.map.clearInfoWindow();
        this.setState({ showRecord: false, selectedPointsStatus: false });
      })
      .catch(err => {
        console.log(err);
      });
  }
  //发送文字消息
  sendTextMessage(groupID) {
    const messageData = tim.createTextMessage({
      to: groupID,
      conversationType: TIM.TYPES.CONV_GROUP, //群组调度
      payload: { text: this.state.schedulingContent }
    });
    tim
      .sendMessage(messageData)
      .then(res => {
        //获取当前的会话
        this.getCurrentConvarsation(groupID);
      })
      .catch(err => {
        message.error("发送失败");
      });
  }
  //发送自定义消息
  sendCustomMessage(groupID, url, time, type) {
    const content = {
      url,
      time
    };
    const messageSound = tim.createCustomMessage({
      to: groupID,
      conversationType: type,
      payload: {
        data: "Sound", // 用于标识该消息是音频类型消息
        description: "[语音]", // 获取音频路径
        extension: JSON.stringify(content)
      }
    });
    tim
      .sendMessage(messageSound)
      .then(res => {
        if (type === TIM.TYPES.CONV_GROUP) {
          //获取群组当前的会话
          this.getCurrentConvarsation(groupID);
        } else {
          //获取个人当前的会话
          this.getMessageList(res.data.message.conversationID);
        }
      })
      .catch(err => {
        message.error("发送失败");
      });
  }
  //获取当前的会话
  getCurrentConvarsation(groupID) {
    tim.getConversationProfile(`GROUP${groupID}`).then(({ data }) => {
      console.log(data);
      // 3.1 更新当前会话
      this.props.dispatch({
        type: `im/updateCurrentConversation`,
        payload: data.conversation
      });
      this.setState({
        createTaskStatus: false,
        imStatus: true,
        conversationID: "GROUP" + groupID
      }); //打开im的会话框
      // 3.2 获取消息列表
      this.getMessageList(data.conversation.conversationID);
      return Promise.resolve();
    });
  }
  //获取当前会话的消息列表
  getMessageList(conversationID) {
    const { nextReqMessageID, currentMessageList } = this.props;
    tim
      .getMessageList({ conversationID, nextReqMessageID, count: 15 })
      .then(imReponse => {
        // 更新messageID，续拉时要用到
        this.props.dispatch({
          type: "im/updateCurrentConversationCont",
          payload: {
            nextReqMessageID: imReponse.data.nextReqMessageID,
            isCompleted: imReponse.data.isCompleted,
            currentMessageList: [
              ...imReponse.data.messageList,
              ...currentMessageList
            ] // 更新当前消息列表，从头部插入
          }
        });
      });
  }

  /******************************相关事件******************************/

  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <Container className="lalal">
        {/* 驻勤点图层 */}
        <div
          style={{
            width: innerWidth,
            // height: 'calc(100vh - 72px)',
            height: "calc(100vh)",
            display: this.state.layerSatatus === "attendance" ? "block" : "none"
          }}
          className="App"
          id="map_container"
        ></div>
        {/* 海量图图层 */}
        <div
          style={{
            width: innerWidth,
            height: "calc(100vh)",
            display: this.state.layerSatatus === "mass" ? "block" : "none"
          }}
          className="App"
          id="map_container2"
        ></div>
        {/* 人员图层 */}
        <div
          style={{
            width: innerWidth,
            height: "calc(100vh)",
            display: this.state.layerSatatus === "person" ? "block" : "none"
          }}
          className="App"
          id="map_container3"
        ></div>
        <div>
          {/* 驻勤点的搜索框 */}
          {this.state.map && (
            <AttendanceSearch
              layerSatatus={this.state.layerSatatus}
              selectedAttenData={this.state.selectedAttenData} //地图上点中的驻勤点
              clickAttenPersonIndex={this.state.clickAttenPersonIndex}
              iconData={this.state.iconData}
              activityNo={this.state.activityNo}
              attendanceList={attendanceList => {
                //对驻勤点进行打点
                this.markerAttendanceList(attendanceList);
                this.setState({
                  selectedAttenData: null
                });
              }}
              attenPersonList={attenPersonList => {
                //对人员进行打点
                this.setState({
                  attenPersonList
                });
                if (attenPersonList.length === 0) {
                  this.setState({
                    selectedAttenData: null
                  });
                }
                this.markerAttenPersonList(attenPersonList);
              }}
              onClickSearchPerson={(clickPersonData, index) => {
                const markers = this.state.attenPersonMarkers;
                markers.map((item, i) => {
                  if (i === index) {
                    markers[index].setContent(
                      '<div class="selected"><div class="amap_lib_placeSearch_poi poibox-icon">' +
                        index +
                        "</div></div>"
                    );
                    let infoWindow = new AMap.InfoWindow({
                      isCustom: true, //使用自定义窗体
                      content: this.createInfoWindow(clickPersonData),
                      offset: new AMap.Pixel(16, -45)
                    });
                    infoWindow.open(
                      this.state.map,
                      markers[index].getPosition()
                    );
                  } else {
                    markers[i].setContent(
                      '<div class="amap_lib_placeSearch_poi poibox-icon">' +
                        i +
                        "</div>"
                    );
                  }
                });
                this.setState({
                  attenPersonMarkers: markers
                });
                this.state.map.setCenter([
                  clickPersonData.lnglat[0],
                  clickPersonData.lnglat[1]
                ]);
              }}
              onClickSelectedAttenData={(selectedAttenList, index) => {
                if (!selectedAttenList.lnglat) {
                  return message.warning("该驻勤点暂未有经纬度信息");
                }
                if (selectedAttenList) {
                  let infoWindow = new AMap.InfoWindow({
                    isCustom: true, //使用自定义窗体
                    content: this.createAttendanceInfoWindow(selectedAttenList),
                    offset: new AMap.Pixel(16, -45)
                  });
                  infoWindow.open(this.state.map, selectedAttenList.lnglat);
                  this.state.map.setCenter(selectedAttenList.lnglat);
                }
              }}
              clickEventIndex={this.state.clickEventIndex}
              eventList ={(eventList) => {
                this.markerEventList(eventList);
              }}
              onClickEventData={(eventData, index) => {
                const markers = this.state.eventMarkers;
                markers.map((item, i) => {
                  if (i === index) {
                    markers[index].setContent(
                      '<div class="selected"><div class="amap_lib_placeSearch_poi poibox-icon">' +
                        index +
                        "</div></div>"
                    );
                    let infoWindow = new AMap.InfoWindow({
                      isCustom: true, //使用自定义窗体
                      content: this.createEventInfoWindow(eventData),
                      offset: new AMap.Pixel(16, -45)
                    });
                    infoWindow.open(
                      this.state.map,
                      markers[index].getPosition()
                    );
                  } else {
                    markers[i].setContent(
                      '<div class="amap_lib_placeSearch_poi poibox-icon">' +
                        i +
                        "</div>"
                    );
                  }
                });
                this.setState({
                  eventMarkers: markers,
                  clickEventIndex: index
                });
                this.state.map.setCenter(eventData.lnglat);

                // if (eventData) {
                //   let infoWindow = new AMap.InfoWindow({
                //     isCustom: true, //使用自定义窗体
                //     content: this.createEventInfoWindow(eventData),
                //     offset: new AMap.Pixel(16, -45)
                //   });
                //   infoWindow.open(this.state.map, eventData.lnglat);
                //   this.state.map.setCenter(eventData.lnglat);
                // }
              }}
            />
          )}
          {/* 人员的搜索框 */}
          <PersonSearch
            layerSatatus={this.state.layerSatatus}
            personClickIndex={this.state.personClickIndex}
            personList={(personList, where) => {
              this.markPersonList(personList, where);
              this.setState({ personList });
            }}
            onClickPerson={(e, index) => {
              //这是搜索列表中点击到的
              const markers = this.state.personMarkers;
              markers.map((item, i) => {
                if (e.perId === item.w.key) {
                  markers[i].setContent(
                    '<div class="selected"><div class="amap_lib_placeSearch_poi poibox-icon">' +
                    item.w.indexText +
                      "</div></div>"
                  );
                  let infoWindow = new AMap.InfoWindow({
                    isCustom: true, //使用自定义窗体
                    content: this.createInfoWindow(e),
                    offset: new AMap.Pixel(16, -45)
                  });
                  infoWindow.open(
                    this.state.personMap,
                    markers[i].getPosition()
                  );
                } else {
                  markers[i].setContent(
                    '<div class="amap_lib_placeSearch_poi poibox-icon">' +
                    item.w.indexText +
                      "</div>"
                  );
                }
              });
              this.setState({
                personMarkers: markers
              });
              this.state.personMap.setCenter([e.lnglat[0], e.lnglat[1]]);
            }}
            markesBeiJing={() => {
              //驻点北京
              var marker = new AMap.Marker({
                position: new AMap.LngLat(116.344081, 39.940512) // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
              });
              this.setState({
                beijingMarkers: marker
              });
              this.state.map.add(marker);
              this.state.map.setFitView(marker);
            }}
            markesGaoQi={() => {
              //驻点高崎
              var marker = new AMap.Marker({
                position: new AMap.LngLat(118.12902, 24.533153) // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
              });
              this.setState({
                gaoqiMarkers: marker
              });
              this.state.map.add(marker);
              this.state.map.setCenter([118.12902, 24.533153]);
            }}
            beijingVideo={value => {
              this.setState({
                beijingVideo: value
              });
            }}
          />
          {/* 绘制矢量图 */}
          <Vectorgraph
            changeSelect={e => {
              this.setState({
                paintValue: e
              });
              this.state.map.clearInfoWindow();
              switch (e) {
                case "circle":
                  this.state.mouseTool.circle({
                    fillColor: "#00b0ff",
                    strokeColor: "#80d8ff"
                  });
                  break;
                case "rectangle":
                  this.state.mouseTool.rectangle({
                    fillColor: "#00b0ff",
                    strokeColor: "#80d8ff"
                  });
                  break;
                case "polygon":
                  this.state.mouseTool.polygon({
                    fillColor: "#00b0ff",
                    strokeColor: "#80d8ff"
                  });
                  break;
                case "cancel":
                  this.state.mouseTool.close(true);
                  break;
              }
            }}
            paintValue={this.state.paintValue}
          />
          {/* 打开会话按钮 */}
          <div className="radio_container-open">
            <Icon
              className="icon-fold"
              type={this.state.imStatus ? "menu-unfold" : "menu-fold"}
              onClick={() => {
                this.setState({ imStatus: !this.state.imStatus });
                this.state.map.clearInfoWindow();
              }}
              style={{ fontSize: "30px", color: "#4285EC" }}
            />
          </div>
          {/* 地图切换 */}
          <SwitchMap
            layerSatatus={this.state.layerSatatus}
            switchMap={value => {
              this.switchMap(value);
            }}
          />
          <Detail
            visible={this.state.showDetail}
            perId={this.state.personPerId}
          ></Detail>
          {/* 调度人数确认 */}
          <Modal
            className="selected-points-modal"
            // title="调度"
            visible={this.state.selectedPointsStatus}
            onOk={this.handleOk}
            onCancel={() => {
              this.setState({ selectedPointsStatus: false });
              this.state.map.remove([this.state.overlays]);
            }}
            footer={[
              <span style={{ float: "left" }} key="number">
                共选中{this.state.selectedPoints.length}人
              </span>,
              <Button
                key="text"
                type="primary"
                onClick={() => {
                  const that = this;
                  //超过50人
                  if (
                    this.state.selectedPoints.length > 50 &&
                    this.state.selectedPoints.length < 100
                  ) {
                    Modal.confirm({
                      title: "提示",
                      content:
                        "您调度人员已经超过50人，建议减少人数已达到调度效果。",
                      okText: "继续调度",
                      onOk() {
                        that.setState({
                          selectedPointsStatus: false,
                          createTaskStatus: true
                        });
                      },
                      cancelText: "重新选择",
                      onCancel() {
                        that.setState({ selectedPointsStatus: false });
                        that.state.map.remove([that.state.overlays]);
                      }
                    });
                  } else if (this.state.selectedPoints.length > 100) {
                    Modal.error({
                      title: "提示",
                      content:
                        "您调度人员已经超过100人，请减少人数已达到调度效果。",
                      okText: "重新选择",
                      onOk() {
                        that.setState({ selectedPointsStatus: false });
                        that.state.map.remove([that.state.overlays]);
                      }
                    });
                  } else {
                    this.setState({
                      selectedPointsStatus: false,
                      createTaskStatus: true,
                      dispatchType: "text"
                    });
                  }
                }}
              >
                文字调度
              </Button>,
              <Button
                key="voice"
                type="primary"
                onClick={() => {
                  this.setState({
                    dispatchType: "voice",
                    selectedPointsStatus: false,
                    createTaskStatus: true
                  });
                }}
              >
                语音调度
              </Button>,
              <Button
                key="video"
                type="primary"
                onClick={() => {
                  this.setState({
                    dispatchType: "video",
                    selectedPointsStatus: false,
                    createTaskStatus: true
                  });
                }}
              >
                视频调度
              </Button>
            ]}
          >
            <div>
              <Row gutter={24}>
                {this.state.selectedPoints.map((item, index) => {
                  return (
                    <Col span={12} key={index}>
                      <div
                        className="content-window-card"
                        style={{ marginBottom: 10 }}
                      >
                        <div className="info-middle">
                          {item.photoUrl ? (
                            <img className="avator" src={item.photoUrl}></img>
                          ) : (
                            <span className="avator span-header">
                              {item.name
                                ? item.name.substring(
                                    item.name.length - 2,
                                    item.name.length
                                  )
                                : ""}
                            </span>
                          )}
                          <div className="text">
                            <div className="name">{item.name}</div>
                            <div>手机号：{item.mobilePhone}</div>
                            <div>证件号码：{item.idCardNo}</div>
                          </div>
                        </div>
                      </div>
                    </Col>
                  );
                })}
              </Row>
            </div>
          </Modal>
          {/* 调度任务创建 */}
          <Modal
            className="create-task-modal"
            // title="调度任务创建"
            visible={this.state.createTaskStatus}
            // visible={true}
            onOk={this.handleOk}
            onCancel={() => {
              this.setState({ createTaskStatus: false });
              this.state.map.remove([this.state.overlays]);
            }}
            footer={
              //语音调度的时候，不需要取消、开始调度按钮
              this.state.dispatchType === "voice"
                ? ""
                : [
                    <Button
                      key="voice"
                      onClick={() => {
                        this.setState({ createTaskStatus: false });
                        this.state.map.remove([this.state.overlays]);
                      }}
                    >
                      取消调度
                    </Button>,
                    <Button
                      key="text"
                      type="primary"
                      onClick={() => {
                        if (this.state.dispatchType === "text") {
                          if (this.state.schedulingName.trim().length === 0) {
                            message.warning("请输入调度任务名称");
                          } else if (
                            this.state.schedulingContent.trim().length === 0
                          ) {
                            message.warning("请输入调度任务内容");
                          } else {
                            this.state.map.remove([this.state.overlays]);
                            //输入的数据都没有错的时候，开始文字调度（创建群组）
                            this.createGroup();
                          }
                        }
                        if (this.state.dispatchType === "voice") {
                          //语音调度
                        }
                        if (this.state.dispatchType === "video") {
                          if (this.state.schedulingName.trim().length === 0) {
                            message.warning("请输入调度任务名称");
                          } else {
                            this.state.map.remove([this.state.overlays]);
                            this.state.map.clearInfoWindow();
                            //开始视频调度
                            this.video(
                              this.state.selectedPoints,
                              this.state.schedulingName.trim()
                            ); //选中的人员，调度任务名称
                          }
                        }
                      }}
                    >
                      开始调度
                    </Button>
                  ]
            }
          >
            <div>
              <div className="photo">
                {this.state.selectedPoints.map((item, index) => {
                  return (
                    <div className="gutter-row" key={index}>
                      <div className="gutter-box">
                        {item.photoUrl ? (
                          <img className="avator" src={item.photoUrl}></img>
                        ) : (
                          <span className="avator span-header">
                            {item.name
                              ? item.name.substring(
                                  item.name.length - 2,
                                  item.name.length
                                )
                              : ""}
                          </span>
                        )}
                        <div className="name">{item.name}</div>
                      </div>
                    </div>
                  );
                })}
              </div>
              <div className="dispatch-content">
                <h2>
                  {this.state.dispatchType === "text"
                    ? "文字调度"
                    : this.state.dispatchType === "voice"
                    ? "语音调度"
                    : this.state.dispatchType === "video"
                    ? "视频调度"
                    : ""}
                </h2>
                <Form.Item
                  {...formItemLayout}
                  label="调度任务名称"
                  style={{ marginTop: 24 }}
                >
                  {getFieldDecorator("schedulingName", {
                    rules: [
                      {
                        required: true,
                        message: "请输入调度任务名称"
                      }
                    ]
                  })(
                    <Input
                      onChange={e => {
                        this.setState({
                          schedulingName: e.target.value
                        });
                      }}
                    ></Input>
                  )}
                </Form.Item>
                {/* 如果是文字调度，需要填调度任务内容 */}
                {this.state.dispatchType === "text" ? (
                  <Form.Item
                    {...formItemLayout}
                    label="调度任务内容"
                    style={{ marginTop: 24 }}
                  >
                    {getFieldDecorator("schedulingContent", {
                      rules: [
                        {
                          required: true,
                          message: "请输入调度任务内容"
                        }
                      ]
                    })(
                      <TextArea
                        rows={4}
                        onChange={e => {
                          this.setState({
                            schedulingContent: e.target.value
                          });
                        }}
                      />
                    )}
                  </Form.Item>
                ) : //如果是语音调度，需要有语音弹框
                this.state.dispatchType === "voice" ? (
                  <div className="video">
                    {this.state.showRecord ? (
                      <Record
                        where="index"
                        sendSound={(url, time) => {
                          //点击了发送
                          if (this.state.schedulingName.trim().length === 0) {
                            message.warning("请输入调度任务名称");
                          } else {
                            //创建音频的群组
                            this.voiceGroup(url, time);
                          }
                        }}
                        startRecord={this.state.showRecord}
                      />
                    ) : (
                      <div>
                        <span
                          className="video-button"
                          onClick={() => {
                            this.setState({
                              showRecord: true
                            });
                          }}
                        >
                          <Icon
                            type="audio"
                            style={{ color: "#ffffff", fontSize: "45px" }}
                          />
                        </span>
                        <div className="warning">请点击按钮开始录音</div>
                      </div>
                    )}
                  </div>
                ) : (
                  //视频调度不需要
                  ""
                )}
              </div>
            </div>
          </Modal>
          {/* im可视化页面 */}
          {this.state.imStatus && (
            <IM
              visible={this.state.imStatus}
              closeClick={() => {
                this.setState({ imStatus: !this.state.imStatus });
              }}
              conversationID={this.state.conversationID}
            ></IM>
          )}
          {/* IM视频页面 */}
          {this.state.videoStatus && (
            <Video
              Room_No={this.state.Room_No}
              mobilePhone={this.props.mobilePhone}
              imSig={this.props.imSig}
              closeVideoState={() => {
                this.setState({
                  videoStatus: !this.state.videoStatus
                });
              }}
              schedulingName={this.state.schedulingName}
            ></Video>
          )}
          {/* 驻勤点的类型选择 */}
          {this.state.map && (
            <AttendanceType
              layerSatatus={this.state.layerSatatus}
              attendanceList={(attendanceList, typeName) => {
                this.markerAttendanceList(attendanceList, typeName);
              }}
              activityNo={this.state.activityNo}
              removeORshow={(typeName, isClick) => {
                if (isClick) {
                  //把之前的驻勤点增加
                  this.state.map.add(this.state[typeName]);
                } else {
                  //把该类型的驻勤点删掉
                  this.state.map.remove(this.state[typeName]);
                }
              }}
              iconData={iconData => {
                this.setState({ iconData }); //驻勤点那些打点的图标
              }}
            />
          )}

          {/* 单人的语音调度调起的录音页面 */}
          {this.state.onlyPersonVoiceStatus && (
            <div className="only-person-voice">
              <div className="avatar-header">
                {this.state.selectedData.photoUrl ? (
                  <img src={this.state.selectedData.photoUrl}></img>
                ) : (
                  <span className="img-span">
                    {this.state.selectedData.name.substring(
                      this.state.selectedData.name.length - 2,
                      this.state.selectedData.name.length
                    )}
                  </span>
                )}
                <span className="label-voice">语音调度</span>
                <div
                  className="close"
                  onClick={() => {
                    this.setState({
                      onlyPersonVoiceStatus: false
                    });
                  }}
                >
                  x
                </div>
              </div>
              <Record
                where="index"
                sendSound={(url, time) => {
                  //点击了发送
                  //关掉单人的录音页面
                  this.setState({
                    onlyPersonVoiceStatus: false
                  });
                  tim
                    .getConversationProfile(
                      `C2C${this.state.selectedData.mobilePhone}`
                    )
                    .then(({ data }) => {
                      // 3.1 更新当前会话
                      this.props.dispatch({
                        type: `im/updateCurrentConversation`,
                        payload: data.conversation
                      });
                      this.setState({
                        conversationID: `C2C${this.state.selectedData.mobilePhone}`,
                        imStatus: true,
                        needCreateConversation: true
                      });
                      //发送单人的语音
                      this.sendCustomMessage(
                        this.state.selectedData.mobilePhone + "",
                        url,
                        time,
                        TIM.TYPES.CONV_C2C
                      );
                      return Promise.resolve();
                    });
                }}
              />
            </div>
          )}
          {/* 北京展览馆视频 */}
          {this.state.beijingVideo ? (
             <BeijingVideo changeBeijingVideo={(value) => this.setState({ beijingVideo: value })}/>
          ) : (
            ""
          )}
        </div>
      </Container>
    );
  }
}

const Container = style.div`
              width:100%;
              height:100%;
            `;
