import { data } from "../GIS/SearchListTab/Attendance/TypeData";
import CreateMassAttenInfoWindow from "../mapModule/messageWindow/CreateMassAttenInfoWindow";
import { getPerInfoList,policeGetTaskById } from "../../../services/api";
//打点（人员跟驻勤点的样式）

//人员图层对搜索出的人员打点
export function markPersonList(personList, where = "") {
  // where代表搜索的值，“软件园三期”“百川信”有特殊的打点位置需求
  if (!!this.state.personMarkers) {
    this.state.map.remove(this.state.personMarkers);
  }
  if (this.state.beijingMarkers) {
    this.state.map.remove(this.state.beijingMarkers);
  }
  if (this.state.gaoqiMarkers) {
    this.state.map.remove(this.state.gaoqiMarkers);
  }
  let personMarkers = [];
  personList.length > 0 &&
    personList.map((item, index) => {
      const map = this.state.map;
      if (item.lnglat) {
        var marker = new AMap.Marker({
          position: new AMap.LngLat(item.lnglat[0], item.lnglat[1]), // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
          title: "负责人:" + item.name || "--",
          content:
            '<div class="amap_lib_placeSearch_poi poibox-icon">' +
            index +
            "</div>",
          key: item.perId,
          indexText: index,
        });
        const that = this;
        //手动驻的点给点击事件
        AMap.event.addListener(marker, "click", function () {
          that.props.dispatch({
            type: "command/setPersonSelectIndex",
            payload: marker.w.key,
          });
          that.openPersonInfo(item, map, marker);
        });
        marker.setAnimation("AMAP_ANIMATION_DROP");
        personMarkers.push(marker);
      }
    });
  this.state.map.add(personMarkers);
  if (where === "厦门软件园三期" || where === "软件园三期") {
    let allMark = [];
    //假的点,用来居中到软三的作用
    var marker1 = new AMap.Marker({
      position: new AMap.LngLat(118.051211, 24.60608), // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
    });
    allMark.push(marker1);
    var marker2 = new AMap.Marker({
      position: new AMap.LngLat(118.047843, 24.611016), // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
    });
    allMark.push(marker2);
    this.state.map.setFitView(allMark);
  } else {
    this.state.map.setFitView(personMarkers); //自适应显示所有的标注点
  }
  return personMarkers;
  // this.setState({ personMarkers });
}

//人员的打点更换
export function openPersonInfo(item, map, marker) {
  let infoWindow = new AMap.InfoWindow({
    isCustom: true, //使用自定义窗体
    content: this.createInfoWindow(item),
    offset: new AMap.Pixel(16, -45),
  });
  infoWindow.open(this.state.map, marker.getPosition());
  const markers = this.state.personMarkers;
  markers.map((itemMark, i) => {
    if (itemMark.w.key === item.perId) {
      markers[i].setContent(
        '<div class="selected"><div class="amap_lib_placeSearch_poi poibox-icon">' +
          itemMark.w.indexText +
          "</div></div>"
      );
    } else {
      markers[i].setContent(
        '<div class="amap_lib_placeSearch_poi poibox-icon">' +
          itemMark.w.indexText +
          "</div>"
      );
    }
  });
  this.state.map.setZoomAndCenter(this.state.zoom, [
    marker.getPosition().lng,
    marker.getPosition().lat,
  ]); //同时设置地图层级与中心点
  // this.state.map.setCenter(marker.getPosition());//设置中心点
  // this.setState({
  //   personMarkers: markers,
  // });
  return markers;
}

//人员的打点更换图标，切换成未打点状态
export function closePersonMarkers() {
  const markers = this.state.personMarkers;
  markers.map((itemMark, i) => {
    markers[i].setContent(
      '<div class="amap_lib_placeSearch_poi poibox-icon">' +
        itemMark.w.indexText +
        "</div>"
    );
  });
  return markers;
}

//搜索出的驻勤点打点
export function markerAttendanceList(attendanceList, typeName = "") {
  //先删除之前的打点
  if (!!this.state.attendanceMarkers) {
    //如果是搜索列表的打点，先删除之前地图上的搜索的驻勤标记
    this.state.map.remove(this.state.attendanceMarkers);
  }
  let attendanceMarkers = [];
  const length = attendanceList.length;
  if (length > 0) {
    for (let i = 0; i < length; i++) {
      if (attendanceList[i].lnglat) {
        var marker = new AMap.Marker({
          position: new AMap.LngLat(
            attendanceList[i].lnglat[0],
            attendanceList[i].lnglat[1]
          ), // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
          title: "负责人:" + attendanceList[i].name || "--",
          content: attendanceList[i].markerIcon
            ? '<div class="amap_lib_placeSearch_poi poibox-icon mark-icon" style="background:url(' +
              attendanceList[i].markerIcon +
              ')">' +
              "</div>"
            : '<div class="amap_lib_placeSearch_poi poibox-icon">' + "</div>",
          comTaskId: attendanceList[i].comTaskId,
          markerIcon: attendanceList[i].markerIcon,
          clickMarkerIcon: attendanceList[i].clickMarkerIcon,
        });
        marker.setAnimation("AMAP_ANIMATION_DROP");
        const that = this;
        //手动驻的点给点击事件
        AMap.event.addListener(marker, "click", function () {
          that.props.dispatch({
            type: "command/setSelectIndex",
            payload: i,
          });
        });
        attendanceMarkers.push(marker);
      }
    }
  }
  this.state.map.add(attendanceMarkers);
  this.state.map.setFitView(attendanceMarkers); //自适应显示所有的标注点
  return attendanceMarkers;
  // this.setState({ attendanceMarkers });
}

//驻勤点的打点更换
export function openAttendanceInfo(item, map, marker,currentIndex,afterIndex) {
  let infoWindow = new AMap.InfoWindow({
    isCustom: true, //使用自定义窗体
    content: this.createAttendanceInfoWindow(item),
    offset: new AMap.Pixel(16, -45),
  });
  infoWindow.open(map, marker.getPosition());
  map.setZoomAndCenter(this.state.zoom, [item.lnglat[0], item.lnglat[1]]); //同时设置地图层级与中心点
  const markers = this.state.attendanceMarkers;
  // markers.map((itemMark, i) => {
  //   if (itemMark.w.comTaskId == item.comTaskId) {
      markers[currentIndex].setContent(
        '<div class="amap_lib_placeSearch_poi poibox-icon mark-icon" style="background:url(' +
        markers[currentIndex].w.clickMarkerIcon +
          ')">' +
          "</div>"
      );
  //   } else {
    if(afterIndex!=null&&afterIndex!=currentIndex){
      console.log("进来")
        markers[afterIndex].setContent(
        '<div class="amap_lib_placeSearch_poi poibox-icon mark-icon" style="background:url(' +
        markers[afterIndex].w.markerIcon +
          ')">' +
          "</div>"
      );
    }
    
  //   }
  // });
  // this.setState({
  //   attendanceMarkers: markers,
  // });
  return markers;
}

//驻勤点的打点更换图标，切换成未打点状态
export function closeAttendanceMarker() {
  const markers = this.state.attendanceMarkers;
  markers.map((itemMark, i) => {
    markers[i].setContent(
      '<div class="amap_lib_placeSearch_poi poibox-icon mark-icon" style="background:url(' +
        itemMark.w.markerIcon +
        ')">' +
        "</div>"
    );
  });
  // this.setState({
  //   attendanceMarkers: markers,
  // });
  return markers;
}

//海量驻勤点的打点(多的)
export function massAttendancePoint(attendaceList) {
  var cluster,
    markers = [];
  const length = attendaceList.length;
  for (var i = 0; i < length; i += 1) {
    const marker = new AMap.Marker({
      position: new AMap.LngLat(
        attendaceList[i].lnglat[0],
        attendaceList[i].lnglat[1]
      ), // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
      // title: "负责人:" + attendaceList[i].name || "--",
      content:
        '<div class="amap_lib_placeSearch_poi poibox-icon mark-icon" style="background:url(' +
        data[data.length - 1].markerIcon +
        ')">' +
        "</div>",
      comTaskId: attendaceList[i].comTaskId,
    });
    markers.push(marker);
    const _this = this;
    // const currentValue = attendaceList[i];
    AMap.event.addListener(marker, "click", function () {
      // let infoWindow = new AMap.InfoWindow({
      //   isCustom: true, //使用自定义窗体
      //   content: CreateMassAttenInfoWindow(currentValue, _this.state.map),
      //   offset: new AMap.Pixel(16, -45),
      // });
      // infoWindow.open(_this.state.map, marker.getPosition());
      policeGetTaskById({ comTaskId: marker.w.comTaskId }).then((res) => {
        if (res.retType == "0") {
          let infoWindow = new AMap.InfoWindow({
            isCustom: true, //使用自定义窗体
            content: CreateMassAttenInfoWindow.call(this,res.data, _this.state.map),
            offset: new AMap.Pixel(16, -45),
          });
          infoWindow.open(_this.state.map, marker.getPosition());
        }
      });
    });
  }

  var count = markers.length;
  var _renderClusterMarker = function (context) {
    var factor = Math.pow(context.count / count, 1 / 18);
    var div = document.createElement("div");
    var Hue = 180 - factor * 180;
    var bgColor = "hsla(" + Hue + ",100%,50%,0.7)";
    var fontColor = "hsla(" + Hue + ",100%,20%,1)";
    var borderColor = "hsla(" + Hue + ",100%,40%,1)";
    var shadowColor = "hsla(" + Hue + ",100%,50%,1)";
    div.style.backgroundColor = bgColor;
    var size = Math.round(30 + Math.pow(context.count / count, 1 / 5) * 20);
    div.style.width = div.style.height = size + "px";
    div.style.border = "solid 1px " + borderColor;
    div.style.borderRadius = size / 2 + "px";
    div.style.boxShadow = "0 0 1px " + shadowColor;
    div.innerHTML = context.count;
    div.style.lineHeight = size + "px";
    div.style.color = fontColor;
    div.style.fontSize = "14px";
    div.style.textAlign = "center";
    context.marker.setOffset(new AMap.Pixel(-size / 2, -size / 2));
    context.marker.setContent(div);
  };

  if (cluster) {
    cluster.setMap(null);
  }
  cluster = new AMap.MarkerClusterer(this.state.map, markers, {
    gridSize: 80,
    renderClusterMarker: _renderClusterMarker,
  });
  // for (let i = 0; i < attendaceList.length; i++) {
  //   for (let j = 0; j < data.length; j++) {
  //     if (attendaceList[i].taskStationType == data[j].key) {
  //       attendaceList[i].name = data[j].title;
  //       attendaceList[i].markerIcon = data[j].markerIcon;
  //       attendaceList[i].clickMarkerIcon = data[j].clickMarkerIcon;
  //       break;
  //     }
  //   }
  //   //如果没有就用默认的值
  //   if (!attendaceList[i].markerIcon) {
  //     attendaceList[i].markerIcon = data[data.length - 1].markerIcon;
  //     attendaceList[i].clickMarkerIcon = data[data.length - 1].clickMarkerIcon;
  //   }
  // }
  // console.log(attendaceList);
  // let attendanceMarkers = [];
  // const length = attendaceList.length;
  // for (let i = 0; i < length; i++) {
  //   if (attendaceList[i].lnglat) {
  //     var marker = new AMap.Marker({
  //       position: new AMap.LngLat(
  //         attendaceList[i].lnglat[0],
  //         attendaceList[i].lnglat[1]
  //       ), // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
  //       title: "负责人:" + attendaceList[i].name || "--",
  //       content: attendaceList[i].markerIcon
  //         ? '<div class="amap_lib_placeSearch_poi poibox-icon mark-icon" style="background:url(' +
  //           attendaceList[i].markerIcon +
  //           ')">' +
  //           "</div>"
  //         : '<div class="amap_lib_placeSearch_poi poibox-icon">' + "</div>",
  //       comTaskId: attendaceList[i].comTaskId,
  //       markerIcon: attendaceList[i].markerIcon,
  //       clickMarkerIcon: attendaceList[i].clickMarkerIcon,
  //     });
  //     marker.setAnimation("AMAP_ANIMATION_DROP");
  //     const that = this;
  //     //手动驻的点给点击事件
  //     AMap.event.addListener(marker, "click", function () {
  //       console.log(marker);
  //       let infoWindow = new AMap.InfoWindow({
  //         isCustom: true, //使用自定义窗体
  //         content: CreateMassAttenInfoWindow(attendaceList[i], that.state.map),
  //         offset: new AMap.Pixel(16, -45),
  //       });
  //       infoWindow.open(that.state.map, marker.getPosition());
  //     });
  //     attendanceMarkers.push(marker);
  //   }
  // }
  // this.state.map.add(attendanceMarkers);
}

//海量人员数据的打点（多的）
export function massPersonPoint(personList) {
  var cluster,
    markers = [];
  const length = personList.length;
  for (var i = 0; i < length; i += 1) {
    const marker = new AMap.Marker({
      position: personList[i]["lnglat"],
      content: '<div class="amap_lib_placeSearch_poi poibox-icon"></div>',
      // content:
      //   '<div style="background-color: hsla(180, 100%, 50%, 0.7); height: 24px; width: 24px; border: 1px solid hsl(180, 100%, 40%); border-radius: 12px; box-shadow: hsl(180, 100%, 50%) 0px 0px 1px;"></div>',
      offset: new AMap.Pixel(-15, -15),
      perId: personList[i]["perId"],
    });
    markers.push(marker);
    const _this = this;
    AMap.event.addListener(marker, "click", function () {
      getPerInfoList({ perIds: marker.w.perId }).then((res) => {
        if (res.retType == "0") {
          let infoWindow = new AMap.InfoWindow({
            isCustom: true, //使用自定义窗体
            content: _this.createInfoWindow(res.data[0]),
            offset: new AMap.Pixel(12, -30),
          });
          infoWindow.open(_this.state.map, marker.getPosition());
        }
      });
    });
  }

  var count = markers.length;
  var _renderClusterMarker = function (context) {
    var factor = Math.pow(context.count / count, 1 / 18);
    var div = document.createElement("div");
    var Hue = 180 - factor * 180;
    var bgColor = "hsla(" + Hue + ",100%,50%,0.7)";
    var fontColor = "hsla(" + Hue + ",100%,20%,1)";
    var borderColor = "hsla(" + Hue + ",100%,40%,1)";
    var shadowColor = "hsla(" + Hue + ",100%,50%,1)";
    div.style.backgroundColor = bgColor;
    var size = Math.round(30 + Math.pow(context.count / count, 1 / 5) * 20);
    div.style.width = div.style.height = size + "px";
    div.style.border = "solid 1px " + borderColor;
    div.style.borderRadius = size / 2 + "px";
    div.style.boxShadow = "0 0 1px " + shadowColor;
    div.innerHTML = context.count;
    div.style.lineHeight = size + "px";
    div.style.color = fontColor;
    div.style.fontSize = "14px";
    div.style.textAlign = "center";
    context.marker.setOffset(new AMap.Pixel(-size / 2, -size / 2));
    context.marker.setContent(div);
  };

  if (cluster) {
    cluster.setMap(null);
  }
  cluster = new AMap.MarkerClusterer(this.state.map, markers, {
    gridSize: 80,
    renderClusterMarker: _renderClusterMarker,
  });
}
